/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels.wizards;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.expression.field.ExpressionField;
import com.ur.swing.expression.field.ExpressionNodeProperty;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.ValueConverter;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.swing.HTML;
import com.ur.view.program.CommandPanel;
import gui.program.DirectionNode;
import gui.program.validation.AccelerationValidationStrategyProvider;
import gui.program.validation.SpeedValidationStrategyProvider;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class DirectionCard
extends CommandPanel<DirectionNode> {
    public static final int MIN_DISTANCE = 0;
    private static final Length MAX_DISTANCE = Length.from((double)1500.0, (Length.Unit)Length.Unit.MM);
    private final SpeedValidationStrategyProvider speedValidationStrategyProvider;
    private final AccelerationValidationStrategyProvider accelerationValidation;
    private JCheckBox stopDistanceCheckBox;
    private JCheckBox stopExpressionCheckBox;
    private NumberField speedField;
    private NumberField accelerationField;
    private NumberField distanceValue;
    private final ViewContext viewContext;
    private final ExpressionField expEdit;

    @Inject
    DirectionCard(ViewContext viewContext, ExpressionField expEditor, SpeedValidationStrategyProvider speedValidationStrategyProvider, AccelerationValidationStrategyProvider accelerationValidationStrategyProvider) {
        super(DirectionNode.class);
        this.viewContext = viewContext;
        this.expEdit = expEditor;
        this.speedValidationStrategyProvider = speedValidationStrategyProvider;
        this.accelerationValidation = accelerationValidationStrategyProvider;
        this.initComponents();
        this.bindNumberPickers((TextResource)viewContext.getTextResource(TextResource.class));
        this.assignHelpIds();
    }

    private void bindNumberPickers(TextResource textResource) {
        ValueConverter converter = UnitsValueConverterFactory.getLengthConverter();
        double maxDistance = PrimitiveUtils.parseDouble((String)((String)converter.fromModel((Object)MAX_DISTANCE)));
        String errorMessageForDistance = textResource.errorDistanceValueRange(0, (int)maxDistance, converter.getUnit());
        ValidationStrategy distanceValidationStrategy = ValidationFactory.getRangeValidator((double)0.0, (double)maxDistance, (String)errorMessageForDistance);
        this.distanceValue.setErrorValidationStrategy(new ValidationStrategy[]{distanceValidationStrategy});
    }

    private void assignHelpIds() {
        this.viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:direction");
    }

    @Override
    protected void updateCard() {
        DirectionNode node = (DirectionNode)this.getNode();
        this.expEdit.setNodeWithExpression((ExpressionNodeProperty)node);
        this.speedField.setValue((Object)node.getSpeed());
        this.accelerationField.setValue((Object)node.getAcceleration());
        this.distanceValue.setValue((Object)Length.from((double)node.getMaxDistance(), (Length.Unit)Length.Unit.SI));
        this.stopDistanceCheckBox.setSelected(node.isStopAtDistance());
        this.stopExpressionCheckBox.setSelected(node.isStopAtExpression());
        this.expEdit.setEnabled(node.isStopAtExpression());
        if (node.isCartesianMotion()) {
            this.speedField.setErrorValidationStrategy(new ValidationStrategy[]{this.speedValidationStrategyProvider.getCartesianJointSpeedLimitValidator()});
            this.accelerationField.setErrorValidationStrategy(new ValidationStrategy[]{this.accelerationValidation.getCartesianJointAccelerationLimitValidator()});
        } else {
            this.speedField.setErrorValidationStrategy(new ValidationStrategy[]{this.speedValidationStrategyProvider.getJointSpeedLimitValidator()});
            this.accelerationField.setErrorValidationStrategy(new ValidationStrategy[]{this.accelerationValidation.getJointAccelerationLimitValidator()});
        }
    }

    private void initComponents() {
        TextResource text = (TextResource)this.viewContext.getTextResource(TextResource.class);
        this.speedField = new NumberField(UnitsValueConverterFactory.getSpeedConverter());
        this.speedField.setUnitWidth(55);
        this.speedField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((DirectionNode)DirectionCard.this.getNode()).setSpeed((Speed)DirectionCard.this.speedField.getValue());
            }
        });
        this.accelerationField = new NumberField(UnitsValueConverterFactory.getAccelerationConverter());
        this.accelerationField.setUnitWidth(55);
        this.accelerationField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((DirectionNode)DirectionCard.this.getNode()).setAcceleration((Acceleration)DirectionCard.this.accelerationField.getValue());
            }
        });
        this.distanceValue = new NumberField(UnitsValueConverterFactory.getLengthConverter());
        this.distanceValue.setUnitWidth(80);
        this.distanceValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double length = ((Length)DirectionCard.this.distanceValue.getValue()).asDouble();
                ((DirectionNode)DirectionCard.this.getNode()).setMaxDistance(length);
            }
        });
        this.expEdit.setHorizontalAlignment(0);
        this.expEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((DirectionNode)DirectionCard.this.getNode()).textHasChanged();
            }
        });
        this.stopDistanceCheckBox = new JCheckBox(text.stopAfterXxx());
        this.stopDistanceCheckBox.setFocusable(false);
        this.stopDistanceCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ((DirectionNode)DirectionCard.this.getNode()).setStopAtDistance(evt.getStateChange() == 1);
            }
        });
        this.stopExpressionCheckBox = new JCheckBox(text.stopWhenXxx());
        this.stopExpressionCheckBox.setFocusable(false);
        this.stopExpressionCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ((DirectionNode)DirectionCard.this.getNode()).setStopAtExpression(evt.getStateChange() == 1);
            }
        });
        JButton resetDefaultToValues = new JButton(text.resetToDefaults());
        resetDefaultToValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ((DirectionNode)DirectionCard.this.getNode()).resetToDefaults();
                DirectionCard.this.updateCard();
            }
        });
        CommandNamesResource command = (CommandNamesResource)this.viewContext.getTextResource(CommandNamesResource.class);
        this.setLayout(new BorderLayout());
        this.add(this.viewContext.createFormBuilder().headerLabel(command.Direction(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_8_COLUMNS}).end().description(text.commandDirection(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_8_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end(2).component((JComponent)this.stopDistanceCheckBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.distanceValue, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)this.stopExpressionCheckBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.expEdit, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().getPanel(), "North");
        this.add(this.viewContext.createFormBuilder().spacer(4).label(HTML.fontBold((String)text.sharedParameters()), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().spacer(4).label(text.toolSpeed(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.speedField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().spacer(4).label(text.toolAcceleration(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.accelerationField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end(2).buttonRow((JComponent)resetDefaultToValues, new FormBuilder.PanelConstraints[0]).end().getPanel(), "South");
    }
}

