/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels.wizards;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.view.program.CommandPanel;
import gui.program.PalletNode;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;

public class PalletCard
extends CommandPanel<PalletNode> {
    private final ViewContext viewContext;
    private JCheckBox sequenceAfterEndCheckBox;
    private JCheckBox sequenceBeforeStartChekcBox;

    @Inject
    PalletCard(ViewContext viewContext) {
        super(PalletNode.class);
        this.viewContext = viewContext;
        this.initComponents();
        this.assignHelpIds();
    }

    private void assignHelpIds() {
        this.viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_pallet");
    }

    @Override
    protected void updateCard() {
        this.sequenceBeforeStartChekcBox.setSelected(((PalletNode)this.getNode()).getHasBeforeStartSequence());
        this.sequenceAfterEndCheckBox.setSelected(((PalletNode)this.getNode()).getHasAfterEndSequence());
    }

    private void initComponents() {
        CommandNamesResource names = (CommandNamesResource)this.viewContext.getTextResource(CommandNamesResource.class);
        TextResource resource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        this.sequenceBeforeStartChekcBox = new JCheckBox(resource.specialProgramSequenceBeforeTheFirstPoint());
        this.sequenceBeforeStartChekcBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ((PalletNode)PalletCard.this.getNode()).setHasBeforeStartSequence(evt.getStateChange() == 1);
            }
        });
        this.sequenceAfterEndCheckBox = new JCheckBox(resource.specialProgramSequenceAfterTheLastPoint());
        this.sequenceAfterEndCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ((PalletNode)PalletCard.this.getNode()).setHasAfterEndSequence(evt.getStateChange() == 1);
            }
        });
        JPanel optionsPanel = this.viewContext.createFormBuilder().component((JComponent)this.sequenceBeforeStartChekcBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT}).end().component((JComponent)this.sequenceAfterEndCheckBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT}).end(2).getPanel();
        optionsPanel.setBorder(new CompoundBorder(BorderFactory.createLineBorder(G5LookAndFeel.BETWEEN_CARD_COLOR), BorderFactory.createEmptyBorder(5, 0, 0, 0)));
        this.viewContext.createFormBuilder().headerLabel(names.Pallet(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().description(resource.commandPallet(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.SPAN_12_ROWS}).end(20).spacer().end(2).component((JComponent)optionsPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.SPAN_3_ROWS}).end(3).setOnPanel((JPanel)((Object)this));
    }
}

