/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels.wizards;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.resources.ViewImageResource;
import com.ur.swing.BindingRegistration;
import com.ur.swing.CompletedListener;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberFieldUtils;
import com.ur.swing.units.Units;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.view.program.CommandPanel;
import com.ur.view.variables.core.ProgramVariable;
import gui.commandpanels.AccelerationFieldParser;
import gui.commandpanels.SpeedFieldParser;
import gui.program.AccelerationValueNode;
import gui.program.EntityFactory;
import gui.program.PatternNode;
import gui.program.SpeedValueNode;
import gui.program.validation.AccelerationValidationStrategyProvider;
import gui.program.validation.SpeedValidationStrategyProvider;
import gui.tools.LanguagePack;
import gui.tools.LegacyURDialogCreator;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.MutableTreeNode;
import org.jdesktop.layout.GroupLayout;

public class PatternCard
extends CommandPanel<PatternNode> {
    private final ValidationStrategy AXIS_VALIDATOR;
    private final EntityFactory entityFactory;
    private final SpeedValidationStrategyProvider speedValidationStrategyProvider;
    private final AccelerationValidationStrategyProvider accelerationValidationStrategyProvider;
    private boolean gettingSpeedValue = false;
    private boolean gettingAccValue = false;
    private boolean gettingFirstAxisCount = false;
    private boolean gettingSecondAxisCount = false;
    private boolean gettingThirdAxisCount = false;
    private List<BindingRegistration> SpeedAccelerationbindingRegistrations = new ArrayList<BindingRegistration>();
    private JTextField accelerationField;
    private JButton addPointButton;
    private JTextField firstAxisTextField;
    private JPanel firstPanel;
    private JLabel jLabel1;
    private JCheckBox rememberPatternPositionsCheckBox;
    private JButton removePointButton;
    private JTextField secondAxisTextField;
    private JPanel secondPanel;
    private JTextField speedField;
    private JTextField thirdAxisTextField;
    private JPanel thirdPanel;
    private JLabel titleLabel;
    private final ViewContext viewContext;
    private TextResource textResource;

    @Inject
    PatternCard(EntityFactory entityFactory, SpeedValidationStrategyProvider speedValidationStrategyProvider, AccelerationValidationStrategyProvider accelerationValidationStrategyProvider, ViewContext viewContext) {
        super(PatternNode.class);
        this.entityFactory = entityFactory;
        this.speedValidationStrategyProvider = speedValidationStrategyProvider;
        this.accelerationValidationStrategyProvider = accelerationValidationStrategyProvider;
        this.viewContext = viewContext;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.AXIS_VALIDATOR = ValidationFactory.getRangeValidator((double)2.0, (double)2.147483647E9, (boolean)true, (String)this.textResource.wholeNumberOutOfRange(2L, "", Integer.MAX_VALUE));
        this.initComponents();
        viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_pattern");
        this.bindNumberPickers();
    }

    private void bindNumberPickers() {
        NumberFieldUtils.bindNumberPicker((JTextField)this.speedField, (CompletedListener)new CompletedListener(){

            public void requestApply() {
                SpeedFieldParser.parse(PatternCard.this.speedField, (SpeedValueNode)PatternCard.this.getNode());
            }

            public void requestCancel() {
            }
        }, (Mode)Mode.PositiveNumbers);
        NumberFieldUtils.bindNumberPicker((JTextField)this.accelerationField, (CompletedListener)new CompletedListener(){

            public void requestApply() {
                AccelerationFieldParser.parse(PatternCard.this.accelerationField, (AccelerationValueNode)PatternCard.this.getNode());
            }

            public void requestCancel() {
            }
        }, (Mode)Mode.PositiveNumbers);
        NumberFieldUtils.bindNumberPicker((JTextField)this.firstAxisTextField, (CompletedListener)new CompletedListener(){

            public void requestApply() {
                ((PatternNode)PatternCard.this.getNode()).setFirstAxisCount(PatternCard.this.parseIntegerValue(PatternCard.this.firstAxisTextField));
            }

            public void requestCancel() {
            }
        }, (Mode)Mode.PositiveWholeNumbers);
        NumberFieldUtils.bindErrorValidator((JTextField)this.firstAxisTextField, (ValidationStrategy)this.AXIS_VALIDATOR);
        NumberFieldUtils.bindNumberPicker((JTextField)this.secondAxisTextField, (CompletedListener)new CompletedListener(){

            public void requestApply() {
                ((PatternNode)PatternCard.this.getNode()).setSecondAxisCount(PatternCard.this.parseIntegerValue(PatternCard.this.secondAxisTextField));
            }

            public void requestCancel() {
            }
        }, (Mode)Mode.PositiveWholeNumbers);
        NumberFieldUtils.bindErrorValidator((JTextField)this.secondAxisTextField, (ValidationStrategy)this.AXIS_VALIDATOR);
        NumberFieldUtils.bindNumberPicker((JTextField)this.thirdAxisTextField, (CompletedListener)new CompletedListener(){

            public void requestApply() {
                ((PatternNode)PatternCard.this.getNode()).setThirdAxisCount(PatternCard.this.parseIntegerValue(PatternCard.this.thirdAxisTextField));
            }

            public void requestCancel() {
            }
        }, (Mode)Mode.PositiveWholeNumbers);
        NumberFieldUtils.bindErrorValidator((JTextField)this.thirdAxisTextField, (ValidationStrategy)this.AXIS_VALIDATOR);
    }

    private int parseIntegerValue(JTextField jTextField) {
        if (this.AXIS_VALIDATOR.isValid(jTextField.getText())) {
            return Integer.valueOf(jTextField.getText());
        }
        this.AXIS_VALIDATOR.getErrorMessage(jTextField.getText());
        return 2;
    }

    private String getPatternType() {
        switch (((PatternNode)this.getNode()).getDimensionality()) {
            case LIST: {
                return this.textResource.List();
            }
            case LINE: {
                return this.textResource.Line();
            }
            case SQUARE_OBSOLETE: {
                return this.textResource.Square();
            }
            case BOX_OBSOLETE: {
                return this.textResource.Box();
            }
            case SQUARE: {
                return this.textResource.Square();
            }
            case BOX: {
                return this.textResource.Box();
            }
        }
        return "";
    }

    @Override
    protected void updateCard() {
        PatternNode node = (PatternNode)this.getNode();
        if (this.gettingSpeedValue) {
            SpeedFieldParser.parse(this.speedField, node);
            this.gettingSpeedValue = false;
        } else if (this.gettingAccValue) {
            AccelerationFieldParser.parse(this.accelerationField, node);
            this.gettingAccValue = false;
        } else if (this.gettingFirstAxisCount) {
            node.setFirstAxisCount(this.parseIntegerValue(this.firstAxisTextField));
            this.gettingFirstAxisCount = false;
        } else if (this.gettingSecondAxisCount) {
            int secondAxis = this.parseIntegerValue(this.secondAxisTextField);
            node.setSecondAxisCount(secondAxis);
            this.gettingSecondAxisCount = false;
        } else if (this.gettingThirdAxisCount) {
            int thirdAxis = this.parseIntegerValue(this.thirdAxisTextField);
            node.setThirdAxisCount(thirdAxis);
            this.gettingThirdAxisCount = false;
        }
        CommandNamesResource commandNamesResource = (CommandNamesResource)this.viewContext.getTextResource(CommandNamesResource.class);
        switch (node.getDimensionality()) {
            case UNDEFINED: {
                this.titleLabel.setText("<html><h1>" + commandNamesResource.Pattern() + "</h1></html>");
                ((CardLayout)this.firstPanel.getLayout()).show(this.firstPanel, "empty1");
                ((CardLayout)this.secondPanel.getLayout()).show(this.secondPanel, "empty2");
                ((CardLayout)this.thirdPanel.getLayout()).show(this.thirdPanel, "empty3");
                break;
            }
            case LIST: {
                this.titleLabel.setText("<html><h1>" + commandNamesResource.patternList() + "</h1></html>");
                ((CardLayout)this.firstPanel.getLayout()).show(this.firstPanel, "empty1");
                ((CardLayout)this.secondPanel.getLayout()).show(this.secondPanel, "empty2");
                ((CardLayout)this.thirdPanel.getLayout()).show(this.thirdPanel, "empty3");
                break;
            }
            case LINE: {
                this.titleLabel.setText("<html><h1>" + commandNamesResource.patternLine() + "</h1></html>");
                ((CardLayout)this.firstPanel.getLayout()).show(this.firstPanel, "axis1");
                ((CardLayout)this.secondPanel.getLayout()).show(this.secondPanel, "empty2");
                ((CardLayout)this.thirdPanel.getLayout()).show(this.thirdPanel, "empty3");
                this.firstAxisTextField.setText("" + node.getFirstAxisCount());
                break;
            }
            case SQUARE_OBSOLETE: {
                this.titleLabel.setText("<html><h1>" + commandNamesResource.patternSquare() + "</h1></html>");
                ((CardLayout)this.firstPanel.getLayout()).show(this.firstPanel, "axis1");
                ((CardLayout)this.secondPanel.getLayout()).show(this.secondPanel, "axis2");
                ((CardLayout)this.thirdPanel.getLayout()).show(this.thirdPanel, "empty3");
                this.firstAxisTextField.setText("" + node.getFirstAxisCount());
                this.secondAxisTextField.setText("" + node.getSecondAxisCount());
                break;
            }
            case BOX_OBSOLETE: {
                this.titleLabel.setText("<html><h1>" + commandNamesResource.patternBox() + "</h1></html>");
                ((CardLayout)this.firstPanel.getLayout()).show(this.firstPanel, "axis1");
                ((CardLayout)this.secondPanel.getLayout()).show(this.secondPanel, "axis2");
                ((CardLayout)this.thirdPanel.getLayout()).show(this.thirdPanel, "axis3");
                this.firstAxisTextField.setText("" + node.getFirstAxisCount());
                this.secondAxisTextField.setText("" + node.getSecondAxisCount());
                this.thirdAxisTextField.setText("" + node.getThirdAxisCount());
                break;
            }
            case SQUARE: {
                this.titleLabel.setText("<html><h1>" + commandNamesResource.patternSquare() + "</h1></html>");
                ((CardLayout)this.firstPanel.getLayout()).show(this.firstPanel, "axis1");
                ((CardLayout)this.secondPanel.getLayout()).show(this.secondPanel, "axis2");
                ((CardLayout)this.thirdPanel.getLayout()).show(this.thirdPanel, "empty3");
                this.firstAxisTextField.setText("" + node.getFirstAxisCount());
                this.secondAxisTextField.setText("" + node.getSecondAxisCount());
                break;
            }
            case BOX: {
                this.titleLabel.setText("<html><h1>" + commandNamesResource.patternBox() + "</h1></html>");
                ((CardLayout)this.firstPanel.getLayout()).show(this.firstPanel, "axis1");
                ((CardLayout)this.secondPanel.getLayout()).show(this.secondPanel, "axis2");
                ((CardLayout)this.thirdPanel.getLayout()).show(this.thirdPanel, "axis3");
                this.firstAxisTextField.setText("" + node.getFirstAxisCount());
                this.secondAxisTextField.setText("" + node.getSecondAxisCount());
                this.thirdAxisTextField.setText("" + node.getThirdAxisCount());
            }
        }
        this.addPointButton.setEnabled(node.getDimensionality() == PatternNode.Type.LIST);
        this.removePointButton.setEnabled(node.getDimensionality() == PatternNode.Type.LIST);
        ProgramVariable v = node.getCounterVariable();
        this.jLabel1.setText(((TextResource)this.viewContext.getTextResource(TextResource.class)).countingVariableUsedToTraverse(v.getName()));
        this.rememberPatternPositionsCheckBox.setSelected(node.getPrefersPersistentCounterVariableValue());
        for (BindingRegistration br : this.SpeedAccelerationbindingRegistrations) {
            br.removeRegistration();
        }
        if (node.isCartesianMotion()) {
            this.SpeedAccelerationbindingRegistrations.add(NumberFieldUtils.bindErrorValidator((JTextField)this.speedField, (ValidationStrategy)this.speedValidationStrategyProvider.getCartesianJointSpeedLimitValidator()));
            this.SpeedAccelerationbindingRegistrations.add(NumberFieldUtils.bindErrorValidator((JTextField)this.accelerationField, (ValidationStrategy)this.accelerationValidationStrategyProvider.getCartesianJointAccelerationLimitValidator()));
        } else {
            this.SpeedAccelerationbindingRegistrations.add(NumberFieldUtils.bindErrorValidator((JTextField)this.speedField, (ValidationStrategy)this.speedValidationStrategyProvider.getJointSpeedLimitValidator()));
            this.SpeedAccelerationbindingRegistrations.add(NumberFieldUtils.bindErrorValidator((JTextField)this.accelerationField, (ValidationStrategy)this.accelerationValidationStrategyProvider.getJointAccelerationLimitValidator()));
        }
        SpeedFieldParser.update(this.speedField, node);
        AccelerationFieldParser.update(this.accelerationField, node);
    }

    private void initComponents() {
        JPanel northPanel = new JPanel();
        JPanel jPanel4 = new JPanel();
        this.titleLabel = new JLabel();
        JButton changeOperationButton = new JButton();
        JPanel centerPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.addPointButton = new JButton();
        this.removePointButton = new JButton();
        this.rememberPatternPositionsCheckBox = new JCheckBox();
        JPanel jPanel3 = new JPanel();
        this.firstPanel = new JPanel();
        JPanel firstAxispanel = new JPanel();
        JLabel firstAxisLabel = new JLabel();
        this.firstAxisTextField = new JTextField();
        JPanel emptyPanel = new JPanel();
        this.secondPanel = new JPanel();
        JPanel emptyPanel1 = new JPanel();
        JPanel firstAxispanel1 = new JPanel();
        JLabel secondAxisLabel = new JLabel();
        this.secondAxisTextField = new JTextField();
        this.thirdPanel = new JPanel();
        JPanel emptyPanel2 = new JPanel();
        JPanel firstAxispanel2 = new JPanel();
        JLabel thirdAxisLabel = new JLabel();
        this.thirdAxisTextField = new JTextField();
        JPanel gridbagPanel = new JPanel();
        JLabel speedLabel = new JLabel();
        this.speedField = new JTextField();
        JLabel speedUnit = new JLabel();
        JLabel accelerationLabel = new JLabel();
        this.accelerationField = new JTextField();
        JLabel accelerationUnit = new JLabel();
        JButton jButton1 = new JButton();
        this.setName("PickCard");
        this.setLayout(new BorderLayout());
        northPanel.setLayout(new BorderLayout());
        jPanel4.setLayout(new FlowLayout(0, 30, 5));
        this.titleLabel.setText(LanguagePack.getText("COMMAND_LIST_OF_POSITIONS"));
        jPanel4.add(this.titleLabel);
        changeOperationButton.setIcon(ViewImageResource.gtkCancel());
        changeOperationButton.setText(LanguagePack.getText("Change_type"));
        changeOperationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatternCard.this.changeOperationButtonActionPerformed();
            }
        });
        jPanel4.add(changeOperationButton);
        northPanel.add((Component)jPanel4, "North");
        this.add(northPanel, "North");
        this.jLabel1.setText(this.textResource.countingVariableUsedToTraverse("cnt_var"));
        this.addPointButton.setText(LanguagePack.getText("Add_new_point"));
        this.addPointButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatternCard.this.addPointButtonActionPerformed();
            }
        });
        this.removePointButton.setText(LanguagePack.getText("Remove_point"));
        this.removePointButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatternCard.this.removePointButtonActionPerformed();
            }
        });
        this.rememberPatternPositionsCheckBox.setText(LanguagePack.getText("Remember_pattern_position_between_program_runs"));
        this.rememberPatternPositionsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PatternCard.this.rememberPatternPositionsCheckBoxItemStateChanged();
            }
        });
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        this.firstPanel.setLayout(new CardLayout());
        firstAxispanel.setLayout(new FlowLayout(2));
        firstAxisLabel.setText(LanguagePack.getText("Point_1_to_2_interval_count"));
        firstAxispanel.add(firstAxisLabel);
        this.firstAxisTextField.setHorizontalAlignment(11);
        this.firstAxisTextField.setText("    0");
        this.firstAxisTextField.setMinimumSize(new Dimension(80, 27));
        this.firstAxisTextField.setPreferredSize(new Dimension(80, 27));
        this.firstAxisTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PatternCard.this.firstAxisTextFieldFocusLost();
            }
        });
        firstAxispanel.add(this.firstAxisTextField);
        this.firstPanel.add((Component)firstAxispanel, "axis1");
        this.firstPanel.add((Component)emptyPanel, "empty1");
        jPanel3.add(this.firstPanel);
        this.secondPanel.setLayout(new CardLayout());
        this.secondPanel.add((Component)emptyPanel1, "empty2");
        firstAxispanel1.setLayout(new FlowLayout(2));
        secondAxisLabel.setText(LanguagePack.getText("Point_2_to_3_interval_count"));
        firstAxispanel1.add(secondAxisLabel);
        this.secondAxisTextField.setHorizontalAlignment(11);
        this.secondAxisTextField.setText("    0");
        this.secondAxisTextField.setMinimumSize(new Dimension(80, 27));
        this.secondAxisTextField.setPreferredSize(new Dimension(80, 27));
        this.secondAxisTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PatternCard.this.secondAxisTextFieldFocusLost();
            }
        });
        firstAxispanel1.add(this.secondAxisTextField);
        this.secondPanel.add((Component)firstAxispanel1, "axis2");
        jPanel3.add(this.secondPanel);
        this.thirdPanel.setLayout(new CardLayout());
        this.thirdPanel.add((Component)emptyPanel2, "empty3");
        firstAxispanel2.setLayout(new FlowLayout(2));
        thirdAxisLabel.setText(LanguagePack.getText("Point_3_to_4_interval_count"));
        firstAxispanel2.add(thirdAxisLabel);
        this.thirdAxisTextField.setHorizontalAlignment(11);
        this.thirdAxisTextField.setText("    0");
        this.thirdAxisTextField.setMinimumSize(new Dimension(80, 27));
        this.thirdAxisTextField.setPreferredSize(new Dimension(80, 27));
        this.thirdAxisTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PatternCard.this.thirdAxisTextFieldFocusLost();
            }
        });
        firstAxispanel2.add(this.thirdAxisTextField);
        this.thirdPanel.add((Component)firstAxispanel2, "axis3");
        jPanel3.add(this.thirdPanel);
        gridbagPanel.setBorder(BorderFactory.createTitledBorder(LanguagePack.getText("Shared_Parameters")));
        gridbagPanel.setLayout(new GridBagLayout());
        speedLabel.setText(LanguagePack.getText("Tool_Speed"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridbagPanel.add((Component)speedLabel, gridBagConstraints);
        this.speedField.setHorizontalAlignment(11);
        this.speedField.setText("0.000");
        this.speedField.setPreferredSize(new Dimension(80, 27));
        this.speedField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PatternCard.this.speedFieldFocusLost();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridbagPanel.add((Component)this.speedField, gridBagConstraints);
        speedUnit.setText(Units.getText((String)"UNIT_mm_s"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridbagPanel.add((Component)speedUnit, gridBagConstraints);
        accelerationLabel.setText(LanguagePack.getText("Tool_Acceleration"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridbagPanel.add((Component)accelerationLabel, gridBagConstraints);
        this.accelerationField.setHorizontalAlignment(11);
        this.accelerationField.setText("0.000");
        this.accelerationField.setPreferredSize(new Dimension(80, 27));
        this.accelerationField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PatternCard.this.accelerationFieldFocusLost();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridbagPanel.add((Component)this.accelerationField, gridBagConstraints);
        accelerationUnit.setText(Units.getText((String)"UNIT_mm_s2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridbagPanel.add((Component)accelerationUnit, gridBagConstraints);
        jButton1.setText(LanguagePack.getText("Reset_to_defaults"));
        jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatternCard.this.jButton1ActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridbagPanel.add((Component)jButton1, gridBagConstraints);
        GroupLayout centerPanelLayout = new GroupLayout((Container)centerPanel);
        centerPanel.setLayout((LayoutManager)centerPanelLayout);
        centerPanelLayout.setHorizontalGroup((GroupLayout.Group)centerPanelLayout.createParallelGroup(1).add((GroupLayout.Group)centerPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)centerPanelLayout.createParallelGroup(1).add((GroupLayout.Group)centerPanelLayout.createSequentialGroup().add((GroupLayout.Group)centerPanelLayout.createParallelGroup(1, false).add((Component)this.removePointButton, -1, -1, Short.MAX_VALUE).add((Component)this.addPointButton, -1, -1, Short.MAX_VALUE)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)gridbagPanel, -2, -1, -2)).add((GroupLayout.Group)centerPanelLayout.createSequentialGroup().add((GroupLayout.Group)centerPanelLayout.createParallelGroup(1).add((GroupLayout.Group)centerPanelLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.rememberPatternPositionsCheckBox)).add((Component)this.jLabel1)).add(0, 161, Short.MAX_VALUE))).addContainerGap()).add((GroupLayout.Group)centerPanelLayout.createParallelGroup(1).add((GroupLayout.Group)centerPanelLayout.createSequentialGroup().addContainerGap().add((Component)jPanel3, -1, 559, Short.MAX_VALUE).addContainerGap())));
        centerPanelLayout.setVerticalGroup((GroupLayout.Group)centerPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)centerPanelLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.rememberPatternPositionsCheckBox).addPreferredGap(0, 205, Short.MAX_VALUE).add((GroupLayout.Group)centerPanelLayout.createParallelGroup(2).add((GroupLayout.Group)centerPanelLayout.createSequentialGroup().add((Component)this.addPointButton).addPreferredGap(0).add((Component)this.removePointButton)).add((Component)gridbagPanel, -2, -1, -2)).addContainerGap()).add((GroupLayout.Group)centerPanelLayout.createParallelGroup(1).add((GroupLayout.Group)centerPanelLayout.createSequentialGroup().add(50, 50, 50).add((Component)jPanel3, -2, -1, -2).addContainerGap(221, Short.MAX_VALUE))));
        this.add(centerPanel, "Center");
    }

    private ConfirmationMessage confirmDeleteProgrammedPositions(String patternType) {
        return new ConfirmationMessage(this.textResource.confirmDeleteProgrammedPositionsTitle(), this.textResource.confirmDeleteProgrammedPositionsExplanation(patternType), this.textResource.confirmDeleteProgrammedPositionsAction(), this.textResource.Cancel());
    }

    private void changeOperationButtonActionPerformed() {
        DialogReturnValue returnValue;
        PatternNode node = (PatternNode)this.getNode();
        if (node.getChildCount() != 0 && (returnValue = LegacyURDialogCreator.confirmMessageDialog(this.confirmDeleteProgrammedPositions(this.getPatternType()))) == DialogReturnValue.OK) {
            this.entityFactory.setDimensionalityAndAdjustNodes(node, PatternNode.Type.UNDEFINED);
        }
    }

    private void addPointButtonActionPerformed() {
        PatternNode node = (PatternNode)this.getNode();
        if (node.getDimensionality() == PatternNode.Type.LIST) {
            node.getProgramTreeModel().insertNodeInto((MutableTreeNode)((Object)this.entityFactory.createWaypointNode()), (MutableTreeNode)((Object)node), node.getChildCount());
        }
    }

    private void removePointButtonActionPerformed() {
        PatternNode node = (PatternNode)this.getNode();
        if (node.getDimensionality() == PatternNode.Type.LIST && node.getChildCount() > 0) {
            node.getProgramTreeModel().removeNodeFromParent((MutableTreeNode)((AbstractProgramNode)node.getLastChild()));
        }
    }

    private void jButton1ActionPerformed() {
        ((PatternNode)this.getNode()).resetToDefaults();
        this.updateCard();
    }

    private void rememberPatternPositionsCheckBoxItemStateChanged() {
        ((PatternNode)this.getNode()).setPrefersPersistentCounterVariableValue(this.rememberPatternPositionsCheckBox.isSelected());
    }

    private void firstAxisTextFieldFocusLost() {
        if (!this.gettingFirstAxisCount) {
            ((PatternNode)this.getNode()).setFirstAxisCount(this.parseIntegerValue(this.firstAxisTextField));
        }
    }

    private void speedFieldFocusLost() {
        if (!this.gettingSpeedValue) {
            SpeedFieldParser.parse(this.speedField, (SpeedValueNode)this.getNode());
        }
    }

    private void accelerationFieldFocusLost() {
        if (!this.gettingAccValue) {
            AccelerationFieldParser.parse(this.accelerationField, (AccelerationValueNode)this.getNode());
        }
    }

    private void thirdAxisTextFieldFocusLost() {
        if (!this.gettingThirdAxisCount) {
            ((PatternNode)this.getNode()).setThirdAxisCount(this.parseIntegerValue(this.thirdAxisTextField));
        }
    }

    private void secondAxisTextFieldFocusLost() {
        if (!this.gettingSecondAxisCount) {
            ((PatternNode)this.getNode()).setSecondAxisCount(this.parseIntegerValue(this.secondAxisTextField));
        }
    }
}

