/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels.wizards;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.view.program.CommandPanel;
import gui.program.AnchoredSequenceNode;
import gui.program.position.WaypointNode;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.inject.Inject;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PatternSequenceCard
extends CommandPanel<AnchoredSequenceNode> {
    private final ViewContext context;
    private JComboBox anchorPositionComboBox;
    private AnchoredSequenceNode node;

    @Inject
    PatternSequenceCard(ViewContext context) {
        super(AnchoredSequenceNode.class);
        this.context = context;
        this.initComponents();
        this.assignHelpIds();
    }

    private void assignHelpIds() {
        this.context.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_anchorablesequence");
    }

    @Override
    public AnchoredSequenceNode getNode() {
        return this.node;
    }

    @Override
    public void enter(Object o) {
        if (this.getNode() == null) {
            this.node = (AnchoredSequenceNode)o;
            this.removeAll();
            this.initComponents();
        }
        super.enter(o);
    }

    public Object exit() {
        this.node = null;
        return super.exit();
    }

    @Override
    protected void updateCard() {
        this.anchorPositionComboBox.setModel(this.getWaypointModel());
        this.anchorPositionComboBox.setSelectedItem(this.node.getAnchorWaypointNode());
    }

    private void initComponents() {
        TextResource resource = (TextResource)this.context.getTextResource(TextResource.class);
        JLabel anchorPositionLabel = new JLabel(resource.anchorPosition());
        this.anchorPositionComboBox = new JComboBox();
        this.anchorPositionComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PatternSequenceCard.this.anchorPositionComboBoxItemStateChanged(evt);
            }
        });
        this.context.createFormBuilder().headerLabel(this.getTitle(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().description(resource.commandPositionSequence(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_ROWS, FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end(6).label(anchorPositionLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.anchorPositionComboBox, new FormBuilder.PanelConstraints[0]).end().setOnPanel((JPanel)((Object)this));
    }

    private void anchorPositionComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getItem() instanceof WaypointNode) {
            this.node.setAnchorWaypointNode((WaypointNode)evt.getItem());
            this.node.textHasChanged();
        }
    }

    public String getTitle() {
        CommandNamesResource names = (CommandNamesResource)this.context.getTextResource(CommandNamesResource.class);
        return this.getNode() == null ? names.PatternSequence() : this.getNode().getName();
    }

    public ComboBoxModel getWaypointModel() {
        DefaultComboBoxModel<AbstractProgramNode> result = new DefaultComboBoxModel<AbstractProgramNode>();
        if (this.getNode() == null) {
            return result;
        }
        Enumeration en = this.node.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            AbstractProgramNode p = (AbstractProgramNode)en.nextElement();
            if (!(p instanceof WaypointNode)) continue;
            result.addElement(p);
        }
        return result;
    }
}

