/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels.wizards;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.swing.ViewContext;
import com.ur.util.swing.HTML;
import com.ur.view.program.CommandPanel;
import gui.program.PalletNode;
import gui.program.SpecialSequenceNode;
import gui.program.StackNode;
import gui.tools.LanguagePack;
import java.awt.Container;
import javax.inject.Inject;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.tree.TreeNode;

public class SpecialSequenceCard
extends CommandPanel<SpecialSequenceNode> {
    private final ViewContext viewContext;
    private JLabel specialSequenceText;
    private JLabel titleLabel;

    @Inject
    SpecialSequenceCard(ViewContext viewContext) {
        super(SpecialSequenceNode.class);
        this.viewContext = viewContext;
        this.initComponents();
    }

    @Override
    protected void updateCard() {
        this.titleLabel.setText(HTML.html((String)HTML.h1((String)this.getTranslatedName())));
        this.specialSequenceText.setText(this.getTranslatedDescription());
    }

    private String getBeforePointDescription() {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        CommandNamesResource commandNamesResource = (CommandNamesResource)this.viewContext.getTextResource(CommandNamesResource.class);
        TreeNode parent = ((SpecialSequenceNode)this.getNode()).getParent();
        if (parent instanceof PalletNode) {
            return textResource.commandSequenceBeforeFirstPoint(commandNamesResource.PalletSequence());
        }
        if (parent instanceof StackNode) {
            if (((StackNode)((Object)parent)).getType() == StackNode.Type.STACK) {
                return textResource.commandSequenceBeforeFirstPoint(commandNamesResource.PlaceSequence());
            }
            if (((StackNode)((Object)parent)).getType() == StackNode.Type.DESTACK) {
                return textResource.commandSequenceBeforeFirstPoint(commandNamesResource.PickSequence());
            }
        }
        return "";
    }

    private String getAfterEndDescription() {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        CommandNamesResource commandNamesResource = (CommandNamesResource)this.viewContext.getTextResource(CommandNamesResource.class);
        TreeNode parent = ((SpecialSequenceNode)this.getNode()).getParent();
        if (parent instanceof PalletNode) {
            return textResource.commandSequenceAfterEnd(commandNamesResource.PalletSequence());
        }
        if (parent instanceof StackNode) {
            if (((StackNode)((Object)parent)).getType() == StackNode.Type.STACK) {
                return textResource.commandSequenceAfterEnd(commandNamesResource.PlaceSequence());
            }
            if (((StackNode)((Object)parent)).getType() == StackNode.Type.DESTACK) {
                return textResource.commandSequenceAfterEnd(commandNamesResource.PickSequence());
            }
        }
        return "";
    }

    private String getTranslatedName() {
        CommandNamesResource commandNamesResource = (CommandNamesResource)this.viewContext.getTextResource(CommandNamesResource.class);
        if (this.getNode() != null) {
            switch (((SpecialSequenceNode)this.getNode()).getType()) {
                case BEFORE_START: {
                    return commandNamesResource.BeforeStart();
                }
                case BEFORE_POINT: {
                    return commandNamesResource.BeforeStart();
                }
                case AFTER_END: {
                    return commandNamesResource.AfterEnd();
                }
            }
        }
        return "";
    }

    private String getTranslatedDescription() {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        if (this.getNode() != null) {
            switch (((SpecialSequenceNode)this.getNode()).getType()) {
                case BEFORE_START: {
                    return textResource.commandSequenceBeforeProgramStart();
                }
                case BEFORE_POINT: {
                    return this.getBeforePointDescription();
                }
                case AFTER_END: {
                    return this.getAfterEndDescription();
                }
            }
        }
        return "";
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.specialSequenceText = new JLabel();
        this.titleLabel.setText(HTML.html((String)HTML.h1((String)LanguagePack.getCommandName("SpecialSequence"))));
        this.specialSequenceText.setText(LanguagePack.getText("Special_Sequence"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.specialSequenceText).addContainerGap(24, Short.MAX_VALUE)).addComponent(this.titleLabel, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.titleLabel).addGap(18, 18, 18).addComponent(this.specialSequenceText).addContainerGap(214, Short.MAX_VALUE)));
    }
}

