/*
 * Decompiled with CFR 0.152.
 */
package gui.configuration;

import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.viewfacade.configuration.ToolConfigurationSettings;
import com.ur.util.Synchronized;
import com.ur.util.logging.Log;
import gui.configuration.ToolConfiguration;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ToolConfigurationSettingsImpl
implements ToolConfigurationSettings {
    private ToolConfiguration toolConfiguration;
    private boolean dataReceivedCheckAlreadyPerformed;
    private boolean configurationDataReceived = false;
    private final Object sync = new Object();

    @Inject
    public ToolConfigurationSettingsImpl(@Source(value=ToolConfiguration.class) Recipe<ToolConfiguration> toolConfigurationRecipe) {
        this.initFieldsToDefaultValues();
        toolConfigurationRecipe.subscribe((Consumer)new Consumer<ToolConfiguration>(){

            public void accept(ToolConfiguration toolConfiguration) {
                ToolConfigurationSettingsImpl.this.configurationDataReceived = true;
                ToolConfigurationSettingsImpl.this.toolConfiguration = toolConfiguration;
            }
        });
    }

    public double getVToolDefault() {
        this.checkIfDataFromControllerReceived(this.toolConfiguration.getvToolDefault());
        return (Double)Synchronized.copyOf((Object)this.sync, (Object)this.toolConfiguration.getvToolDefault());
    }

    public double getAToolDefault() {
        this.checkIfDataFromControllerReceived(this.toolConfiguration.getaToolDefault());
        return (Double)Synchronized.copyOf((Object)this.sync, (Object)this.toolConfiguration.getaToolDefault());
    }

    public double getEqRadius() {
        this.checkIfDataFromControllerReceived(this.toolConfiguration.getEqRadius());
        return (Double)Synchronized.copyOf((Object)this.sync, (Object)this.toolConfiguration.getEqRadius());
    }

    public void initFieldsToDefaultValues() {
        this.toolConfiguration = new ToolConfiguration(0.0, 0.0, 0.0);
    }

    private void checkIfDataFromControllerReceived(Object dataToLookup) {
        if (!this.configurationDataReceived && !this.dataReceivedCheckAlreadyPerformed) {
            this.dataReceivedCheckAlreadyPerformed = true;
            Log.warning((String)("Method used before correct value has been received from controller, returning default = " + dataToLookup));
            Log.warning((String)"Ignoring any future reports of error");
        }
    }
}

