/*
 * Decompiled with CFR 0.152.
 */
package gui.debug;

import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageProducer;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.swing.SwingUtil;
import com.ur.util.event.EventNotificationService;
import com.ur.view.constants.errorcodes.ReportLevel;
import gui.debug.FlightReportAttachmentService;
import gui.tools.DialogCreator;
import javax.inject.Inject;

public class CaptureUnhandledExceptions
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOG = LogFactory.createLogger(CaptureUnhandledExceptions.class);
    private final FlightReportAttachmentService flightReportAttachmentService;
    private final DialogCreator dialogCreator;

    @Inject
    public CaptureUnhandledExceptions(FlightReportAttachmentService flightReportAttachmentService, DialogCreator dialogCreator) {
        this.flightReportAttachmentService = flightReportAttachmentService;
        this.dialogCreator = dialogCreator;
        EventNotificationService.addErrorHandler((Thread.UncaughtExceptionHandler)this);
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    @Override
    public void uncaughtException(Thread t, Throwable exception) {
        RobotMessage robotMessage = new RobotMessageProducer().generateTextAndNotify(ReportLevel.WARNING, exception.getMessage() == null ? exception.toString() : exception.getMessage());
        if (CaptureUnhandledExceptions.isJ3DThread(t)) {
            CaptureUnhandledExceptions.handleUncaughtJ3DExceptions(t);
            return;
        }
        this.flightReportAttachmentService.enrichReport(robotMessage, exception, FlightRecorderTriggerType.SOFTWARE_FAILURE);
        SwingUtil.invokeLater((Runnable)new RunnableWithData(t, exception, robotMessage, this.dialogCreator));
    }

    private static boolean isJ3DThread(Thread t) {
        return t.getName().toLowerCase().contains("j3d");
    }

    private static void handleUncaughtJ3DExceptions(Thread t) {
        LOG.error(String.format("Uncaught exception in J3D Thread: %s", t.getName()), new Object[0]);
    }

    private class RunnableWithData
    implements Runnable {
        private Thread thread;
        private Throwable exception;
        private final DialogCreator dialogCreator;
        private final RobotMessage robotMessage;

        public RunnableWithData(Thread t, Throwable e, RobotMessage robotMessage, DialogCreator dialogCreator) {
            this.thread = t;
            this.exception = e;
            this.robotMessage = robotMessage;
            this.dialogCreator = dialogCreator;
        }

        @Override
        public void run() {
            this.dialogCreator.showExceptionDialog(this.robotMessage, this.thread, this.exception, null);
        }
    }
}

