/*
 * Decompiled with CFR 0.152.
 */
package gui.debug;

import com.ur.log.logentry.robotmessage.Attachment;
import com.ur.log.logentry.robotmessage.IncompleteAttachment;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.polyscope.flightrecorder.FlightRecorder;
import com.ur.polyscope.flightrecorder.FlightRecorderConsumer;
import com.ur.polyscope.flightrecorder.FlightRecorderReporter;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.polyscope.flightrecorder.ReportDescription;
import com.ur.util.Waiting;
import com.ur.util.logging.Log;
import com.ur.view.gui.threading.WorkerDeamon;
import com.ur.view.gui.threading.WorkerDeamonAspect;
import gui.debug.FlightReportAttachment;
import gui.debug.FlightReportAttachmentService$FlightRecorderIncidentReporter$AjcClosure1;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Singleton
public class FlightReportAttachmentService
implements FlightRecorderConsumer {
    private IncidentReporter incidentReporter = new IncidentReporter(null, null);

    FlightReportAttachmentService() {
    }

    public void enrichReport(RobotMessage robotMessage, FlightRecorderTriggerType triggerType) {
        this.incidentReporter.reportIncident(robotMessage, triggerType);
    }

    public void enrichReport(RobotMessage robotMessage, Throwable exception, FlightRecorderTriggerType triggerType) {
        this.incidentReporter.reportIncident(robotMessage, exception, triggerType);
    }

    public void setFlightRecorder(FlightRecorder flightRecorder, FlightRecorderReporter flightRecorderReporter) {
        this.incidentReporter = new FlightRecorderIncidentReporter(flightRecorder, flightRecorderReporter);
    }

    private class FlightRecorderIncidentReporter
    extends IncidentReporter {
        private static final int REPORTING_DELAY_MS = 5000;
        private static final int REPORTING_DELAY_AFTER_EXCEPTION_MS = 1000;
        private final FlightRecorder flightRecorder;
        private final FlightRecorderReporter flightRecorderReporter;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        public FlightRecorderIncidentReporter(FlightRecorder flightRecorder, FlightRecorderReporter flightRecorderReporter) {
            this.flightRecorder = flightRecorder;
            this.flightRecorderReporter = flightRecorderReporter;
        }

        @Override
        public void reportIncident(RobotMessage robotMessage, FlightRecorderTriggerType triggerType) {
            ReportDescription reportDescription = this.flightRecorder.reportIncident(5000, triggerType);
            if (reportDescription != null) {
                this.enrichAndReplaceWhenCompleted(robotMessage, reportDescription);
            }
        }

        @Override
        public void reportIncident(RobotMessage robotMessage, Throwable exception, FlightRecorderTriggerType triggerType) {
            ReportDescription reportDescription = this.flightRecorder.reportIncident(exception, 1000, triggerType);
            if (reportDescription != null) {
                this.enrichAndReplaceWhenCompleted(robotMessage, reportDescription);
            }
        }

        private void enrichAndReplaceWhenCompleted(RobotMessage robotMessage, ReportDescription reportDescription) {
            Log.info((String)("Generating report: " + reportDescription.getReportId()));
            robotMessage.setAttachment((Attachment)new IncompleteAttachment(reportDescription.getReportId()));
            this.updateFlightReportAttachmnet(robotMessage, reportDescription);
        }

        @WorkerDeamon(name="Update-FlightReport-Attachment")
        private void updateFlightReportAttachmnet(RobotMessage robotMessage, ReportDescription reportDescription) {
            RobotMessage robotMessage2 = robotMessage;
            ReportDescription reportDescription2 = reportDescription;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)robotMessage2, (Object)reportDescription2);
            Object[] objectArray = new Object[]{this, robotMessage2, reportDescription2, joinPoint};
            FlightReportAttachmentService$FlightRecorderIncidentReporter$AjcClosure1 flightReportAttachmentService$FlightRecorderIncidentReporter$AjcClosure1 = new FlightReportAttachmentService$FlightRecorderIncidentReporter$AjcClosure1(objectArray);
            WorkerDeamonAspect.aspectOf().aroundAnnotatedMethod(flightReportAttachmentService$FlightRecorderIncidentReporter$AjcClosure1.linkClosureAndJoinPoint(69648));
        }

        private void replaceReportWithActualFlightReportFile(RobotMessage robotMessage, ReportDescription reportDescription) {
            robotMessage.setAttachment((Attachment)new FlightReportAttachment(reportDescription, this.flightRecorderReporter));
        }

        static {
            FlightRecorderIncidentReporter.ajc$preClinit();
        }

        static final /* synthetic */ void updateFlightReportAttachmnet_aroundBody0(FlightRecorderIncidentReporter ajc$this, RobotMessage robotMessage, ReportDescription reportDescription, JoinPoint joinPoint) {
            if (Waiting.until((Waiting.ItHappens)new ReportCompleted(reportDescription), (int)120, (int)2, (TimeUnit)TimeUnit.SECONDS)) {
                ajc$this.replaceReportWithActualFlightReportFile(robotMessage, reportDescription);
            } else {
                Log.error((String)("Flight reporter triggered. But, never completed: " + robotMessage.safetyMode + (reportDescription != null ? reportDescription.getReportId() : "")));
            }
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("FlightReportAttachmentService.java", FlightRecorderIncidentReporter.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateFlightReportAttachmnet", "gui.debug.FlightReportAttachmentService$FlightRecorderIncidentReporter", "com.ur.log.logentry.robotmessage.RobotMessage:com.ur.polyscope.flightrecorder.ReportDescription", "robotMessage:reportDescription", "", "void"), 83);
        }
    }

    private class IncidentReporter {
        private IncidentReporter() {
        }

        public void reportIncident(RobotMessage robotMessage, FlightRecorderTriggerType triggerType) {
            Log.info((String)"Skipping incident reporting - no flight recorder attached");
        }

        public void reportIncident(RobotMessage robotMessage, Throwable exception, FlightRecorderTriggerType triggerType) {
            Log.info((String)("Skipping incident reporting - no flight recorder attached. Exception: " + exception.getMessage()));
        }

        /* synthetic */ IncidentReporter(IncidentReporter incidentReporter, IncidentReporter incidentReporter2) {
            this();
        }
    }

    private static class ReportCompleted
    implements Waiting.ItHappens {
        private final ReportDescription reportDescription;

        public ReportCompleted(ReportDescription reportDescription) {
            this.reportDescription = reportDescription;
        }

        public boolean itHappened() {
            return this.reportDescription.getReportTask().isDone();
        }
    }
}

