/*
 * Decompiled with CFR 0.152.
 */
package gui.geom;

import com.ur.monitor.model.Vector3;
import com.ur.polyscope.geomfeature.BaseSpatialFeature;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.RobotDraw3D;
import com.ur.polyscope.robot.configuration.controller.ConfigurationState;
import com.ur.polyscope.visualizer.geomfeature.JoggableGeomFeature;
import com.ur.polyscope.visualizer.geomfeature.ProgramVisualization;
import gui.program.services.geom.GeomFeatureReferenceBase;
import java.util.UUID;
import javax.inject.Inject;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;

public class BaseView
extends JoggableGeomFeature
implements BaseSpatialFeature {
    public static final String BASE_VIEW_NAME = "Joint_0_name";
    public static final Vector3 X_AXIS = Vector3.fromMatrix3dColumn((Matrix3d)new BaseView().getTransformRotation(), (Vector3.Axis)Vector3.Axis.X);
    public static final Vector3 Y_AXIS = Vector3.fromMatrix3dColumn((Matrix3d)new BaseView().getTransformRotation(), (Vector3.Axis)Vector3.Axis.Y);
    public static final Vector3 Z_AXIS = Vector3.fromMatrix3dColumn((Matrix3d)new BaseView().getTransformRotation(), (Vector3.Axis)Vector3.Axis.Z);
    private static final UUID BASE_VIEW_ID = UUID.fromString("1b785537-e70a-4c26-a8af-4602e931277e");
    private double cameraOffset;
    private double cameraHeight;
    private double cameraDistance;
    private RobotDraw3D robotDraw3D;
    private ConfigurationState configurationState;

    @Inject
    public BaseView(RobotConfigurationProvider robotConfigurationProvider, ConfigurationState configurationState) {
        this.configurationState = configurationState;
        this.robotDraw3D = robotConfigurationProvider.getRobotDraw3D();
        this.setId(BASE_VIEW_ID);
        this.setName(BaseView.getFeatureClassName());
        this.resetView();
    }

    private BaseView() {
    }

    public void moveView(double deltaDistance, double deltaX, double deltaY) {
        double newCameraDistance = this.between(0.3, 5.0, this.cameraDistance + deltaDistance);
        double newCameraOffset = this.between(-1.0, 1.0, this.cameraOffset + deltaX);
        double newCameraHeight = this.between(-0.7, 0.7, this.cameraHeight + deltaY);
        if (newCameraDistance != this.cameraDistance || newCameraHeight != this.cameraHeight || newCameraOffset != this.cameraOffset) {
            this.cameraDistance = newCameraDistance;
            this.cameraHeight = newCameraHeight;
            this.cameraOffset = newCameraOffset;
            this.recalculateViewTransform();
        }
    }

    private double between(double min, double max, double value) {
        if (value > max) {
            value = max;
        }
        if (value < min) {
            value = min;
        }
        return value;
    }

    public double[] getView() {
        return new double[]{this.cameraDistance, this.cameraOffset, this.cameraHeight};
    }

    public void resetView() {
        if (this.configurationState.configurationDataNotReceivedFromController()) {
            return;
        }
        this.cameraOffset = this.robotDraw3D.getBaseCameraOffset();
        this.cameraHeight = this.robotDraw3D.getBaseCameraHeight();
        this.cameraDistance = this.robotDraw3D.getBaseCameraDistance();
        this.recalculateViewTransform();
    }

    public void recalculateViewTransform() {
        Matrix4d cameraOrientationMatrix = new Matrix4d(0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        Transform3D cameraOrientation = new Transform3D(cameraOrientationMatrix);
        Transform3D translationToCenter = new Transform3D();
        translationToCenter.setTranslation(new Vector3d(this.cameraDistance, this.cameraOffset, this.cameraHeight));
        Transform3D newCameraTransform = new Transform3D(this.getTransform());
        newCameraTransform.mul(translationToCenter);
        newCameraTransform.mul(cameraOrientation);
        this.setNewCameraTransform(newCameraTransform);
        this.publishViewChanges();
    }

    public void recalculateTransform() {
        Transform3D t3d = new Transform3D();
        this.setNewTransform(t3d);
    }

    public void setProgramVisualization(ProgramVisualization programVisualizationIn) {
        this.programVisualization = programVisualizationIn;
    }

    public boolean isUndefined() {
        return false;
    }

    public String getName() {
        return BaseView.getStandardName();
    }

    public String toString() {
        return BaseView.getFeatureClassName();
    }

    public static String getStandardName() {
        return BASE_VIEW_NAME;
    }

    public static String getFeatureClassName() {
        return GeomFeatureReferenceBase.getFeatureClassName(BaseView.getStandardName());
    }
}

