/*
 * Decompiled with CFR 0.152.
 */
package gui.geom;

import com.ur.move.viewfacade.MoveCameraView;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.RobotDraw3D;
import com.ur.polyscope.robot.configuration.controller.ConfigurationState;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.polyscope.visualizer.geomfeature.GeomFeatureChangedListener;
import com.ur.polyscope.visualizer.geomfeature.JoggableGeomFeature;
import com.ur.polyscope.visualizer.geomfeature.ProgramVisualization;
import gui.geom.WorldTransform;
import gui.tools.LanguagePack;
import java.util.UUID;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;

public class CameraView
extends JoggableGeomFeature
implements GeomFeatureChangedListener,
MoveCameraView {
    private static final UUID CAMERA_VIEW_ID = UUID.fromString("f55327de-ca52-462b-92da-b79887dc4474");
    private double cameraAngle;
    private double cameraHeight;
    private double cameraDistance;
    private WorldTransform wt = null;
    private transient Transform3D mountingTransform;
    private RobotDraw3D robotDraw3D;
    private ConfigurationState configurationState;

    public CameraView(WorldTransform transform, RobotConfigurationProvider robotConfigurationProvider, ConfigurationState configurationState) {
        this.configurationState = configurationState;
        this.robotDraw3D = robotConfigurationProvider.getRobotDraw3D();
        this.setId(CAMERA_VIEW_ID);
        this.setName(CameraView.getFeatureClassName());
        this.wt = transform;
        this.wt.addGeomFeatureChangedListener(this);
        this.mountingTransform = this.wt.getTransform();
        this.resetView();
    }

    public void transformHasChanged(GeomFeature geomFeature) {
        if (geomFeature instanceof WorldTransform && geomFeature != this.wt) {
            this.wt.removeGeomFeatureChangedListener(this);
            this.wt = (WorldTransform)geomFeature;
            this.wt.addGeomFeatureChangedListener(this);
        }
        this.mountingTransform = this.wt.getTransform();
        this.recalculateTransform();
    }

    public void recalculateTransform() {
        Transform3D newTransform = new Transform3D();
        Transform3D translationToMidpointOfRobot = new Transform3D();
        translationToMidpointOfRobot.setTranslation(new Vector3d(0.0, 0.0, 0.4));
        newTransform.mul(translationToMidpointOfRobot);
        newTransform.mul(this.mountingTransform);
        Transform3D cameraAngleTransform = new Transform3D();
        cameraAngleTransform.rotZ(this.cameraAngle);
        newTransform.mul(cameraAngleTransform);
        this.setNewTransform(newTransform);
        this.recalculateViewTransform();
    }

    public void recalculateViewTransform() {
        Transform3D newCameraTransform = new Transform3D();
        Matrix4d cameraOrientationMatrix = new Matrix4d(0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        Transform3D cameraOrientation = new Transform3D(cameraOrientationMatrix);
        Transform3D translationToCenter = new Transform3D();
        Transform3D translationToCamera = new Transform3D();
        translationToCenter.setTranslation(new Vector3d(0.0, 0.0, this.cameraHeight));
        translationToCamera.setTranslation(new Vector3d(this.cameraDistance, 0.0, 0.0));
        newCameraTransform.set(this.getTransform());
        newCameraTransform.mul(translationToCenter);
        newCameraTransform.mul(translationToCamera);
        newCameraTransform.mul(cameraOrientation);
        this.setNewCameraTransform(newCameraTransform);
        this.publishViewChanges();
    }

    public void moveView(double deltaDistance, double deltaX, double deltaY) {
        double newCameraDistance = this.cameraDistance + deltaDistance;
        double newCameraAngle = this.cameraAngle + deltaX;
        double newCameraHeight = this.cameraHeight + deltaY;
        if (newCameraDistance > 5.0) {
            newCameraDistance = 5.0;
        }
        if (newCameraDistance < 0.3) {
            newCameraDistance = 0.3;
        }
        if (newCameraHeight > 0.7) {
            newCameraHeight = 0.7;
        }
        if (newCameraHeight < -0.7) {
            newCameraHeight = -0.7;
        }
        if (newCameraAngle != this.cameraAngle) {
            this.cameraDistance = newCameraDistance;
            this.cameraHeight = newCameraHeight;
            this.cameraAngle = newCameraAngle;
            this.recalculateTransform();
        } else if (newCameraDistance != this.cameraDistance || newCameraHeight != this.cameraHeight) {
            this.cameraDistance = newCameraDistance;
            this.cameraHeight = newCameraHeight;
            this.recalculateViewTransform();
        }
    }

    public double[] getView() {
        return new double[]{this.cameraDistance, this.cameraAngle, this.cameraHeight};
    }

    public void resetView() {
        if (this.configurationState.configurationDataNotReceivedFromController()) {
            return;
        }
        this.cameraAngle = this.robotDraw3D.getCameraAngle();
        this.cameraHeight = this.robotDraw3D.getCameraHeight();
        this.cameraDistance = this.robotDraw3D.getCameraDistance();
        this.recalculateTransform();
    }

    public void setProgramVisualization(ProgramVisualization programVisualizationIn) {
        this.programVisualization = programVisualizationIn;
    }

    public boolean isUndefined() {
        return false;
    }

    public String getName() {
        return CameraView.getStandardName();
    }

    public String toString() {
        return CameraView.getFeatureClassName();
    }

    public static String getStandardName() {
        return "View";
    }

    public static String getFeatureClassName() {
        return LanguagePack.getTextResource().View();
    }

    public WorldTransform getWorldTransform() {
        return this.wt;
    }
}

