/*
 * Decompiled with CFR 0.152.
 */
package gui.geom;

import com.ur.i18n.CommandNamesResource;
import com.ur.injection.Builder;
import com.ur.lang.StringUtils;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.installation.urcap.contributor.ContributorInfo;
import com.ur.polyscope.valueobjects.value.ToolPosition;
import com.ur.polyscope.viewfacade.move.InverseKinematicProviderExt;
import gui.geom.GeomFeatureFactory;
import gui.polyscope.setup.treenodes.geom.GeomLineNode;
import gui.polyscope.setup.treenodes.geom.GeomPlaneNode;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import gui.polyscope.setup.treenodes.geom.GeomPoseNodeContributed;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GeomFeatureFactoryImpl
implements GeomFeatureFactory {
    private final CommandNamesResource commandResource;
    private final NamingService namingService;
    private final Builder builder;
    private final RobotInstallationSite robotInstallationSite;
    private final InverseKinematicProviderExt kinematicsControllerRPC;

    @Inject
    public GeomFeatureFactoryImpl(NamingService namingService, CommandNamesResource commandResource, Builder builder, RobotInstallationSite robotInstallationSite, InverseKinematicProviderExt kinematicsControllerRPC) {
        this.commandResource = commandResource;
        this.builder = builder;
        this.namingService = namingService;
        this.robotInstallationSite = robotInstallationSite;
        this.kinematicsControllerRPC = kinematicsControllerRPC;
    }

    @Override
    public GeomPoseNode createPoseNode(boolean isSubFeature, boolean isHiddenSubFeature) {
        String name = this.namingService.makeUniqueName(GeomPoseNode.class, String.valueOf(isHiddenSubFeature ? "hidden_" : "") + this.commandResource.geomPoint());
        GeomPoseNode result = this.createGeomPoseNode(isSubFeature);
        result.setHiddenSubFeature(isHiddenSubFeature);
        result.setName(name);
        this.namingService.registerNamedEntity((NamedEntity)result);
        return result;
    }

    protected GeomPoseNode createGeomPoseNode(boolean isSubFeature) {
        return this.build(GeomPoseNode.class);
    }

    @Override
    public GeomPoseNode createPoseNode(boolean isSubFeature, boolean isHiddenSubFeature, String name, UUID id) {
        if (StringUtils.isNullOrOnlyWhitespace((String)name)) {
            GeomPoseNode result = this.createPoseNode(isSubFeature, isHiddenSubFeature);
            result.setId(id);
            return result;
        }
        GeomPoseNode result = this.createPoseNode(isSubFeature, isHiddenSubFeature);
        result.setId(id);
        result.setName(name);
        this.namingService.registerNamedEntity((NamedEntity)result);
        return result;
    }

    @Override
    public GeomPoseNode createPoseNode(String suggestedName, ToolPosition pose, JointPositionVector jointPositionVector, ContributorInfo contributorInfo) {
        GeomPoseNodeContributed result = this.createContributedPoseNode(contributorInfo, pose, jointPositionVector);
        if (StringUtils.isNullOrOnlyWhitespace((String)suggestedName)) {
            return result;
        }
        result.setName(suggestedName);
        this.namingService.registerNamedEntity((NamedEntity)result);
        return result;
    }

    private GeomPoseNodeContributed createContributedPoseNode(ContributorInfo contributorInfo, ToolPosition toolPosition, JointPositionVector jointPositionVector) {
        String name = this.namingService.makeUniqueName(GeomPoseNode.class, this.commandResource.geomPoint());
        GeomPoseNodeContributed result = new GeomPoseNodeContributed(contributorInfo, this.robotInstallationSite);
        result.setHiddenSubFeature(false);
        result.setName(name);
        result.setIsVariable(true, false);
        result.setPersistedIsVariable(true);
        if (jointPositionVector == null) {
            JointPositionVector qNear = new JointPositionVector(1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            jointPositionVector = this.kinematicsControllerRPC.getInverseKinematics(new Pose6d(toolPosition.asArray()), qNear);
        }
        result.setPosition(jointPositionVector, new Pose6d(toolPosition.asArray()));
        this.namingService.registerNamedEntity((NamedEntity)result);
        return result;
    }

    @Override
    public GeomLineNode createLineNode() {
        String name = this.namingService.makeUniqueName(GeomLineNode.class, this.commandResource.geomLine());
        GeomLineNode result = this.createGeomLineNode();
        result.setName(name);
        this.namingService.registerNamedEntity((NamedEntity)result);
        return result;
    }

    protected GeomLineNode createGeomLineNode() {
        return this.build(GeomLineNode.class);
    }

    @Override
    public GeomLineNode createLineNode(String name, UUID id) {
        if (StringUtils.isNullOrOnlyWhitespace((String)name)) {
            GeomLineNode result = this.createLineNode();
            result.setId(id);
            return result;
        }
        GeomLineNode result = this.createGeomLineNode();
        result.setId(id);
        result.setName(name);
        this.namingService.registerNamedEntity((NamedEntity)result);
        return result;
    }

    @Override
    public GeomPlaneNode createPlaneNode() {
        String name = this.namingService.makeUniqueName(GeomPlaneNode.class, this.commandResource.geomPlane());
        GeomPlaneNode result = this.createGeomPlaneNode();
        result.setName(name);
        this.namingService.registerNamedEntity((NamedEntity)result);
        return result;
    }

    protected GeomPlaneNode createGeomPlaneNode() {
        return this.build(GeomPlaneNode.class);
    }

    @Override
    public GeomPlaneNode createPlaneNode(String name, UUID id) {
        if (StringUtils.isNullOrOnlyWhitespace((String)name)) {
            GeomPlaneNode result = this.createPlaneNode();
            result.setId(id);
            return result;
        }
        GeomPlaneNode result = this.createGeomPlaneNode();
        result.setId(id);
        result.setName(name);
        this.namingService.registerNamedEntity((NamedEntity)result);
        return result;
    }

    private <T> T build(Class<T> type) {
        return (T)this.builder.get(type);
    }
}

