/*
 * Decompiled with CFR 0.152.
 */
package gui.geom;

import com.ur.lang.ClassUtils;
import com.ur.lang.EqualsUtil;
import com.ur.lang.StringUtils;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.lang.naming.NamingStrategy;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.polyscope.visualizer.geomfeature.GeomFeatureObserver;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.util.logging.Log;
import com.ur.view.variables.domain.VariableLookupService;
import gui.geom.BaseView;
import gui.geom.CameraView;
import gui.geom.ToolView;
import gui.geom.WorldTransform;
import gui.installation.naming.NameResolver;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import gui.polyscope.setup.treenodes.geom.GeomPoseNodeContributed;
import gui.program.position.WaypointNode;
import gui.program.services.GeomFeatureVariable;
import gui.program.services.VarNamingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.inject.Inject;

public class GeomFeatureNamingStrategy
extends NamingStrategy {
    private final NamingService namingService;
    private final VariableLookupService variableLookupService;
    private final NameResolver nameResolver;

    @Inject
    public GeomFeatureNamingStrategy(NamingService namingService, VariableLookupService variableLookupService, NameResolver nameResolver) {
        super(GeomFeature.class);
        this.namingService = namingService;
        this.variableLookupService = variableLookupService;
        this.nameResolver = nameResolver;
    }

    public void setName(NamedEntity entity, String nameCandidate) {
        if (StringUtils.isNullOrOnlyWhitespace((String)nameCandidate)) {
            return;
        }
        if (ClassUtils.isInstanceOfAny((Object)entity, (Class[])new Class[]{BaseView.class, CameraView.class, WorldTransform.class, ToolView.class})) {
            return;
        }
        nameCandidate = this.convertToValidName(nameCandidate);
        if (EqualsUtil.equals((Object)entity.getName(), (Object)nameCandidate) && !this.namingService.isReservedName(nameCandidate)) {
            return;
        }
        boolean isLinkedFeature = this.isFeatureLinked(entity.getName());
        String oldName = entity.getName();
        this.validateNameChange((GeomFeature)entity, nameCandidate, isLinkedFeature, oldName);
    }

    private void validateNameChange(GeomFeature featureNode, String nameCandidate, boolean isLinkedFeature, String oldName) {
        ArrayList otherEntities = new ArrayList(this.namingService.getEntitiesWithName(nameCandidate));
        otherEntities.addAll(this.namingService.getEntitiesWithName(VarNamingStrategy.addVarSuffix(nameCandidate)));
        String newName = nameCandidate;
        boolean nameConflict = false;
        boolean allowLinking = featureNode instanceof GeomPoseNode;
        Iterator otherEntityIterator = otherEntities.iterator();
        while (otherEntityIterator.hasNext()) {
            NamedEntity each = (NamedEntity)otherEntityIterator.next();
            if (this.isEntityBasedOnAssociatedGeomFeatureVariable(each, nameCandidate)) {
                otherEntityIterator.remove();
                continue;
            }
            nameConflict = true;
            allowLinking = this.isLinkingAllowed(allowLinking, each);
        }
        boolean approvedNameChange = true;
        if (nameConflict && allowLinking && (oldName == null || (approvedNameChange = this.nameResolver.allowLinkFeaturesWithTheSameName(nameCandidate)))) {
            featureNode.copyValuesFromEntity((GeomFeature)otherEntities.get(0));
        } else {
            if (!approvedNameChange) {
                return;
            }
            featureNode.makeNewPositionReferences();
            if (nameConflict) {
                newName = this.namingService.makeUniqueName(GeomFeature.class, nameCandidate);
            }
        }
        this.performNameChange(featureNode, oldName, newName, isLinkedFeature);
    }

    private boolean isLinkingAllowed(boolean allowLinking, NamedEntity each) {
        if (!(each instanceof GeomPoseNode) || each instanceof GeomPoseNodeContributed) {
            allowLinking = false;
        }
        return allowLinking;
    }

    private void performNameChange(GeomFeature featureNode, String oldName, String newName, boolean isLinkedFeature) {
        featureNode.setName(newName);
        Log.debug((String)("Name change from \"" + oldName + "\" to \"" + newName + "\""));
        if (!isLinkedFeature) {
            this.fireFeatureNameChange(featureNode, oldName, newName);
        }
    }

    private boolean isEntityBasedOnAssociatedGeomFeatureVariable(NamedEntity entity, String featureName) {
        WaypointNode waypoint;
        if (entity instanceof WaypointNode && (waypoint = (WaypointNode)entity).getPositionNodeType() == PositionNodeType.VARIABLE) {
            return this.isEntityBasedOnAssociatedGeomFeatureVariable(waypoint.getInternalVariable(), featureName);
        }
        return entity instanceof GeomFeatureVariable && EqualsUtil.equals((Object)entity.getName(), (Object)featureName);
    }

    protected void fireFeatureNameChange(final GeomFeature featureNode, final String oldName, final String newName) {
        EventNotificationService.notify(GeomFeatureObserver.class, (NotificationStrategy)new NotificationStrategy<GeomFeatureObserver>(){

            public void notify(GeomFeatureObserver listener) {
                listener.nameChanged((NamedEntity)featureNode, oldName, newName);
            }
        });
    }

    private boolean isFeatureLinked(String originalFeatureName) {
        try {
            Collection<String> featureNames = this.variableLookupService.getFeatureNames();
            featureNames.remove(originalFeatureName);
            return featureNames.contains(originalFeatureName);
        }
        catch (Exception e) {
            Log.warning((String)"Failed to perform actions of getting features: ", (Throwable)e);
            return false;
        }
    }
}

