/*
 * Decompiled with CFR 0.152.
 */
package gui.geom;

import com.ur.lang.Defense;
import com.ur.monitor.RobotState;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.geomfeature.ToolSpatialFeature;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.visualizer.geomfeature.JoggableGeomFeature;
import com.ur.polyscope.visualizer.geomfeature.ProgramVisualization;
import com.ur.util.logging.Log;
import gui.tools.LanguagePack;
import java.util.UUID;
import javax.inject.Inject;
import javax.media.j3d.Transform3D;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;

public class ToolView
extends JoggableGeomFeature
implements ToolSpatialFeature {
    public static final String TOOL_VIEW_NAME = "Joint_6_name";
    private static final Matrix4d CAMERA_ORIENTATION_MATRIX = new Matrix4d(0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    private static final UUID TOOL_VIEW_ID = UUID.fromString("3a9e24b6-0faf-4e81-8344-6af13d2e6405");
    boolean isOnline = true;
    private double cameraOffset;
    private double cameraHeight;
    private double cameraDistance;
    private Pose6d toolPose = new Pose6d(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private ControllerInterface controllerInterface;
    private RobotInstallationSite robotInstallationSite;

    @Inject
    public ToolView(ControllerInterface controllerInterface, RobotInstallationSite robotInstallationSite) {
        this.controllerInterface = controllerInterface;
        this.robotInstallationSite = robotInstallationSite;
        this.setId(TOOL_VIEW_ID);
        this.setName(ToolView.getFeatureClassName());
        this.resetView();
    }

    public static String getStandardName() {
        return TOOL_VIEW_NAME;
    }

    public static String getFeatureClassName() {
        return LanguagePack.getTextResource().Tool();
    }

    public String getScriptCode() {
        return "get_forward_kin()";
    }

    public Transform3D getTransform() {
        if (this.controllerInterface.isConnected() && this.isOnline) {
            this.recalculateTransform();
        }
        return super.getTransform();
    }

    public void recalculateTransform() {
        if (this.isOnline) {
            RobotState robotState = RobotState.getLatestRobotState();
            this.setTransformAccordingToRobotState(robotState.tool);
        } else {
            this.recalculateTransformLocal();
        }
    }

    private void recalculateTransformLocal() {
        Transform3D newTransform = new Transform3D();
        double angle = this.toolPose.getRot().length();
        AxisAngle4d aa4d = new AxisAngle4d(this.toolPose.getRot(), angle);
        Quat4d q4d = new Quat4d();
        q4d.set(aa4d);
        newTransform.set(q4d);
        newTransform.setTranslation(this.toolPose.getPos());
        Transform3D originalTransform = new Transform3D(this.getTransform());
        this.setNewTransform(newTransform);
        if (!originalTransform.epsilonEquals(newTransform, Double.MIN_VALUE)) {
            this.publishTransformChanges();
        }
        this.recalculateViewTransform();
    }

    public void setTransformAccordingToRobotState(Pose6d toolPose) {
        Defense.notNull((Object)toolPose);
        try {
            if (!this.toolPose.equals((Object)toolPose)) {
                this.toolPose = toolPose;
                this.recalculateTransformLocal();
            }
        }
        catch (Exception e) {
            Log.error((String)e.getMessage(), (Throwable)e);
        }
    }

    public void recalculateViewTransform() {
        Transform3D cameraOrientation = new Transform3D(CAMERA_ORIENTATION_MATRIX);
        Transform3D translationToCenter = new Transform3D();
        translationToCenter.setTranslation(new Vector3d(this.cameraDistance, this.cameraOffset, this.cameraHeight));
        Transform3D t3d = new Transform3D(this.getTransform());
        t3d.mul(translationToCenter);
        t3d.mul(cameraOrientation);
        Transform3D newCameraTransform = t3d;
        this.setNewCameraTransform(newCameraTransform);
        this.publishViewChanges();
    }

    public void setOnline(boolean online) {
        this.isOnline = online;
    }

    public void setProgramVisualization(ProgramVisualization programVisualizationIn) {
        this.programVisualization = programVisualizationIn;
    }

    public void moveView(double deltaDistance, double deltaX, double deltaY) {
        double newCameraDistance = this.between(1.0, 3.0, this.cameraDistance + deltaDistance);
        double newCameraOffset = this.between(-0.5, 0.5, this.cameraOffset + deltaX);
        double newCameraHeight = this.between(-0.5, 0.5, this.cameraHeight + deltaY);
        if (newCameraDistance != this.cameraDistance || newCameraHeight != this.cameraHeight || newCameraOffset != this.cameraOffset) {
            this.cameraDistance = newCameraDistance;
            this.cameraHeight = newCameraHeight;
            this.cameraOffset = newCameraOffset;
            this.recalculateViewTransform();
        }
    }

    private double between(double min, double max, double value) {
        if (value > max) {
            value = max;
        }
        if (value < min) {
            value = min;
        }
        return value;
    }

    public void setView(double distance, double x, double y) {
        this.cameraDistance = distance;
        this.cameraOffset = x;
        this.cameraHeight = y;
    }

    public double[] getView() {
        return new double[]{this.cameraDistance, this.cameraOffset, this.cameraHeight};
    }

    public void resetView() {
        this.cameraOffset = -1.0E-4;
        this.cameraHeight = 0.1;
        this.cameraDistance = 1.1;
        if (this.robotInstallationSite.getInstallation() == null) {
            return;
        }
        this.recalculateViewTransform();
    }

    public boolean isUndefined() {
        return false;
    }

    public String getForceModeScriptCode() {
        return "tool_pose()";
    }

    public String getName() {
        return ToolView.getStandardName();
    }

    public String toString() {
        return ToolView.getFeatureClassName();
    }
}

