/*
 * Decompiled with CFR 0.152.
 */
package gui.geom;

import com.ur.lang.EqualsBuilder;
import com.ur.lang.naming.NamedEntity;
import com.ur.polyscope.installation.InstallationChangedEvent;
import com.ur.polyscope.installation.aspect.InstallationChangeEventAspect;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.view.variables.core.Variable;
import gui.geom.WorldTransform$AjcClosure1;
import gui.geom.WorldTransform$AjcClosure3;
import gui.program.position.WaypointNode;
import gui.tools.LanguagePack;
import java.util.UUID;
import javax.media.j3d.Transform3D;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class WorldTransform
extends GeomFeature {
    private static final UUID WORLD_VIEW_ID;
    private double mountingBaseAngle = 0.0;
    private double mountingTiltAngle = 0.0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        WorldTransform.ajc$preClinit();
        WORLD_VIEW_ID = UUID.fromString("1e545cc2-7957-4a60-967d-be88837c61f1");
    }

    public WorldTransform() {
        this(0.0, 0.0);
    }

    public WorldTransform(double mountingBaseAngle, double mountingTiltAngle) {
        this.setId(WORLD_VIEW_ID);
        this.setName(WorldTransform.getFeatureClassName());
        this.mountingBaseAngle = mountingBaseAngle;
        this.mountingTiltAngle = mountingTiltAngle;
        this.recalculateTransform();
    }

    public static String getFeatureClassName() {
        return LanguagePack.getTextResource().worldFeature();
    }

    public String getName() {
        return WorldTransform.getFeatureClassName();
    }

    public double getMountingTiltAngle() {
        return this.mountingTiltAngle;
    }

    @InstallationChangedEvent
    public void setMountingTiltAngle(double mountingTiltAngle) {
        double d = mountingTiltAngle;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d));
        Object[] objectArray = new Object[]{this, Conversions.doubleObject((double)d), joinPoint};
        WorldTransform$AjcClosure1 worldTransform$AjcClosure1 = new WorldTransform$AjcClosure1(objectArray);
        InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(worldTransform$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public double getMountingBaseAngle() {
        return this.mountingBaseAngle;
    }

    @InstallationChangedEvent
    public void setMountingBaseAngle(double mountingBaseAngle) {
        double d = mountingBaseAngle;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d));
        Object[] objectArray = new Object[]{this, Conversions.doubleObject((double)d), joinPoint};
        WorldTransform$AjcClosure3 worldTransform$AjcClosure3 = new WorldTransform$AjcClosure3(objectArray);
        InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(worldTransform$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public void recalculateTransform() {
        Transform3D rotationOfBaseJoint = new Transform3D();
        rotationOfBaseJoint.rotZ(this.mountingBaseAngle);
        Transform3D mount = new Transform3D();
        mount.rotX(this.mountingTiltAngle);
        rotationOfBaseJoint.mul(mount);
        this.setNewTransform(rotationOfBaseJoint);
        this.publishTransformChanges();
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)obj, (boolean)false);
    }

    public String toString() {
        return this.getName();
    }

    public boolean sameAs(NamedEntity entityToCompareTo) {
        if (this == entityToCompareTo) {
            return true;
        }
        if (!this.getName().equals(entityToCompareTo.getName())) {
            return false;
        }
        this.recalculateTransform();
        boolean featureEqualsEntity = false;
        if (entityToCompareTo instanceof GeomFeature) {
            GeomFeature otherFeature = (GeomFeature)entityToCompareTo;
            if (this.getName().equals(otherFeature.getName())) {
                otherFeature.recalculateTransform();
                Transform3D otherTransform = otherFeature.getTransform();
                if (this.getTransform().epsilonEquals(otherTransform, 0.01)) {
                    featureEqualsEntity = true;
                }
            }
        } else if (entityToCompareTo instanceof WaypointNode) {
            WaypointNode wn = (WaypointNode)entityToCompareTo;
            if (wn.getPositionNodeType() == PositionNodeType.VARIABLE && wn.getInternalVariable() != null) {
                Variable v = wn.getInternalVariable();
                featureEqualsEntity = v.sameAs((NamedEntity)this);
            }
        } else if (entityToCompareTo instanceof Variable) {
            Variable v = (Variable)entityToCompareTo;
            featureEqualsEntity = v.sameAs((NamedEntity)this);
        }
        return featureEqualsEntity;
    }

    static final /* synthetic */ void setMountingTiltAngle_aroundBody0(WorldTransform ajc$this, double mountingTiltAngle, JoinPoint joinPoint) {
        ajc$this.mountingTiltAngle = mountingTiltAngle;
        ajc$this.recalculateTransform();
    }

    static final /* synthetic */ void setMountingBaseAngle_aroundBody2(WorldTransform ajc$this, double mountingBaseAngle, JoinPoint joinPoint) {
        ajc$this.mountingBaseAngle = mountingBaseAngle;
        ajc$this.recalculateTransform();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WorldTransform.java", WorldTransform.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMountingTiltAngle", "gui.geom.WorldTransform", "double", "mountingTiltAngle", "", "void"), 57);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMountingBaseAngle", "gui.geom.WorldTransform", "double", "mountingBaseAngle", "", "void"), 67);
    }
}

