/*
 * Decompiled with CFR 0.152.
 */
package gui.installation;

import com.ur.i18n.TextResource;
import com.ur.polyscope.driver.api.dialog.DialogWithName;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.system.ShutdownVeto;
import com.ur.polyscope.viewfacade.safety.RobotInstallationPersistenceService;
import com.ur.swing.dialog.YesNoCancelDialogListener;
import com.ur.util.Waiting;
import gui.tools.DialogCreator;
import gui.tools.YesNoMessage;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class SaveInstallationShutDownVeto
implements ShutdownVeto {
    private final RobotInstallationSite robotInstallationSite;
    private final DialogCreator dialogCreator;
    private final TextResource textResource;
    private final RobotInstallationPersistenceService persistenceService;
    private boolean actionTaken;
    private boolean doShutDown;

    @Inject
    SaveInstallationShutDownVeto(RobotInstallationSite robotInstallationSite, DialogCreator dialogCreator, TextResource textResource, RobotInstallationPersistenceService persistenceService) {
        this.robotInstallationSite = robotInstallationSite;
        this.dialogCreator = dialogCreator;
        this.textResource = textResource;
        this.persistenceService = persistenceService;
    }

    public boolean canShutdown() {
        if (!this.robotInstallationSite.hasModifications()) {
            return true;
        }
        this.actionTaken = false;
        this.doShutDown = false;
        this.dialogCreator.showYesNoCancelDialog(new InstallationYesNoMessage(), new YesNoCancelDialogListener(){

            public void onYesClicked() {
                SaveInstallationShutDownVeto.this.persistenceService.save(SaveInstallationShutDownVeto.this.robotInstallationSite.getInstallation());
                SaveInstallationShutDownVeto.this.doShutDown = true;
                SaveInstallationShutDownVeto.this.actionTaken = true;
            }

            public void onNoClicked() {
                SaveInstallationShutDownVeto.this.doShutDown = true;
                SaveInstallationShutDownVeto.this.actionTaken = true;
            }

            public void onCancelClicked() {
                SaveInstallationShutDownVeto.this.actionTaken = true;
            }
        });
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return SaveInstallationShutDownVeto.this.actionTaken;
            }
        }, (int)30, (TimeUnit)TimeUnit.DAYS);
        return this.doShutDown;
    }

    private class InstallationYesNoMessage
    extends YesNoMessage {
        public InstallationYesNoMessage() {
            super(DialogWithName.UNSAVED_INSTALLATION_CHANGES.getName(), SaveInstallationShutDownVeto.this.textResource.confirmUnsavedInstallationChangesTitle(), SaveInstallationShutDownVeto.this.textResource.confirmUnsavedInstallationChangesExplanation());
        }

        @Override
        public String getOption1() {
            return SaveInstallationShutDownVeto.this.textResource.saveChanges();
        }

        @Override
        public String getOption2() {
            return SaveInstallationShutDownVeto.this.textResource.continueWithoutSaving();
        }
    }
}

