/*
 * Decompiled with CFR 0.152.
 */
package gui.installation.naming;

import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.util.event.EventManager;
import gui.installation.naming.UpdateCache;
import gui.main.PolyScopeStateListener;

final class CacheUpdaterOnLoad
extends ProgramEventListener.Template
implements PolyScopeStateListener {
    private boolean polyScopeLoading = false;
    private boolean doNotUpdateInstallation;
    private UpdateCache namingService;

    public CacheUpdaterOnLoad(UpdateCache namingService, EventManager eventManager) {
        this.namingService = namingService;
        eventManager.addStrongListener(ProgramEventListener.class, (Object)this);
        eventManager.addStrongListener(PolyScopeStateListener.class, (Object)this);
    }

    public void onPreNewProgram() {
        this.doNotUpdateInstallation = true;
    }

    public void onPostNewInstallation() {
        if (this.doNotUpdateInstallation) {
            return;
        }
        if (!this.polyScopeLoading) {
            this.namingService.updateCache();
        }
    }

    public void onPostNewProgram() {
        try {
            if (!this.polyScopeLoading) {
                this.namingService.clearAndUpdateCache();
            }
        }
        finally {
            this.doNotUpdateInstallation = false;
        }
    }

    @Override
    public void onInit() {
        this.polyScopeLoading = true;
    }

    @Override
    public void onReady() {
        this.polyScopeLoading = false;
        this.namingService.clearAndUpdateCache();
    }
}

