/*
 * Decompiled with CFR 0.152.
 */
package gui.installation.naming;

import com.ur.i18n.TextResource;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamedEntityCollection;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.reference.Reference;
import com.ur.util.CollectionUtils;
import com.ur.util.Predicate;
import com.ur.view.variables.InstallationVariableReference;
import com.ur.view.variables.core.ProgramVariable;
import com.ur.view.variables.core.Variable;
import com.ur.view.variables.core.VariableSet;
import com.ur.view.variables.domain.VariableLookupService;
import gui.installation.VariableNameConflictAction;
import gui.installation.naming.NotificationFacade;
import gui.program.ProgramRootNode;
import gui.program.services.GeomFeatureVariable;
import gui.program.services.VarNamingStrategy;
import gui.tools.LegacyURDialogCreator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class NameClashResolverService {
    private final NamingService namingService;
    private VariableLookupService variableLookupService;
    private EventListenerList listeners = new EventListenerList();
    private NotificationFacade notificationFacade;
    private TextResource textResource;

    @Inject
    public NameClashResolverService(VariableLookupService variableLookupService, NamingService namingService, NotificationFacade notificationFacade, TextResource textResource) {
        this.variableLookupService = variableLookupService;
        this.namingService = namingService;
        this.notificationFacade = notificationFacade;
        this.textResource = textResource;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(ChangeListener.class, listener);
    }

    public void resolveNameClash(ProgramRootNode program, VariableNameConflictAction variableNameConflictAction) {
        if (program == null) {
            return;
        }
        Collection<NamedEntity> allInstallationVariables = this.variableLookupService.getVariablesByType(InstallationVariableReference.class);
        allInstallationVariables.addAll(this.variableLookupService.getVariablesByType(GeomFeatureVariable.class));
        HashSet<NamedEntity> installationVariables = new HashSet<NamedEntity>(allInstallationVariables);
        VariableSet programVariables = this.variableLookupService.getAllProgramAndInstallationVariables();
        if (this.hasNamedEntityNameClash(programVariables, allInstallationVariables)) {
            if (variableNameConflictAction == VariableNameConflictAction.REQUEST_USER_INPUT) {
                variableNameConflictAction = LegacyURDialogCreator.popupInstallationVariablesNameClashUserActionDialog(this.textResource);
            }
            this.doResolveNameClashes(program, variableNameConflictAction, programVariables, installationVariables);
            this.notificationFacade.updateCommandTab();
        }
        Collection geomFeatures = this.namingService.getAllEntities().filterByType(GeomFeature.class).getFilteredCollection();
        Collection<Variable> variablesWithClashingNames = this.listVariableWithNamedEntityNameClash(this.variableLookupService.getAllProgramAndInstallationVariables(), geomFeatures);
        if (!variablesWithClashingNames.isEmpty()) {
            this.notificationFacade.notifyFeatureNameClash(variablesWithClashingNames.size());
        }
    }

    private boolean hasNamedEntityNameClash(VariableSet programVariables, Collection<NamedEntity> namedEntities) {
        for (Variable p : programVariables) {
            if (!this.hasSameNameAsNamedEntity(p, namedEntities)) continue;
            return true;
        }
        return false;
    }

    private Collection<Variable> listVariableWithNamedEntityNameClash(VariableSet programVariables, Collection<NamedEntity> namedEntities) {
        ArrayList<Variable> result = new ArrayList<Variable>();
        for (Variable p : programVariables) {
            if (!this.hasSameNameAsNamedEntity(p, namedEntities)) continue;
            result.add(p);
        }
        return result;
    }

    private boolean hasSameNameAsNamedEntity(Variable variable, Collection<NamedEntity> namedEntities) {
        for (NamedEntity namedEntity : namedEntities) {
            if (namedEntity == null || variable.sameAs(namedEntity) || !(variable instanceof ProgramVariable) || !this.hasSameName(variable.getName(), namedEntity)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSameName(String variableName, NamedEntity namedEntity) {
        if (variableName.equals(namedEntity.getName())) {
            return true;
        }
        if (variableName.endsWith(VarNamingStrategy.VAR_SUFFIX)) {
            return variableName.equals(this.getNameOfEntity(namedEntity));
        }
        return false;
    }

    private String getNameOfEntity(NamedEntity namedEntity) {
        if (namedEntity instanceof GeomFeatureVariable) {
            return String.valueOf(namedEntity.getName()) + VarNamingStrategy.VAR_SUFFIX;
        }
        return namedEntity.getName();
    }

    private void doResolveNameClashes(ProgramRootNode program, VariableNameConflictAction variableNameConflictAction, VariableSet programVariables, Collection<NamedEntity> namedEntities) {
        for (Variable p : programVariables) {
            Collection<NamedEntity> namedEntityWithName;
            if (!this.hasSameNameAsNamedEntity(p, namedEntities) || (namedEntityWithName = this.getVariablesByName(p.getName(), namedEntities)).isEmpty()) continue;
            this.doResolveNameClash(program, variableNameConflictAction, p, namedEntityWithName.iterator().next());
        }
    }

    private Collection<NamedEntity> getVariablesByName(final String name, Collection<NamedEntity> variables) {
        return CollectionUtils.filter(variables, (Predicate)new Predicate<NamedEntity>(){

            public boolean test(NamedEntity t) {
                return NameClashResolverService.this.hasSameName(name, t);
            }
        });
    }

    private void doResolveNameClash(ProgramRootNode program, VariableNameConflictAction variableNameConflictAction, Variable programVariable, NamedEntity namedEntity) {
        if (programVariable instanceof ProgramVariable && namedEntity instanceof Reference) {
            if (variableNameConflictAction == VariableNameConflictAction.USE_INSTALLATION_VARIABLES) {
                program.substituteReferenceWithProgramChange((ProgramVariable)programVariable, (Reference)namedEntity);
            } else if (variableNameConflictAction == VariableNameConflictAction.RENAME_PROGRAM_VARIABLES) {
                NamedEntityCollection activelyUsedNames = (NamedEntityCollection)program.getProgramEntitiesInSubtree((Collection)new NamedEntityCollection());
                String newName = this.namingService.makeUniqueName(programVariable.getClass(), programVariable.getName(), activelyUsedNames);
                programVariable.setName(newName);
            }
        }
    }
}

