/*
 * Decompiled with CFR 0.152.
 */
package gui.installation.naming;

import com.ur.lang.ClassUtils;
import com.ur.lang.Defense;
import com.ur.lang.EqualsUtil;
import com.ur.lang.MapOfIdentityLists;
import com.ur.lang.NamingUtils;
import com.ur.lang.StringUtils;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamedEntityCollection;
import com.ur.lang.naming.NamedEntitySource;
import com.ur.lang.naming.NamingService;
import com.ur.lang.naming.NamingStrategy;
import com.ur.lang.naming.NamingStrategyProvider;
import com.ur.polyscope.geomfeature.ProgramFeature;
import com.ur.polyscope.geomfeature.ProgramFeatureService;
import com.ur.polyscope.logging.naming.ReservedNamesProvider;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.undoredo.IgnoreProgramChanges;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.util.event.EventManager;
import com.ur.util.logging.Log;
import com.ur.view.variables.InstallationVariableReference;
import com.ur.view.variables.ReferenceToInstallation;
import gui.installation.naming.CacheUpdaterOnLoad;
import gui.installation.naming.ProgramAndInstallationObjectsNameServer$AjcClosure1;
import gui.installation.naming.UpdateCache;
import gui.program.SuppressedNode;
import gui.program.services.VarNamingStrategy;
import gui.tools.LanguagePack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Singleton
public class ProgramAndInstallationObjectsNameServer
implements NamingService,
UpdateCache,
com.ur.polyscope.program.naming.NamingService {
    private final ProgramFeatureService programFeatureService;
    private final Set<NamedEntitySource> namedSources = new LinkedHashSet<NamedEntitySource>(10);
    private final MapOfIdentityLists<String, NamedEntity> nameToEntities = new MapOfIdentityLists();
    private Set<String> reservedNames;
    private final Set<String> usedNames = new HashSet<String>();
    private NamingStrategyProvider namingStrategyProvider;
    private final ReservedNamesProvider reservedNamesProvider;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Inject
    public ProgramAndInstallationObjectsNameServer(ProgramFeatureService programFeatureService, EventManager eventManager, ReservedNamesProvider reservedNamesProvider) {
        this.programFeatureService = programFeatureService;
        this.reservedNamesProvider = reservedNamesProvider;
        new CacheUpdaterOnLoad(this, eventManager);
    }

    @Inject
    public void setNamingStrategyProvider(NamingStrategyProvider namingStrategyProvider) {
        this.namingStrategyProvider = namingStrategyProvider;
    }

    public void addNamedEntitySource(NamedEntitySource sources) {
        this.namedSources.add(sources);
        if (this.reservedNames != null) {
            for (NamedEntity each : sources.getNamedEntities()) {
                this.doRegisterNamedEntity(each);
            }
            Collection reservedSourceNames = sources.reservedNames();
            this.reservedNames.addAll(reservedSourceNames);
            this.getUsedNames().addAll(reservedSourceNames);
        }
    }

    @Override
    public void updateCache() {
        try {
            this.createCache();
            for (String eachName : this.nameToEntities.keySet()) {
                for (NamedEntity eachEntity : this.nameToEntities.get((Object)eachName)) {
                    this.getNamingStrategy(eachEntity.getClass()).setName(eachEntity, eachName);
                    this.updateName(eachEntity, eachName, eachEntity.getName());
                }
            }
        }
        catch (Exception e) {
            Log.error((String)"Failure when trying to resolve name clashes", (Throwable)e);
        }
    }

    @IgnoreProgramChanges
    private void createCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        ProgramAndInstallationObjectsNameServer$AjcClosure1 programAndInstallationObjectsNameServer$AjcClosure1 = new ProgramAndInstallationObjectsNameServer$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(programAndInstallationObjectsNameServer$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public void registerNamedEntity(NamedEntity entity) {
        if (Log.canLog((Log.Level)Log.Level.DEBUG)) {
            Log.debug((String)("Register: " + entity));
        }
        if (entity instanceof AbstractProgramNode) {
            AbstractProgramNode programNode = (AbstractProgramNode)entity;
            NamedEntityCollection namedEntityCollection = new NamedEntityCollection();
            NamedEntityCollection collection = (NamedEntityCollection)programNode.getProgramEntitiesInSubtree((Collection)namedEntityCollection);
            this.registerNamedEntities(collection);
        } else {
            this.doRegisterNamedEntity(entity);
        }
    }

    public void deregisterNamedEntity(NamedEntity entity) {
        if (Log.canLog((Log.Level)Log.Level.DEBUG)) {
            Log.debug((String)("De-register: " + entity));
        }
        if (entity instanceof AbstractProgramNode) {
            AbstractProgramNode programNode = (AbstractProgramNode)entity;
            NamedEntityCollection namedEntityCollection = new NamedEntityCollection();
            NamedEntityCollection programEntitiesInSubtree = (NamedEntityCollection)programNode.getProgramEntitiesInSubtree((Collection)namedEntityCollection);
            this.deregisterNamedEntities(programEntitiesInSubtree);
        } else if (entity instanceof GeomFeature) {
            this.doDeregisterNamedEntity(entity);
            this.removeChildFeatures((GeomFeature)entity);
            if (entity instanceof ProgramFeature) {
                this.programFeatureService.removeProgramFeature((ProgramFeature)entity);
            }
        } else {
            this.doDeregisterNamedEntity(entity);
        }
    }

    public void registerNamedEntities(NamedEntityCollection collection) {
        for (NamedEntity each : collection.getFilteredCollection()) {
            if (each instanceof InstallationVariableReference || each.getName() == null) continue;
            this.doRegisterNamedEntity(each);
        }
    }

    public void deregisterNamedEntities(NamedEntityCollection collection) {
        for (NamedEntity each : collection.getFilteredCollection()) {
            if (!(each instanceof AbstractProgramNode)) continue;
            this.doDeregisterNamedEntity(each);
        }
    }

    private void doRegisterNamedEntity(NamedEntity entity) {
        Defense.notNull((Object)entity, (String)"NamedEntity cannot be null");
        if (StringUtils.isNullOrEmpty((String)entity.getName())) {
            Log.error((String)"Entity with null name not registered", (Throwable)new IllegalArgumentException());
            return;
        }
        if (ClassUtils.hasAnnotation((Object)entity, ReferenceToInstallation.class)) {
            return;
        }
        NamingStrategy namingStrategy = this.getNamingStrategy(entity.getClass());
        if (namingStrategy.isNameValid(entity.getName())) {
            String oldName = (String)this.nameToEntities.findKey((Object)entity);
            namingStrategy.setName(entity, entity.getName());
            this.updateName(entity, oldName, entity.getName());
            if (Log.canLog((Log.Level)Log.Level.DEBUG)) {
                Log.debug((String)("afterInsert: " + this.nameToEntities.get((Object)entity.getName())));
            }
        } else if (Log.canLog((Log.Level)Log.Level.DEBUG)) {
            Log.debug((String)("Not registering invalid entity name:" + entity.getName()));
        }
    }

    private void doDeregisterNamedEntity(NamedEntity entity) {
        this.nameToEntities.remove((Object)entity.getName(), (Object)entity);
        this.removeReservedNames(entity);
        if (Log.canLog((Log.Level)Log.Level.DEBUG)) {
            Log.debug((String)("after list contains: " + this.nameToEntities.get((Object)entity.getName()).size()));
        }
    }

    private void removeChildFeatures(GeomFeature feature) {
        int i = 0;
        while (i < feature.getChildCount()) {
            NamedEntity childFeature = (NamedEntity)feature.getChildAt(i);
            this.deregisterNamedEntity(childFeature);
            ++i;
        }
    }

    public List<NamedEntity> getEntitiesWithName(String nameCandidate) {
        return this.nameToEntities.get((Object)nameCandidate);
    }

    public NamedEntityCollection getAllEntities() {
        return new NamedEntityCollection((Iterable)this.nameToEntities.allValues());
    }

    public String makeUniqueName(Class<? extends NamedEntity> entityClass, String name) {
        NamingStrategy nameStrategy = this.getNamingStrategy(entityClass);
        return nameStrategy.makeUniqueName(name, this.getUsedNames());
    }

    public String makeUniqueName(Class<? extends NamedEntity> entityClass, String name, NamedEntityCollection currentlyUsedNames) {
        this.addUniqueNamesFromInstallation(currentlyUsedNames);
        Set<String> usedNamesSet = this.asStringNames(currentlyUsedNames.getFilteredCollection());
        HashSet<String> additionalUsedNames = new HashSet<String>();
        for (String each : usedNamesSet) {
            if (each.endsWith(VarNamingStrategy.VAR_SUFFIX)) {
                additionalUsedNames.add(each.substring(0, each.length() - VarNamingStrategy.VAR_SUFFIX.length()));
                continue;
            }
            additionalUsedNames.add(VarNamingStrategy.addVarSuffix(each));
        }
        usedNamesSet.addAll(additionalUsedNames);
        usedNamesSet.addAll(this.getUsedNames());
        return this.getNamingStrategy(entityClass).makeUniqueName(name, usedNamesSet);
    }

    private Set<String> getUsedNames() {
        if (this.usedNames.isEmpty()) {
            this.usedNames.addAll(this.createAllReservedNames());
        }
        return this.usedNames;
    }

    private Set<String> asStringNames(Iterable<NamedEntity> entitiesWithUniqueNames) {
        HashSet<String> result = new HashSet<String>();
        for (NamedEntity each : entitiesWithUniqueNames) {
            result.add(each.getName());
        }
        return result;
    }

    private void addUniqueNamesFromInstallation(NamedEntityCollection entitiesWithUniqueNames) {
        Collection<NamedEntity> uniqueNameEntities = this.getUniqueNameEntitiesFromInstallation();
        entitiesWithUniqueNames.addAll(uniqueNameEntities);
    }

    private Collection<NamedEntity> getUniqueNameEntitiesFromInstallation() {
        HashMap<String, NamedEntity> installationEntities = new HashMap<String, NamedEntity>();
        for (NamedEntitySource eachSource : this.namedSources) {
            for (NamedEntity eachEntity : eachSource.getNamedEntities()) {
                installationEntities.put(eachEntity.getName(), eachEntity);
            }
        }
        return installationEntities.values();
    }

    public boolean isNameValid(Class<? extends NamedEntity> entityClass, String name) {
        return this.getNamingStrategy(entityClass).isNameValid(name);
    }

    public int maxNameLength(Class<? extends NamedEntity> entityClass) {
        return this.getNamingStrategy(entityClass).maxNameLength();
    }

    public boolean isNameUsed(Class<? extends NamedEntity> entityClass, String name) {
        if (entityClass == null) {
            return this.isNameUsed(name);
        }
        NamingStrategy nameStrategy = this.getNamingStrategy(entityClass);
        String validName = nameStrategy.convertToValidName(name);
        return this.getUsedNames().contains(validName);
    }

    public boolean isNameUsed(String name) {
        return this.isNameUsed(name, this.getUsedNames());
    }

    private boolean isNameUsed(String newName, Collection<String> names) {
        newName = this.toVariableName(newName);
        return names.contains(newName);
    }

    private Collection<? extends String> toVariableNames(Collection<String> names) {
        ArrayList<String> result = new ArrayList<String>();
        for (String each : names) {
            result.add(this.toVariableName(each));
            result.add(each);
        }
        return result;
    }

    public String toVariableName(String name) {
        return NamingUtils.replaceSpacesWithUnderscores((String)name);
    }

    public void setNameOfEntity(NamedEntity entity, String nameCandidate) {
        if (entity == null || nameCandidate == null) {
            Log.error((String)("Could not rename entity since given arguments were:\n\tentity = " + entity + "\tnameCandidate = " + nameCandidate));
            return;
        }
        String oldName = entity.getName();
        NamingStrategy namingStrategy = this.getNamingStrategy(entity.getClass());
        if (nameCandidate.length() > 0 && !namingStrategy.isNameValid(nameCandidate)) {
            Log.warning((String)("Invalid entity name: " + nameCandidate));
        }
        try {
            namingStrategy.setName(entity, nameCandidate);
        }
        finally {
            String newName = entity.getName();
            if (!EqualsUtil.equals((Object)oldName, (Object)newName)) {
                this.updateName(entity, oldName, newName);
            }
        }
    }

    public void updateName(NamedEntity entity, String oldName, String newName) {
        this.nameToEntities.remove((Object)oldName, (Object)entity);
        if (!this.nameToEntities.contains((Object)newName, (Object)entity)) {
            this.nameToEntities.put((Object)newName, (Object)entity);
            if (entity instanceof SuppressedNode) {
                this.handleSuppressedChilds((SuppressedNode)entity);
            }
        }
        this.updateUsedNames(oldName, newName, entity);
    }

    private void handleSuppressedChilds(SuppressedNode entity) {
        NamedEntityCollection programEntitiesInSubtree = (NamedEntityCollection)entity.getSuppressedNode().getProgramEntitiesInSubtree((Collection)new NamedEntityCollection());
        for (Object o : programEntitiesInSubtree) {
            NamedEntity ne = (NamedEntity)o;
            if (ne instanceof SuppressedNode) {
                this.updateName(ne, ne.getName(), ne.getName());
                continue;
            }
            this.updateUsedNames(null, ne.getName(), ne);
        }
    }

    private void updateUsedNames(String oldName, String newName, NamedEntity namedEntity) {
        NamingStrategy namingStrategy = this.getNamingStrategy(namedEntity.getClass());
        this.removeUsedName(oldName, namingStrategy);
        this.addUsedName(newName, namingStrategy);
    }

    private void addUsedName(String name, NamingStrategy namingStrategy) {
        this.getUsedNames().add(name);
        this.getUsedNames().addAll(this.getVarNames(name));
        this.getUsedNames().addAll(namingStrategy.getAdditionalReservedNames(name));
    }

    private void removeUsedName(String name, NamingStrategy namingStrategy) {
        if (name == null || this.getReservedNames().contains(name)) {
            return;
        }
        this.getUsedNames().remove(name);
        this.getUsedNames().removeAll(this.getVarNames(name));
        this.getUsedNames().removeAll(namingStrategy.getAdditionalReservedNames(name));
        List list = this.nameToEntities.get((Object)name);
        for (NamedEntity entity : list) {
            NamingStrategy entityStrategy = this.getNamingStrategy(entity.getClass());
            this.addUsedName(entity.getName(), entityStrategy);
        }
    }

    private void removeReservedNames(NamedEntity entity) {
        NamingStrategy namingStrategy = this.getNamingStrategy(entity.getClass());
        this.removeUsedName(entity.getName(), namingStrategy);
    }

    private List<String> getVarNames(String name) {
        ArrayList<String> varNames = new ArrayList<String>();
        if (name.endsWith(VarNamingStrategy.VAR_SUFFIX)) {
            varNames.add(name.substring(0, name.length() - VarNamingStrategy.VAR_SUFFIX.length()));
        } else {
            varNames.add(VarNamingStrategy.addVarSuffix(name));
        }
        return varNames;
    }

    public boolean isReservedName(String name) {
        return this.getReservedNames().contains(name);
    }

    private NamingStrategy getNamingStrategy(Class<? extends NamedEntity> eachEntityClass) {
        return this.namingStrategyProvider.getNamingStrategy(eachEntityClass);
    }

    private Set<String> getReservedNames() {
        if (this.reservedNames == null) {
            this.reservedNames = this.createAllReservedNames();
        }
        return this.reservedNames;
    }

    private Set<String> createAllReservedNames() {
        HashSet<String> allReservedNames = new HashSet<String>();
        allReservedNames.addAll(this.toVariableNames(LanguagePack.getReservedCommandNames()));
        allReservedNames.addAll(Arrays.asList(this.reservedNamesProvider.getAllKeywords()));
        for (NamedEntitySource each : this.namedSources) {
            allReservedNames.addAll(each.reservedNames());
        }
        return allReservedNames;
    }

    @Override
    public void clearAndUpdateCache() {
        this.programFeatureService.clearProgramFeatures();
        this.updateCache();
    }

    static {
        ProgramAndInstallationObjectsNameServer.ajc$preClinit();
    }

    static final /* synthetic */ void createCache_aroundBody0(ProgramAndInstallationObjectsNameServer ajc$this, JoinPoint joinPoint) {
        NamedEntitySource[] sources;
        ajc$this.nameToEntities.clear();
        ajc$this.usedNames.clear();
        NamedEntitySource[] namedEntitySourceArray = sources = ajc$this.namedSources.toArray(new NamedEntitySource[0]);
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            NamedEntitySource each = namedEntitySourceArray[n2];
            for (NamedEntity eachNamedEntity : each.getNamedEntities()) {
                ajc$this.registerNamedEntity(eachNamedEntity);
            }
            ++n2;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ProgramAndInstallationObjectsNameServer.java", ProgramAndInstallationObjectsNameServer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createCache", "gui.installation.naming.ProgramAndInstallationObjectsNameServer", "", "", "", "void"), 96);
    }
}

