/*
 * Decompiled with CFR 0.152.
 */
package gui.installation.naming;

import com.ur.lang.EqualsUtil;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.lang.naming.NamingStrategy;
import gui.program.SubProgramNode;
import javax.inject.Inject;

public class SubProgramNamingStrategy
extends NamingStrategy {
    public static final int MAXIMUM_LENGTH_OF_NAME = 25;
    private final NamingService namingService;

    @Inject
    public SubProgramNamingStrategy(NamingService namingService) {
        super(SubProgramNode.class);
        this.namingService = namingService;
    }

    public void setName(NamedEntity entity, String nameCandidate) {
        nameCandidate = this.convertToValidName(nameCandidate);
        if (EqualsUtil.equals((Object)entity.getName(), (Object)nameCandidate) && !this.namingService.isReservedName(nameCandidate)) {
            return;
        }
        if (this.namingService.isNameUsed(SubProgramNode.class, nameCandidate)) {
            nameCandidate = this.namingService.makeUniqueName(SubProgramNode.class, nameCandidate);
        }
        entity.setName(nameCandidate);
    }

    public int maxNameLength() {
        return 25;
    }
}

