/*
 * Decompiled with CFR 0.152.
 */
package gui.installation.naming;

import com.ur.lang.EqualsUtil;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.lang.naming.NamingStrategy;
import gui.program.ThreadNode;
import javax.inject.Inject;

public class ThrowWhenUsedNamingStrategy
extends NamingStrategy {
    private final NamingService namingService;

    @Inject
    public ThrowWhenUsedNamingStrategy(NamingService namingService) {
        super(ThreadNode.class);
        this.namingService = namingService;
    }

    public void setName(NamedEntity entity, String nameCandidate) {
        nameCandidate = this.convertToValidName(nameCandidate);
        if (EqualsUtil.equals((Object)entity.getName(), (Object)nameCandidate) && !this.namingService.isReservedName(nameCandidate)) {
            return;
        }
        if (this.namingService.isNameUsed(entity.getClass(), nameCandidate)) {
            throw new NameIsNotAvailable(nameCandidate);
        }
        entity.setName(nameCandidate);
    }

    public class NameIsNotAvailable
    extends RuntimeException {
        public NameIsNotAvailable(String nameCandidate) {
            super("The given name '" + nameCandidate + "' is already in use!");
        }
    }
}

