/*
 * Decompiled with CFR 0.152.
 */
package gui.installation.naming;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.reversible.Reversible;
import com.ur.reversible.ReversibleAction;
import com.ur.reversible.ReversibleSequence;
import com.ur.reversible.SubstituteValues;
import com.ur.reversible.UndoRedoListener;
import gui.installation.VariableNameConflictAction;
import gui.installation.naming.NameClashResolverService;
import gui.installation.services.ProgramLookupService;
import gui.program.ProgramUndoRedoService;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class VariableNameClashResolver
implements UndoRedoListener<AbstractProgramNode> {
    private NameClashResolverService nameClashResolverService;
    private ProgramLookupService programLookupService;
    private boolean shouldResolveNameClash = true;

    @Inject
    public VariableNameClashResolver(NameClashResolverService nameClashResolverService, ProgramLookupService programLookupService, ProgramUndoRedoService undoRedoService) {
        this.nameClashResolverService = nameClashResolverService;
        this.programLookupService = programLookupService;
        if (undoRedoService != null) {
            undoRedoService.addListener(this);
        }
    }

    public void perform(ReversibleAction action, Reversible<AbstractProgramNode> reversible) {
        if (this.containsReversibleWithSubstituteReferenceMethod(action, reversible)) {
            this.shouldResolveNameClash = false;
        }
        if (this.shouldResolveNameClash && (action == ReversibleAction.Consume || action == ReversibleAction.ConsumeNew) && !(reversible instanceof SubstituteValues)) {
            this.resolveNameClash();
        }
        if (action == ReversibleAction.PostRedo || action == ReversibleAction.PostUndo) {
            this.shouldResolveNameClash = true;
        }
    }

    private boolean containsReversibleWithSubstituteReferenceMethod(ReversibleAction action, Reversible<AbstractProgramNode> reversible) {
        return (action == ReversibleAction.PreRedo || action == ReversibleAction.PreUndo) && this.reversibleContainsSubstituteReferenceMethod(reversible);
    }

    public void resolveNameClash() {
        if (this.programLookupService.getProgramRootNode() != null) {
            this.nameClashResolverService.resolveNameClash(this.programLookupService.getProgramRootNode(), this.getVariableNameConflictAction());
        }
    }

    protected VariableNameConflictAction getVariableNameConflictAction() {
        return VariableNameConflictAction.REQUEST_USER_INPUT;
    }

    public boolean reversibleContainsSubstituteReferenceMethod(Reversible reversible) {
        if (!(reversible instanceof ReversibleSequence)) {
            return false;
        }
        if (((ReversibleSequence)reversible).contains(SubstituteValues.class)) {
            List substituteReversibles = ((ReversibleSequence)reversible).getReversiblesWithClass(SubstituteValues.class);
            for (Reversible substituteReversible : substituteReversibles) {
                if (!((SubstituteValues)substituteReversible).hasMethodName("substituteReference")) continue;
                return true;
            }
        }
        return false;
    }
}

