/*
 * Decompiled with CFR 0.152.
 */
package gui.installation.services;

import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.installation.InstallationListener;
import com.ur.polyscope.installation.MetaData;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.installation.domain.PostCreateInstallation;
import com.ur.polyscope.installation.domain.PreCreateInstallation;
import com.ur.polyscope.installation.domain.UnderWayInstallation;
import com.ur.util.event.EventManager;
import com.ur.util.event.NotificationStrategy;
import gui.installation.services.RobotInstallationCreator;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;

public class DefaultRobotInstallationCreator
implements RobotInstallationCreator {
    private Set<PreCreateInstallation> preCreateInstallations;
    private final Set<PostCreateInstallation> postCreateInstallations;
    private final Set<UnderWayInstallation> underWayInstallations;
    private final Provider<Installation> robotInstallationProvider;
    private final EventManager eventManager;

    @Inject
    public DefaultRobotInstallationCreator(Set<PreCreateInstallation> preCreateInstallations, Set<UnderWayInstallation> underWayInstallations, Set<PostCreateInstallation> postCreateInstallations, Provider<Installation> robotInstallationProvider, EventManager eventManager) {
        this.preCreateInstallations = preCreateInstallations;
        this.underWayInstallations = underWayInstallations;
        this.postCreateInstallations = postCreateInstallations;
        this.robotInstallationProvider = robotInstallationProvider;
        this.eventManager = eventManager;
    }

    @Override
    public Installation createDefaultWith(String name, Set<InstallationComponent> installationComponents) {
        Installation robotInstallation = this.createRobotInstallation();
        PersistanceMetaData persistanceMetaData = (PersistanceMetaData)robotInstallation.getMetaData(PersistanceMetaData.class);
        robotInstallation.setMetaData((MetaData)new PersistanceMetaData(persistanceMetaData.directory(), name));
        final InstallationListener.Event event = new InstallationListener.Event(InstallationListener.EventType.RESET_INSTALLATION_URCAPS, robotInstallation);
        this.eventManager.fireEvent(InstallationListener.class, (NotificationStrategy)new NotificationStrategy<InstallationListener>(){

            public void notify(InstallationListener installationListener) {
                installationListener.onInstallationEvent(event);
            }
        });
        for (InstallationComponent installationComponent : installationComponents) {
            robotInstallation.setComponent(installationComponent);
        }
        for (PostCreateInstallation each : this.postCreateInstallations) {
            each.postCreate(robotInstallation);
        }
        return robotInstallation;
    }

    @Override
    public Installation createRobotInstallation() {
        for (PreCreateInstallation each : this.preCreateInstallations) {
            each.preCreate();
        }
        return this.getRobotInstallation();
    }

    @Override
    public Installation createRobotInstallationIgnoreContributions() {
        for (PreCreateInstallation each : this.preCreateInstallations) {
            each.preCreate();
        }
        return this.getRobotInstallation();
    }

    private Installation getRobotInstallation() {
        Installation robotInstallation = (Installation)this.robotInstallationProvider.get();
        for (UnderWayInstallation underWayInstallation : this.underWayInstallations) {
            underWayInstallation.installationUnderWay(robotInstallation);
        }
        return robotInstallation;
    }
}

