/*
 * Decompiled with CFR 0.152.
 */
package gui.installation.services;

import com.ur.lang.EqualsUtil;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.geomfeature.ProgramFeature;
import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.util.CollectionUtils;
import com.ur.util.Predicate;
import gui.installation.RobotInstallationLookupService;
import gui.polyscope.setup.treenodes.geom.SetupFeatureContainerNode;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;

public class FeaturesLookupImpl
implements FeaturesLookup {
    private RobotInstallationLookupService installationLookupService;
    private NamingService namingService;

    @Inject
    public FeaturesLookupImpl(RobotInstallationLookupService installationLookupService, NamingService namingService) {
        this.installationLookupService = installationLookupService;
        this.namingService = namingService;
    }

    public SetupFeatureContainerNode getFeatureContainer() {
        return (SetupFeatureContainerNode)this.installationLookupService.getInstallation().getComponent(SetupFeatureContainerNode.class);
    }

    public Iterable<SpatialFeature> getFeaturesBy(Predicate<SpatialFeature> predicate) {
        return CollectionUtils.filter(this.getFeatureContainer().getAllSpatialFeatures(), predicate);
    }

    public GeomFeature getFeatureByUUID(UUID featureSourceId) {
        for (GeomFeature each : ((SetupFeatureContainerNode)this.installationLookupService.getComponent(SetupFeatureContainerNode.class)).getUniqueGeomNodes(true)) {
            if (!EqualsUtil.equals((Object)each.getId(), (Object)featureSourceId)) continue;
            return each;
        }
        return null;
    }

    public GeomFeature dereferenceByTopLevelFeature(String entityName) {
        List entities = this.namingService.getEntitiesWithName(entityName);
        for (NamedEntity each : entities) {
            if (!(each instanceof GeomFeature) || !this.isTopLevelNodeOnFeatureTree(each)) continue;
            return (GeomFeature)each;
        }
        return null;
    }

    private boolean isTopLevelNodeOnFeatureTree(NamedEntity each) {
        GeomFeature feature = (GeomFeature)each;
        if (feature.getParent() == null) {
            return true;
        }
        return feature.getParent() instanceof SetupFeatureContainerNode || feature instanceof ProgramFeature;
    }
}

