/*
 * Decompiled with CFR 0.152.
 */
package gui.installation.services;

import com.ur.i18n.TextResource;
import com.ur.lang.Defense;
import com.ur.move.StartingNodeTitle;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramSelectionModel;
import com.ur.util.logging.Log;
import gui.installation.services.ProgramLookupService;
import gui.polyscope.DashBoard;
import gui.program.ProgramRootNode;
import gui.program.ProgramRootNodeLoad;
import java.io.File;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ProgramLookupServiceImpl
implements ProgramLookupService,
StartingNodeTitle {
    private final TextResource textResource;

    @Inject
    public ProgramLookupServiceImpl(TextResource textResource) {
        this.textResource = textResource;
    }

    @Override
    public ProgramRootNode getProgramRootNode() {
        return DashBoard.getProgram();
    }

    @Override
    public AbstractProgramNode getSelectedNode() {
        if (this.getProgramRootNode() != null) {
            return this.getProgramRootNode().getComponent(ProgramSelectionModel.class).getCurrentNode();
        }
        return null;
    }

    @Override
    public void setSelectedNode(AbstractProgramNode toSelect) {
        Defense.notNull((Object)toSelect, (String)"Cannot set selected node to null");
        if (this.getProgramRootNode() != null) {
            this.getProgramRootNode().getComponent(ProgramSelectionModel.class).setSelected(toSelect);
        }
    }

    @Override
    public boolean loadWithoutKinematicChecking(File file) {
        DashBoard.autoLoadingNoPopups = true;
        try {
            this.selectMainNodeOfCurrentProgram();
            ProgramRootNode p = ProgramRootNodeLoad.loadWithOutKinematicCheck(file);
            if (p == null) {
                Log.error((String)"Load without kinematic check returned null");
                return false;
            }
            DashBoard.setProgram(p);
            return true;
        }
        finally {
            DashBoard.autoLoadingNoPopups = false;
        }
    }

    private void selectMainNodeOfCurrentProgram() {
        ProgramRootNode currentProgram = this.getProgramRootNode();
        if (currentProgram != null) {
            this.setSelectedNode(currentProgram.getMainProgram());
        }
    }

    public String getStartingNodeTitle() {
        if (this.getProgramRootNode() == null) {
            return "";
        }
        AbstractProgramNode node = this.getProgramRootNode().getStartingNode();
        if (node == this.getProgramRootNode().getMainProgram()) {
            return node.toString();
        }
        return this.textResource.linePositionTitle(node.getId(), node.toString());
    }
}

