/*
 * Decompiled with CFR 0.152.
 */
package gui.installation.services;

import com.ur.i18n.TextResource;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.installation.InstallationNode;
import com.ur.polyscope.installation.InstallationScriptGenerator;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.scriptwriter.ScriptGenerator;
import com.ur.polyscope.scriptwriter.ScriptGeneratorLookup;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.util.Optional;
import com.ur.util.logging.Log;
import com.ur.view.polyscope.module.installation.InstallationContributionsProvider;
import com.ur.view.polyscope.persistence.installation.InstallationMetaData;
import com.ur.view.polyscope.persistence.installation.RobotInstallationPersistence;
import com.ur.view.variables.domain.InstallationVariables;
import com.ur.view.variables.domain.VariableLookupService;
import gui.installation.RobotInstallationLookupService;
import gui.installation.services.RobotInstallationCreator;
import gui.program.services.GeomFeatureVariable;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RobotInstallationLookupServiceImpl
extends InstallationNode
implements RobotInstallationLookupService {
    private final RobotInstallationSite robotInstallationSite;
    private final InstallationContributionsProvider installationsProvider;
    private final RobotInstallationCreator creator;
    private final VariableLookupService variableLookupService;
    private final TextResource textResource;

    @Inject
    public RobotInstallationLookupServiceImpl(RobotInstallationSite robotInstallationSite, InstallationContributionsProvider installationsProvider, RobotInstallationCreator creator, VariableLookupService variableLookupService, TextResource textResource) {
        this.robotInstallationSite = robotInstallationSite;
        this.installationsProvider = installationsProvider;
        this.creator = creator;
        this.variableLookupService = variableLookupService;
        this.textResource = textResource;
    }

    @Override
    public Installation getInstallation() {
        return this.robotInstallationSite.getInstallation();
    }

    @Override
    @Deprecated
    public void setInstallation(Installation loadedInstallation) {
        if (!this.robotInstallationSite.setInstallation(loadedInstallation)) {
            this.loadPreviousInstallation();
        }
    }

    @Override
    public void loadPreviousInstallation() {
        try {
            RobotInstallationPersistence.load(((PersistanceMetaData)this.getInstallation().getMetaData(PersistanceMetaData.class)).file());
        }
        catch (Exception e) {
            String err = this.textResource.notAnInstallation(e.getClass().getName());
            Log.error((String)err, (Throwable)e);
            this.robotInstallationSite.loadDefaultInstallation();
        }
    }

    @Override
    public boolean isInstallationWithInternalVersion() {
        Installation installation = this.robotInstallationSite.getInstallation();
        InstallationMetaData installationMetaData = (InstallationMetaData)installation.getMetaData(InstallationMetaData.class);
        return installationMetaData != null && installationMetaData.getCreatedInInstallationVersion() > 0 && installationMetaData.getLastSavedInInstallationVersion() > 0;
    }

    @Override
    public void createDefaultInstallation(String defaultName) {
        Installation defaultInstallation = this.creator.createDefaultWith(defaultName, new HashSet<InstallationComponent>());
        this.robotInstallationSite.setInstallation(defaultInstallation);
    }

    @Override
    public void createDefaultInstallation(String defaultName, Set<InstallationComponent> installationComponents) {
        Installation robotInstallation = this.creator.createDefaultWith(defaultName, installationComponents);
        this.robotInstallationSite.setInstallation(robotInstallation);
    }

    public boolean hasInstallation() {
        return this.getInstallation() != null;
    }

    public <T extends InstallationComponent> T getComponent(Class<T> componentType) {
        Optional<T> mayHaveComponent = this.get(componentType);
        if (mayHaveComponent.isPresent()) {
            return (T)((InstallationComponent)mayHaveComponent.get());
        }
        Log.warning((String)("Could not find component: " + componentType));
        return null;
    }

    public void setComponent(InstallationComponent component) {
        this.getInstallation().setComponent(component);
    }

    public <T extends InstallationComponent> Optional<T> get(Class<T> component) {
        if (this.getInstallation() == null) {
            return Optional.empty();
        }
        InstallationComponent value = this.getInstallation().getComponent(component);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of((Object)value);
    }

    @Override
    public InstallationContributionsProvider getInstallationContributionsProvider() {
        return this.installationsProvider;
    }

    @Override
    public void generatePreambleScript(ScriptWriter writer, ScriptGeneratorLookup scriptGeneratorLookup) {
        this.getScriptGenerator().generateScriptCodeWithRangeEncapsulation(writer, scriptGeneratorLookup);
    }

    @Override
    public void clearErrors(Installation oldInstallation) {
        InstallationScriptGenerator.clearRuntimeExceptionRegister((Installation)oldInstallation);
    }

    public String getTypeName() {
        return this.getInstallation().getTypeName();
    }

    public ScriptWriter generatePreambleScript(ScriptWriter writer) {
        this.getInstallation().getScriptGenerator().generateScriptCodeWithRangeEncapsulation(writer, this.getScriptGenerator().getScriptGeneratorLookup());
        this.getComponent(InstallationVariables.class).getScriptGenerator().generateScriptCodeWithRangeEncapsulation(writer, this.getScriptGenerator().getScriptGeneratorLookup());
        if (this.variableLookupService != null) {
            this.variableLookupService.generatePreambleScript(writer, (ScriptGenerator)this.getScriptGenerator(), GeomFeatureVariable.class, false, true);
        }
        this.installationsProvider.generatePreambleScript(writer, this.getScriptGenerator().getScriptGeneratorLookup());
        return writer;
    }

    @Override
    public Installation load(File path, String name) {
        File installationFile = new File(path, String.valueOf(name) + ".installation");
        try {
            return RobotInstallationPersistence.load(installationFile);
        }
        catch (IOException iOException) {
            Log.error((String)("Failed to load installation: " + installationFile));
            return null;
        }
    }
}

