/*
 * Decompiled with CFR 0.152.
 */
package gui.installation.services;

import com.ur.disk.Directories;
import com.ur.i18n.TextResource;
import com.ur.log.logentry.robotmessage.RobotMessageProducer;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.installation.InstallationListener;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.installation.domain.PostSetInstallation;
import com.ur.polyscope.installation.domain.PreSetInstallation;
import com.ur.polyscope.installation.domain.SetInstallationValidator;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.viewfacade.safety.RobotInstallationPersistenceService;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.util.event.EventManager;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.util.logging.Log;
import com.ur.util.swing.HTML;
import gui.installation.InitialInstallationComponentContribution;
import gui.installation.RobotInstallationLookupService;
import gui.installation.services.SetInstallationHandlers;
import gui.polyscope.DashBoard;
import gui.tools.LegacyURDialogCreator;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
class SingleRobotInstallationSite
implements RobotInstallationSite {
    private static final String DEFAULT_INSTALLATION_FILE_NAME = "default.installation";
    private static final String DEFAULT_INSTALLATION_BACKUP_FILE_NAME = "default.installation.problem";
    private static final String DEFAULT_VARIABLES_FILE_NAME = "default.variables";
    private static final String DEFAULT_VARIABLE_BACKUP_FILE_NAME = "default.variables.problem";
    private final SetInstallationHandlers setInstallationHandlers;
    private final RobotInstallationLookupService robotInstallationLookupService;
    private final InstallationModified installationModified;
    private final RobotInstallationPersistenceService persistenceService;
    private Installation installation = null;
    private boolean isLoadingInstallation;
    private final Set<InitialInstallationComponentContribution> initialInstallationComponentContributions;
    private TextResource textResource;

    @Inject
    public SingleRobotInstallationSite(SetInstallationHandlers setInstallationHandlers, RobotInstallationLookupService robotInstallationLookupService, InstallationModified installationModified, RobotInstallationPersistenceService persistenceService, Set<InitialInstallationComponentContribution> initialInstallationComponentContributions, TextResource textResource) {
        this.setInstallationHandlers = setInstallationHandlers;
        this.robotInstallationLookupService = robotInstallationLookupService;
        this.installationModified = installationModified;
        this.persistenceService = persistenceService;
        this.initialInstallationComponentContributions = initialInstallationComponentContributions;
        this.textResource = textResource;
    }

    private static boolean backupDefaultInstallation() {
        boolean result = false;
        File originalInstallationFile = new File(Directories.programs(), DEFAULT_INSTALLATION_FILE_NAME);
        File originalVariablesFile = new File(Directories.programs(), DEFAULT_VARIABLES_FILE_NAME);
        if (originalInstallationFile.exists()) {
            File installationBackupFile = new File(Directories.programs(), DEFAULT_INSTALLATION_BACKUP_FILE_NAME);
            result |= SingleRobotInstallationSite.backupFile(originalInstallationFile, installationBackupFile);
        }
        if (originalVariablesFile.exists()) {
            File variablesBackupFile = new File(Directories.programs(), DEFAULT_VARIABLE_BACKUP_FILE_NAME);
            result &= SingleRobotInstallationSite.backupFile(originalVariablesFile, variablesBackupFile);
        }
        return result;
    }

    private static boolean backupFile(File original, File backup) {
        try {
            boolean success = original.renameTo(backup);
            if (!success && backup.exists()) {
                backup.delete();
                success = original.renameTo(backup);
                if (!success) {
                    Log.error((String)("Failed to backup default file as " + backup.getName()));
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            Log.error((String)("Failed to backup default file as " + backup));
            return false;
        }
    }

    public void loadDefaultInstallation() {
        Installation loadedInstallation = this.robotInstallationLookupService.load(Directories.programs(), "default");
        HashSet<InstallationComponent> initialInstallationComponents = new HashSet<InstallationComponent>();
        for (InitialInstallationComponentContribution contribution : this.initialInstallationComponentContributions) {
            initialInstallationComponents.add(contribution.getInitialInstallation());
        }
        if (loadedInstallation == null) {
            boolean backupSuccess = SingleRobotInstallationSite.backupDefaultInstallation();
            if (backupSuccess) {
                Log.error((String)this.createFailedToBackupMessage());
            } else {
                Log.error((String)this.createFailedToLoadMessage());
            }
            this.robotInstallationLookupService.createDefaultInstallation("default", initialInstallationComponents);
            loadedInstallation = this.robotInstallationLookupService.getInstallation();
            this.persistenceService.save(loadedInstallation);
            new RobotMessageProducer().generateAndNotify(this.textResource.failedToLoadInstallation());
        }
        if (!this.setInstallation(loadedInstallation)) {
            SingleRobotInstallationSite.backupDefaultInstallation();
            this.robotInstallationLookupService.createDefaultInstallation("default", initialInstallationComponents);
            Installation defaultInstallation = this.robotInstallationLookupService.getInstallation();
            this.persistenceService.save(defaultInstallation);
            this.setInstallation(defaultInstallation);
        }
    }

    public boolean hasModifications() {
        return this.installationModified.isModified();
    }

    public boolean isLoadingInstallation() {
        return this.isLoadingInstallation;
    }

    public boolean setInstallation(Installation newInstallation) {
        try {
            this.isLoadingInstallation = true;
            for (SetInstallationValidator setInstallationValidator : this.setInstallationHandlers.getValidations()) {
                SetInstallationValidator.Validity validity = setInstallationValidator.validate(newInstallation);
                if (validity == SetInstallationValidator.Validity.ERROR) {
                    this.showErrorMessage(setInstallationValidator.getErrorMessage(newInstallation));
                }
                if (validity.isValid()) continue;
                newInstallation.dispose();
                return false;
            }
            for (PreSetInstallation preSetInstallation : this.setInstallationHandlers.getPreSetInstallation()) {
                preSetInstallation.preLoad(this.installation, newInstallation);
            }
            if (this.installation != null) {
                this.installation.dispose();
            }
            this.robotInstallationLookupService.clearErrors(this.installation);
            this.installation = newInstallation;
            for (PostSetInstallation postSetInstallation : this.setInstallationHandlers.getPostSetInstallation()) {
                postSetInstallation.postLoad(this.installation);
            }
            this.fireInstallationLoadedEvent();
            this.fireInstallationChangedEvent();
            return true;
        }
        finally {
            this.installationModified.installationLoaded(this.installation);
            this.isLoadingInstallation = false;
        }
    }

    protected void showErrorMessage(ErrorMessage message) {
        LegacyURDialogCreator.showBlockingErrorDialog(message.getTitle(), HTML.html((String)HTML.maxWidth((int)400, (String)message.getMessage())), message.getSuggestion());
    }

    public Installation getInstallation() {
        return this.installation;
    }

    private String createFailedToLoadMessage() {
        return "Failed to load installation, creating 'default.installation'";
    }

    private String createFailedToBackupMessage() {
        return "Failed to load installation, creating 'default.installation' and backing up old as 'default.installation.problem'";
    }

    public void fireInstallationLoadedEvent() {
        EventNotificationService.notify(InstallationStateListener.class, (NotificationStrategy)new NotificationStrategy<InstallationStateListener>(){

            public void notify(InstallationStateListener listener) {
                listener.installationLoaded(SingleRobotInstallationSite.this.robotInstallationLookupService.getInstallation());
            }
        });
    }

    public void fireInstallationChangedEvent() {
        final InstallationListener.Event event = new InstallationListener.Event(InstallationListener.EventType.CHANGED, this.installation);
        EventNotificationService.notify(InstallationListener.class, (NotificationStrategy)new NotificationStrategy<InstallationListener>(){

            public void notify(InstallationListener installationListener) {
                installationListener.onInstallationEvent(event);
            }
        });
    }

    static class InstallationModified
    extends InstallationStateListener.Template {
        private boolean modified;

        @Inject
        private InstallationModified(EventManager eventManager) {
            eventManager.addStrongListener(InstallationStateListener.class, (Object)this);
        }

        public void installationModified() {
            DashBoard.stopProgram();
            this.modified = true;
        }

        public void installationSaved() {
            this.modified = false;
        }

        public void installationLoaded(Installation installation) {
            this.modified = false;
        }

        public boolean isModified() {
            return this.modified;
        }
    }
}

