/*
 * Decompiled with CFR 0.152.
 */
package gui.main;

import com.ur.lang.featuretoggle.FeatureToggle;
import com.ur.util.logging.Log;
import gui.main.URGUI;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

public class Activator
implements BundleActivator {
    public void start(BundleContext context) {
        FeatureToggle.activateFeature((String)"progress-counter");
        StartPolyScopeThread thread = new StartPolyScopeThread(context);
        FrameworkStartedListener listener = new FrameworkStartedListener(thread);
        context.addFrameworkListener((FrameworkListener)listener);
    }

    public void stop(BundleContext context) {
    }

    private static class FrameworkStartedListener
    implements FrameworkListener {
        private static final List<Integer> START_EVENTS = Arrays.asList(1, 8);
        private final AtomicReference<Thread> startOnce;

        FrameworkStartedListener(Thread startOnce) {
            this.startOnce = new AtomicReference<Thread>(startOnce);
        }

        public void frameworkEvent(FrameworkEvent frameworkEvent) {
            Thread t;
            if (START_EVENTS.contains(frameworkEvent.getType()) && (t = (Thread)this.startOnce.getAndSet(null)) != null) {
                t.start();
            }
        }
    }

    private static class StartPolyScopeThread
    extends Thread {
        private final BundleContext context;

        StartPolyScopeThread(BundleContext context) {
            this.context = context;
        }

        @Override
        public void run() {
            try {
                URGUI.run(this.context, new String[0]);
            }
            catch (Exception e) {
                Log.error((String)"com.ur.polyscope.system.ShutdownServiceUI", (Throwable)e);
            }
        }
    }
}

