/*
 * Decompiled with CFR 0.152.
 */
package gui.main;

import com.ur.injection.Builder;
import com.ur.swing.CardPanel;
import com.ur.swing.flippable.FlippablePanel;
import com.ur.view.help.HelpLoader;
import com.ur.view.help.HelpPanel;
import com.ur.view.polyscope.persistence.installation.InstallationFilePersistence;
import gui.main.CardPanelContribution;
import gui.main.MainView;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class MainPanel
extends FlippablePanel
implements MainView {
    private final Set<CardPanelContribution> contributions;

    @Inject
    MainPanel(Set<CardPanelContribution> contributions, HelpPanel helpPanel) {
        this.contributions = new HashSet<CardPanelContribution>(contributions);
        this.setOpaque(false);
        InstallationFilePersistence.setFlipManager(this);
        this.addCardPanel(helpPanel.getHelpCardPanel());
        HelpLoader.setHelpScreen(helpPanel);
        this.switchTo(helpPanel.getHelpClass());
    }

    @Override
    public CardPanel getCurrentCard() {
        CardPanel cardPanel = super.getCurrentCard();
        if (cardPanel == null) {
            return new CardPanel();
        }
        return cardPanel;
    }

    @Override
    public boolean isAnyCardActive(Iterable<Class<?>> cardPanelTypes) {
        return super.isOneOfCardsActive(cardPanelTypes);
    }

    public void initFlippablePanel(Builder builder) {
        for (CardPanelContribution contribution : this.contributions) {
            for (Class<? extends CardPanel> clazz : contribution.getCardPanelContributions()) {
                this.addCardPanel((CardPanel)builder.get(clazz));
            }
            for (Map.Entry entry : contribution.getMappedContributions().entrySet()) {
                this.addCardPanel((Class)entry.getKey(), (CardPanel)builder.get((Class)entry.getValue()));
            }
        }
    }
}

