/*
 * Decompiled with CFR 0.152.
 */
package gui.main;

import com.ur.lang.persist.WriteableModuleSettings;
import com.ur.polyscope.robot.configuration.robotidentification.ControlBoxType;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentificationProvider;
import com.ur.polyscope.robot.configuration.robotidentification.RobotTypeIdentifier;
import com.ur.polyscope.robot.configuration.tool.ToolConfigurationSettings;
import com.ur.polyscope.system.ShutdownService;
import com.ur.polyscope.viewfacade.safety.InitializeRobotListener;
import com.ur.util.logging.Log;
import com.ur.view.constants.dev.TPType;
import com.ur.view.filescripts.URBashscriptRunner;
import gui.tools.URFileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.inject.Inject;

public class OnInitializeRobotSetup {
    private static final String USER = System.getenv("USER") == null ? "dummy" : System.getenv("USER");
    private static final WriteableModuleSettings initialTPType = new WriteableModuleSettings("oem.properties");
    private static final String INITIAL_TP_TYPE_KEY = "initialTPType";
    private final Set<InitializeRobotListener> listeners;
    private final RobotIdentificationProvider repository;
    private final ShutdownService shutdownService;
    private final ToolConfigurationSettings toolConfigurationSettings;

    @Inject
    public OnInitializeRobotSetup(Set<InitializeRobotListener> listeners, RobotIdentificationProvider repository, ShutdownService shutdownService, ToolConfigurationSettings toolConfigurationSettings) {
        this.listeners = listeners;
        this.repository = repository;
        this.shutdownService = shutdownService;
        this.toolConfigurationSettings = toolConfigurationSettings;
    }

    public void initializeRobot(RobotTypeIdentifier type, ControlBoxType controlBoxType, String serialNumber, boolean euromapEnabled, TPType initialTPType) {
        this.repository.setRobotIdentification(serialNumber, type, controlBoxType);
        this.toolConfigurationSettings.initFieldsToDefaultValues();
        for (InitializeRobotListener each : this.listeners) {
            each.initializeRobot(euromapEnabled);
        }
        URBashscriptRunner.restartControllerInBackground();
        this.setHostNameSW5("ur-" + serialNumber);
        URFileUtils.deleteDefaultInstallationFilesOnExit();
        this.setInitialTPType(initialTPType);
        this.shutdownService.requestRestartGui();
    }

    private void setInitialTPType(TPType defaultTPType) {
        int tpTypeId = -1;
        if (defaultTPType != null) {
            tpTypeId = defaultTPType.getId();
        }
        try {
            initialTPType.properties().setProperty(INITIAL_TP_TYPE_KEY, Integer.toString(tpTypeId));
            initialTPType.write();
        }
        catch (IOException e) {
            Log.error((String)"Failed to save initial teach pendant type", (Throwable)e);
        }
    }

    private void setHostNameSW5(String newHostname) {
        try {
            if (this.isOnRobot()) {
                URFileUtils.writeFile(new File("/etc", "hostname"), newHostname);
            }
        }
        catch (IOException e) {
            Log.error((String)"Failed to write file", (Throwable)e);
        }
    }

    private boolean isOnRobot() {
        return "kiosk".equals(USER) || "root".equals(USER);
    }
}

