/*
 * Decompiled with CFR 0.152.
 */
package gui.main;

import com.ur.i18n.TextResource;
import com.ur.polyscope.filemanager.FileContainer;
import com.ur.polyscope.filemanager.FileManagerConfiguration;
import com.ur.polyscope.filemanager.FilePersistence;
import com.ur.resources.ViewImageResource;
import com.ur.swing.ActionDefinition;
import com.ur.swing.CardPanel;
import com.ur.swing.TableUtils;
import com.ur.swing.URFingerDragScrollMouseListener;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.dialog.AggregateDialogCreator;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.text.KeyboardPanel;
import com.ur.util.logging.Log;
import com.ur.util.persist.FileUtils;
import com.ur.util.swing.HTML;
import com.ur.view.filechooser.ScriptFileManagerConfiguration;
import com.ur.view.filechooser.SystemFileManagerConfiguration;
import gui.main.SelectFileContext;
import gui.tools.LanguagePack;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;

public class OnScreenFileEditor
extends CardPanel {
    private FileContainer textFileContainer;
    private SelectFileContext context = SelectFileContext.Script;
    private JButton save;
    private JTextPane scriptEditor;
    private JTextPane lineNumbers;
    private boolean hasUnsavedChanges = false;
    private final FilePersistence filePersistence;
    private final TextResource textResource;
    private final URFontFactory fontFactory;
    private final WidgetFactory factory;
    private final AggregateDialogCreator dialogCreator;
    private FileContainer backupFileContainer = new FileContainer();

    @Inject
    OnScreenFileEditor(FilePersistence filePersistence, ViewContext viewContext) {
        this.filePersistence = filePersistence;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.fontFactory = viewContext.getFontFactory();
        this.factory = viewContext.createWidgetFactory();
        this.dialogCreator = viewContext.getDialogCreator();
        this.initComponents();
        new URFingerDragScrollMouseListener((Component)this.scriptEditor);
        new URFingerDragScrollMouseListener((Component)this.lineNumbers);
        this.backupFileContainer.setAction(FileContainer.Action.Cancel);
    }

    public void enter(Object object) {
        if (object instanceof FileContainer) {
            this.textFileContainer = (FileContainer)object;
            this.context = SelectFileContext.Script;
        } else if (object instanceof SelectFileContext) {
            this.textFileContainer = new FileContainer();
            this.textFileContainer.setAction(FileContainer.Action.New);
            this.context = (SelectFileContext)((Object)object);
        }
        if (this.textFileContainer == null) {
            this.textFileContainer = new FileContainer();
            this.textFileContainer.setAction(FileContainer.Action.New);
            this.context = SelectFileContext.Configuration;
        }
        if (this.textFileContainer.getAction() == FileContainer.Action.New) {
            this.scriptEditor.setText("");
        }
        if (this.textFileContainer.getFile() != null) {
            this.performRequestedActionOnFile();
        } else if (!this.isLastActionCancel()) {
            this.save.setEnabled(false);
        }
        if (this.isLastActionCancel()) {
            this.restoreFileContainer();
        } else {
            this.backupFileContainer();
        }
        this.scriptEditor.requestFocus();
    }

    private boolean isLastActionCancel() {
        return this.textFileContainer.getAction() == FileContainer.Action.Cancel;
    }

    private void backupFileContainer() {
        this.backupFileContainer.setAction(this.textFileContainer.getAction());
        this.backupFileContainer.setFile(this.textFileContainer.getFile());
    }

    private void restoreFileContainer() {
        this.textFileContainer.setAction(this.backupFileContainer.getAction());
        this.textFileContainer.setFile(this.backupFileContainer.getFile());
    }

    private void performRequestedActionOnFile() {
        File file = this.textFileContainer.getFile();
        if (this.textFileContainer.getAction() == FileContainer.Action.SaveAs) {
            if (this.context.equals((Object)SelectFileContext.Script)) {
                this.saveScriptContentAsScriptFile(file);
            } else {
                this.saveScriptContentAsFile(file);
            }
        } else if (this.textFileContainer.getAction() != FileContainer.Action.Cancel) {
            String text = FileUtils.readFromFile((File)file, (String)"");
            this.scriptEditor.setText(text);
            this.updateUnsavedState(false);
        }
    }

    private void saveScriptContentAsFile(File file) {
        try {
            FileUtils.writeToFile((String)this.scriptEditor.getText(), (File)file);
            this.updateUnsavedState(false);
        }
        catch (Exception exception) {
            this.dialogCreator.showErrorDialog(LanguagePack.getErrorMessages().unableToSaveScriptFile(file.getName()), null);
            this.textFileContainer.setFile(null);
        }
    }

    private void saveScriptContentAsScriptFile(File file) {
        try {
            String scriptText = this.scriptEditor.getText();
            if (file.getName().endsWith(".script")) {
                FileUtils.writeToFile((String)scriptText, (File)file);
            } else {
                File fileWithExtension = new File(String.valueOf(file.getAbsolutePath()) + ".script");
                this.textFileContainer.setFile(fileWithExtension);
                FileUtils.writeToFile((String)scriptText, (File)fileWithExtension);
            }
            this.updateUnsavedState(false);
        }
        catch (Exception exception) {
            this.dialogCreator.showErrorDialog(LanguagePack.getErrorMessages().unableToSaveScriptFile(file.getName()), null);
            this.textFileContainer.setFile(null);
        }
    }

    private void initComponents() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        this.lineNumbers = new JTextPane();
        this.lineNumbers.setText("1");
        this.lineNumbers.setBackground(TableUtils.EVEN_ROW_COLOR);
        this.lineNumbers.setForeground(Color.GRAY);
        this.lineNumbers.setEditable(false);
        this.lineNumbers.setSelectionColor(this.lineNumbers.getBackground());
        this.lineNumbers.setSelectedTextColor(this.lineNumbers.getForeground());
        this.scriptEditor = new JTextPane();
        this.scriptEditor.setDocument(new DefaultStyledDocument());
        this.scriptEditor.getDocument().addDocumentListener(new HasChangesListener());
        this.scriptEditor.getDocument().addDocumentListener(new LineNumberListener(this.lineNumbers, this.scriptEditor));
        this.scriptEditor.setEditable(true);
        this.setName("WelcomeScreen");
        this.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.scriptEditor);
        scrollPane.setRowHeaderView(this.lineNumbers);
        JPanel toolbar = new JPanel();
        JLabel screenTitle = new JLabel();
        screenTitle.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.MAIN_HEADING_SIZE));
        screenTitle.setText(this.textResource.fileEditor());
        JButton selectFile = this.createButton(new OpenFileAction(this.textResource));
        JButton deleteLine = this.createButton(new DeleteCurrentLine(this.scriptEditor, this.textResource));
        JButton insertLine = this.createButton(new AddLineBelow(this.scriptEditor, this.textResource));
        this.save = this.createButton(new SaveAction(this.scriptEditor, this.textResource));
        this.save.setEnabled(false);
        JButton saveAs = this.createButton(new SaveAsAction(this.textResource));
        JButton exitButton = this.createButton(new NavigateBackAction(this.textResource));
        toolbar.setLayout(new FlowLayout(0));
        toolbar.add(selectFile);
        toolbar.add(this.save);
        toolbar.add(saveAs);
        toolbar.add(new JLabel(ViewImageResource.blank()));
        toolbar.add(deleteLine);
        toolbar.add(insertLine);
        toolbar.add(new JLabel(ViewImageResource.blank()));
        toolbar.add(exitButton);
        toolbar.add(new JLabel(ViewImageResource.blank()));
        toolbar.add(screenTitle);
        this.add(toolbar, "North");
        this.add(scrollPane, "Center");
        this.add(new JPanel(){
            {
                this.add((Component)new KeyboardPanel(OnScreenFileEditor.this.scriptEditor){
                    {
                        this.setBorder(BorderFactory.createEmptyBorder());
                    }
                });
                this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
                this.setBorder(BorderFactory.createMatteBorder(0, 120, 0, 120, G5LookAndFeel.BETWEEN_CARD_COLOR));
            }
        }, "South");
    }

    private JButton createButton(AbstractAction action) {
        JButton result = this.factory.createButton((Action)action);
        result.setBorder(new LineBorder(G5LookAndFeel.SELECTED_HEADER_BACKGROUND, 2));
        result.setPreferredSize(new Dimension(105, 55));
        result.setFont(this.fontFactory.getRelativeFont(URFontFactory.Size.TINY));
        return result;
    }

    private void updateUnsavedState(boolean unsavedChanges) {
        this.hasUnsavedChanges = unsavedChanges;
        this.save.setEnabled(this.hasUnsavedChanges && this.textFileContainer.hasFile());
    }

    private static final class AddLineBelow
    extends TextAction {
        private final AbstractAction moveToEndOfTheLine;
        private final JTextPane scriptEditor;

        public AddLineBelow(JTextPane scriptEditor, TextResource textResource) {
            super(textResource.Insert());
            this.scriptEditor = scriptEditor;
            this.putValue("SmallIcon", ViewImageResource.addLine());
            this.putValue("Function", ActionDefinition.Function.TOOLBAR_VIEW_HEADER);
            this.putValue("Name", HTML.html((String)textResource.Insert()));
            this.moveToEndOfTheLine = (AbstractAction)scriptEditor.getActionMap().get("caret-end-line");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.moveToEndOfTheLine.actionPerformed(e);
            int position = this.scriptEditor.getCaretPosition();
            try {
                this.scriptEditor.getDocument().insertString(position, "\n", null);
            }
            catch (BadLocationException e1) {
                Log.error((String)"Failed to insert new line", (Throwable)e1);
            }
            this.scriptEditor.requestFocus();
        }
    }

    private static final class DeleteCurrentLine
    extends TextAction {
        private final AbstractAction selectLine;
        private final AbstractAction deleteSelection;
        private final AbstractAction deleteNextNewLineChar;
        private final JTextPane scriptEditor;
        private final AbstractAction deletePrevNewLineChar;

        public DeleteCurrentLine(JTextPane scriptEditor, TextResource textResource) {
            super(HTML.html((String)textResource.Delete()));
            this.scriptEditor = scriptEditor;
            this.putValue("SmallIcon", ViewImageResource.deleteLine());
            this.putValue("Function", ActionDefinition.Function.TOOLBAR_VIEW_HEADER);
            this.selectLine = (AbstractAction)scriptEditor.getActionMap().get("select-line");
            this.deleteSelection = (AbstractAction)scriptEditor.getActionMap().get("cut-to-clipboard");
            this.deleteNextNewLineChar = (AbstractAction)scriptEditor.getActionMap().get("delete-next");
            this.deletePrevNewLineChar = (AbstractAction)scriptEditor.getActionMap().get("delete-previous");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.selectLine.actionPerformed(e);
            this.deleteSelection.actionPerformed(e);
            if (this.hasNewLineCharAfterCaret()) {
                this.deleteNextNewLineChar.actionPerformed(e);
            } else {
                this.deletePrevNewLineChar.actionPerformed(e);
            }
            this.scriptEditor.requestFocus();
        }

        private boolean hasNewLineCharAfterCaret() {
            Document doc = this.scriptEditor.getDocument();
            Caret caret = this.scriptEditor.getCaret();
            int dot = caret.getDot();
            return dot < doc.getLength();
        }
    }

    public class HasChangesListener
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent e) {
            OnScreenFileEditor.this.updateUnsavedState(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            OnScreenFileEditor.this.updateUnsavedState(true);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            OnScreenFileEditor.this.updateUnsavedState(true);
        }
    }

    private static final class LineNumberListener
    implements DocumentListener {
        private final JTextComponent editor;
        private final JTextComponent lines;

        public LineNumberListener(JTextComponent lines, JTextComponent editor) {
            this.lines = lines;
            this.editor = editor;
        }

        public String getText() {
            int caretPosition = this.editor.getDocument().getLength();
            Element root = this.editor.getDocument().getDefaultRootElement();
            String text = "1" + System.getProperty("line.separator");
            int i = 2;
            while (i < root.getElementIndex(caretPosition) + 2) {
                text = String.valueOf(text) + i + System.getProperty("line.separator");
                ++i;
            }
            return text;
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
            this.lines.setText(this.getText());
        }

        @Override
        public void insertUpdate(DocumentEvent de) {
            this.lines.setText(this.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            this.lines.setText(this.getText());
        }
    }

    private final class NavigateBackAction
    extends AbstractAction {
        private TextResource resource;

        public NavigateBackAction(TextResource resource) {
            this.resource = resource;
            this.putValue("Name", HTML.html((String)resource.Exit()));
            this.putValue("SmallIcon", ViewImageResource.applicationExit());
            this.putValue("Function", ActionDefinition.Function.TOOLBAR_VIEW_HEADER);
        }

        private ConfirmationMessage confirmUnsavedChanges() {
            return new ConfirmationMessage(this.resource.confirmUnsavedChangesTitle(), this.resource.confirmUnsavedChangesExplanation(), this.resource.confirmUnsavedChangesAction(), this.resource.Cancel());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!OnScreenFileEditor.this.hasUnsavedChanges) {
                this.exit();
                return;
            }
            ConfirmationDialogListener listener = new ConfirmationDialogListener(){

                public void onOkClicked() {
                    NavigateBackAction.this.exit();
                }
            };
            OnScreenFileEditor.this.dialogCreator.showConfirmationDialog(this.confirmUnsavedChanges(), listener);
        }

        private void exit() {
            OnScreenFileEditor.this.navigateBack();
            OnScreenFileEditor.this.textFileContainer = null;
        }
    }

    private final class OpenFileAction
    extends AbstractAction {
        public OpenFileAction(TextResource resource) {
            this.putValue("SmallIcon", ViewImageResource.folder());
            this.putValue("Name", HTML.html((String)resource.Open()));
            this.putValue("Function", ActionDefinition.Function.TOOLBAR_VIEW_HEADER);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OnScreenFileEditor.this.textFileContainer.setAction(FileContainer.Action.Open);
            switch (OnScreenFileEditor.this.context) {
                case Script: {
                    OnScreenFileEditor.this.filePersistence.openFile(OnScreenFileEditor.this.textFileContainer, (FileManagerConfiguration)new ScriptFileManagerConfiguration(OnScreenFileEditor.this.textResource.loadScriptFile()));
                    break;
                }
                case Configuration: {
                    OnScreenFileEditor.this.filePersistence.openFile(OnScreenFileEditor.this.textFileContainer, (FileManagerConfiguration)new SystemFileManagerConfiguration(OnScreenFileEditor.this.textResource.loadConfigurationFile()));
                }
            }
        }
    }

    private final class SaveAction
    extends AbstractAction {
        private final JTextPane textPane;

        public SaveAction(JTextPane textPane, TextResource resource) {
            this.textPane = textPane;
            this.putValue("Name", HTML.html((String)resource.Save()));
            this.putValue("SmallIcon", ViewImageResource.gtkSave());
            this.putValue("Function", ActionDefinition.Function.TOOLBAR_VIEW_HEADER);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OnScreenFileEditor.this.textFileContainer.setAction(FileContainer.Action.SaveAs);
            if (OnScreenFileEditor.this.textFileContainer.hasFile()) {
                FileUtils.writeToFile((String)this.textPane.getText(), (File)OnScreenFileEditor.this.textFileContainer.getFile());
                OnScreenFileEditor.this.updateUnsavedState(false);
            }
            this.textPane.requestFocus();
        }
    }

    private final class SaveAsAction
    extends AbstractAction {
        public SaveAsAction(TextResource resource) {
            this.putValue("Name", HTML.html((String)resource.saveAs()));
            this.putValue("SmallIcon", ViewImageResource.gtkSaveAs());
            this.putValue("Function", ActionDefinition.Function.TOOLBAR_VIEW_HEADER);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OnScreenFileEditor.this.textFileContainer.setAction(FileContainer.Action.SaveAs);
            switch (OnScreenFileEditor.this.context) {
                case Script: {
                    OnScreenFileEditor.this.filePersistence.saveFile(OnScreenFileEditor.this.textFileContainer, (FileManagerConfiguration)new ScriptFileManagerConfiguration(OnScreenFileEditor.this.textResource.saveScriptFile()));
                    break;
                }
                case Configuration: {
                    OnScreenFileEditor.this.filePersistence.saveFile(OnScreenFileEditor.this.textFileContainer, (FileManagerConfiguration)new SystemFileManagerConfiguration(OnScreenFileEditor.this.textResource.saveConfigurationFile()));
                }
            }
        }
    }
}

