/*
 * Decompiled with CFR 0.152.
 */
package gui.main;

import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.swing.CardPanel;
import com.ur.swing.FlipManager;
import com.ur.util.event.EventNotificationService;
import com.ur.util.swing.HTML;
import com.ur.view.constants.dev.SafetyMode;
import gui.tools.LanguagePack;
import javax.inject.Inject;
import javax.swing.JLabel;

public class RecoveryMovePanel
extends CardPanel {
    public static final String RECOVERY_MODE = HTML.fontColor((String)"RED", (String)LanguagePack.getTextResource().recoveryMode());
    public static final String NORMAL_MODE = HTML.fontColor((String)"GREEN", (String)LanguagePack.getTextResource().safetyModeNormal());
    public static final String REDUCED_MODE = HTML.fontColor((String)"GREEN", (String)LanguagePack.getTextResource().safetyModeReduced());
    private final JLabel label;

    @Inject
    RecoveryMovePanel() {
        this.setFlipManager((FlipManager)new FlipManager.DummyFlipManager());
        this.label = new JLabel();
        this.add(this.label);
        EventNotificationService.register((Object)((Object)this), RobotStateListener.class, (Object)new UpdateLabelOnSafetyModeChange());
    }

    private void setTextOnLabel(String text) {
        this.label.setText(HTML.html((String)HTML.h2((String)text)));
    }

    String getTextOnLabel() {
        return this.label.getText();
    }

    void unregisterListeners() {
        EventNotificationService.unregister((Object)((Object)this), RobotStateListener.class);
    }

    private final class UpdateLabelOnSafetyModeChange
    implements RobotStateListener {
        SafetyMode currentState = null;

        private UpdateLabelOnSafetyModeChange() {
        }

        public void updateRobotState(RobotState robotState) {
            if (robotState.masterSafetyState != this.currentState) {
                switch (robotState.masterSafetyState) {
                    case RECOVERY: {
                        RecoveryMovePanel.this.setTextOnLabel(RECOVERY_MODE);
                        break;
                    }
                    case NORMAL: {
                        RecoveryMovePanel.this.setTextOnLabel(NORMAL_MODE);
                        break;
                    }
                    case REDUCED: {
                        RecoveryMovePanel.this.setTextOnLabel(REDUCED_MODE);
                    }
                }
                this.currentState = robotState.masterSafetyState;
            }
        }
    }
}

