/*
 * Decompiled with CFR 0.152.
 */
package gui.main;

import com.ur.i18n.TextResource;
import com.ur.injection.Binder;
import com.ur.injection.Builder;
import com.ur.injection.InjectionFactory;
import com.ur.injection.ServicesBinder;
import com.ur.lang.naming.NamingStrategy;
import com.ur.lang.react.Broadcaster;
import com.ur.lang.react.Consumer;
import com.ur.monitor.RobotStateListener;
import com.ur.move.internal.ControllerTeachButton;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.controllerinterface.ControllerServiceManager;
import com.ur.polyscope.installation.InstallationListener;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.platform.api.PlatformEnvironment;
import com.ur.polyscope.platform.api.PlatformType;
import com.ur.polyscope.robot.configuration.RobotBundleRemover;
import com.ur.polyscope.security.Privileges;
import com.ur.polyscope.viewfacade.monitor.SafetyModeChangeService;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.resources.ViewImageResource;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.FontFactory;
import com.ur.swing.ScreenUtils;
import com.ur.swing.Skin;
import com.ur.swing.SwingUtil;
import com.ur.swing.URFontFactory;
import com.ur.swing.extensible.ContributeExtensionPoints;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.Waiting;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.util.event.Subscription;
import com.ur.util.logging.Log;
import com.ur.util.logging.LogTime;
import com.ur.util.persist.FileUtils;
import com.ur.view.filescripts.URBashscriptRunner;
import com.ur.view.gui.impl.GuiServiceBinder;
import com.ur.view.help.HelpLoader;
import com.ur.view.modbus.ModbusServiceBinder;
import com.ur.view.polyscope.ServiceBinderImpl;
import com.ur.view.polyscope.module.ContributionBinding;
import com.ur.view.polyscope.program.ProgramCorrectionService;
import com.ur.view.variables.VariableServiceBinder;
import gui.controllerinterface.ControllerInterfaceBinding;
import gui.debug.CaptureUnhandledExceptions;
import gui.debug.RenderingErrorListener;
import gui.geom.FeatureServiceBinder;
import gui.geom.GeomFeatureNamingStrategy;
import gui.installation.InstallationServiceBinding;
import gui.installation.naming.NamingBindingService;
import gui.installation.naming.SubProgramNamingStrategy;
import gui.installation.services.LookupServiceFacade;
import gui.main.CardPanelContribution;
import gui.main.ExtensibleMainPanel;
import gui.main.OnStartup;
import gui.main.PlaceholderCardPanelContribution;
import gui.main.PolyScopeStateListener;
import gui.main.URGUIContext;
import gui.main.UniversalRobotsTheme;
import gui.polyscope.DashBoard;
import gui.program.PlaceholderNode;
import gui.program.ProgramMetaDataComponent;
import gui.program.ProgramRootNode;
import gui.program.services.ProgramServiceBinding;
import gui.program.services.ProgramStateService;
import gui.program.validation.ValidationStrategyProviderServiceBinder;
import gui.program.validation.ValidatorsServiceBinder;
import gui.tools.LanguagePack;
import gui.tools.LegacyURDialogCreator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.media.j3d.VirtualUniverse;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.osgi.framework.BundleContext;

@Singleton
public class URGUI
extends JFrame {
    public static final String URGUI_FRAME = "urgui.URGUI";
    private static final Broadcaster<Boolean> onFrameShown;
    private static Builder builder;
    private static URGUIContext myContext;
    private static boolean initialized;
    private static boolean requestFocus;
    private static List<ServicesBinder> hardCodedServices;
    private static TextResource textResource;
    private final Set<OnStartup> onStartup;

    static {
        myContext = new URGUIContext();
        initialized = false;
        requestFocus = false;
        textResource = LanguagePack.getTextResource();
        onFrameShown = new Broadcaster();
    }

    @Inject
    URGUI(Builder builder, Set<OnStartup> onStartup) {
        DisplayMessageFactory.setCurrentWindow((JFrame)this);
        this.onStartup = new HashSet<OnStartup>(onStartup);
        URGUI.builder = builder;
        this.setDefaultCloseOperation(3);
        this.setTitle(textResource.guiMainWindowTitle());
        try {
            this.setIconImage(ImageIO.read(ViewImageResource.asResource(ViewImageResource.urIcon())));
        }
        catch (IOException iOException) {}
        HelpLoader.setVersionSite();
        HelpLoader.setOverlaidHelpPainFor(this);
        VirtualUniverse.addRenderingErrorListener((javax.media.j3d.RenderingErrorListener)new RenderingErrorListener());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                ScreenUtils.setUrGuiCenteredOnScreen((boolean)ScreenUtils.urGuiToBeCenterOnScreen());
            }

            @Override
            public void componentShown(ComponentEvent e) {
                onFrameShown.next((Object)true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                onFrameShown.next((Object)false);
                onFrameShown.completed();
            }
        });
    }

    public static Subscription onFrameShown(Consumer<Boolean> observer) {
        Subscription subscription = onFrameShown.subscribe(observer);
        URGUI urgui = (URGUI)builder.get(URGUI.class);
        observer.accept((Object)(urgui != null && urgui.isVisible() ? 1 : 0));
        return subscription;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static boolean isRequestingFocus() {
        return requestFocus;
    }

    public static void setVisibleAndRequestFocus() {
        final URGUI urgui = (URGUI)builder.get(URGUI.class);
        SwingUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                urgui.setVisible(true);
                urgui.requestFocus();
                myContext.raiseOnInitFinished();
                URGUI.fireInstallationInitializedEvent();
                URGUI.fireInstallationReadyEvent();
            }
        });
    }

    public static void main(String ... args) {
        URGUI.run(null, args);
    }

    public static void run(BundleContext context, String ... args) {
        myContext.setContext(context);
        URGUI.verifyDefaultCharsetEncodingForJVM(FileUtils.UTF_8);
        Log.info((String)"Starting Universal Robots GUI");
        Builder builder = URGUI.bindServices(context);
        URGUI.bindListeners(builder);
        URGUI.fireOnInitEvent();
        URGUI.loadServices(builder);
        RobotBundleRemover helpRemover = (RobotBundleRemover)builder.get(RobotBundleRemover.class);
        URGUI.removeHelpFilesWhenNotInURSIM(context, helpRemover);
        myContext.raiseOnInitBegin();
        Waiting.pause((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        boolean isUndecorated = false;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.equals("--undecorated")) {
                isUndecorated = true;
            }
            ++n2;
        }
        String antialising = "swing.aatext";
        System.setProperty(antialising, "true");
        URGUI.runInitThreads(builder, isUndecorated);
    }

    private static void removeHelpFilesWhenNotInURSIM(BundleContext context, RobotBundleRemover helpRemover) {
        if (PlatformEnvironment.getPlatFormType() != PlatformType.URSIM) {
            helpRemover.deleteIrrelevantHelp(context);
        }
    }

    private static List<ServicesBinder> createHardcodededServices() {
        if (hardCodedServices == null) {
            hardCodedServices = Arrays.asList(new LanguagePack(), new ControllerInterfaceBinding(), new com.ur.view.program.execution.ServiceBinderImpl(), new LookupServiceFacade(), new ProgramServiceBinding(), new com.ur.view.program.execution.ServiceBinderImpl(), new com.ur.view.polyscope.module.ServiceBinderImpl(), new InstallationServiceBinding(), new FeatureServiceBinder(), new ControllerInterfaceBinding(), new GuiServiceBinder(), new ModbusServiceBinder(), new NamingBindingService(), new com.ur.view.domain.ServiceBinderImpl(), new com.ur.view.impl.ServiceBinderImpl(), new ServiceBinderImpl(), new VariableServiceBinder(), new ValidatorsServiceBinder(), new ValidationStrategyProviderServiceBinder());
        }
        return new ArrayList<ServicesBinder>(hardCodedServices);
    }

    private static void verifyDefaultCharsetEncodingForJVM(Charset charsetEncoding) {
        Charset defaultCharset = Charset.defaultCharset();
        if (defaultCharset.equals(charsetEncoding)) {
            Log.debug((String)("Default charset encoding is " + charsetEncoding));
        } else {
            Log.warning((String)("Default charset encoding is not " + charsetEncoding + " it's " + defaultCharset));
        }
    }

    private static void loadLookAndFeel(LookAndFeel defaultLookAndFeel, Builder builder) {
        LookAndFeel look = null;
        Skin s = URGUI.getSkin(builder);
        if (s != null) {
            look = s.getLookAndFeel();
        }
        if (look != null) {
            URGUI.tryLoadLookAndFeel(look);
        } else {
            URGUI.tryLoadLookAndFeel(defaultLookAndFeel);
        }
    }

    private static Skin getSkin(Builder builder) {
        try {
            return (Skin)builder.get(Skin.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean tryLoadLookAndFeel(LookAndFeel lookAndFeel) {
        try {
            UIManager.setLookAndFeel(lookAndFeel);
            return true;
        }
        catch (Exception x) {
            Log.error((String)("Error loading look and feel extension: " + x));
            return false;
        }
    }

    public static Builder bindServices(BundleContext context) {
        InjectionFactory.ModuleAggregator aggregator = InjectionFactory.createModuleAggregator();
        return URGUI.bindServices(aggregator, context);
    }

    public static Builder bindServices(InjectionFactory.ModuleAggregator aggregator, BundleContext context) {
        for (ServicesBinder serviceBinder : URGUI.createHardcodededServices()) {
            aggregator.add(serviceBinder);
        }
        for (ServicesBinder each : myContext.getServiceBinders()) {
            aggregator.add(each);
        }
        aggregator.add(new ServicesBinder(){

            public void bind(Binder binder) {
                binder.bindClass(ProgramStateService.class, ProgramStateService.DashboardWrapper.class);
                binder.bindToExtensionPoint(NamingStrategy.class, GeomFeatureNamingStrategy.class);
                binder.bindToExtensionPoint(NamingStrategy.class, SubProgramNamingStrategy.class);
                binder.bindClassIfAbsent(URFontFactory.class, FontFactory.class);
                binder.bindToExtensionPoint(CardPanelContribution.class, PlaceholderCardPanelContribution.class);
                binder.bindClassIfAbsent(ProgramCorrectionService.class, ProgramCorrectionService.DummyProgramCorrectionService.class);
                binder.requestStaticBinding(DashBoard.class);
            }

            public void load(Builder builder) {
            }
        });
        Builder builder = aggregator.createBuilder();
        URGUI.loadLookAndFeel(URGUI.getDefaultLookAndFeel((URFontFactory)builder.get(URFontFactory.class)), builder);
        LookupServiceFacade.setBuilder(builder);
        ContributionBinding.registerContributions(builder, context);
        if (context != null) {
            context.registerService(Builder.class, (Object)builder, null);
        }
        return builder;
    }

    public static void forTestingRemoveInterceptors() {
        ProgramServiceBinding.forTestingRemoveInterceptors();
    }

    private static void loadServices(Builder builder) {
        ProgramServiceBinding.registerReferenceStrategies(builder);
        ProgramServiceBinding.registerListeners(builder);
        RobotInstallationSite installationSite = (RobotInstallationSite)builder.get(RobotInstallationSite.class);
        installationSite.loadDefaultInstallation();
        ControllerServiceManager controllerServiceManager = (ControllerServiceManager)builder.get(ControllerServiceManager.class);
        URBashscriptRunner.setControllerServiceManager(controllerServiceManager);
        URBashscriptRunner.restartControllerInBackground();
    }

    private static void bindListeners(Builder builder) {
        EventNotificationService.register(null, ProgramEventListener.class, (Object)((ProgramEventListener)builder.get(ProgramIsOlderThanVersion3.class)));
        EventNotificationService.register(null, RobotStateListener.class, (Object)((RobotStateListener)builder.get(SafetyModeChangeService.class)));
        builder.get(CaptureUnhandledExceptions.class);
    }

    private static LookAndFeel getDefaultLookAndFeel(URFontFactory fontFactory) {
        UniversalRobotsTheme theme = new UniversalRobotsTheme();
        MetalLookAndFeel.setCurrentTheme(theme);
        return new G5LookAndFeel(fontFactory);
    }

    private static void runInitThreads(final Builder builder, final boolean isUndecorated) {
        block7: {
            LogTime.startLog((String)"GUI startup time");
            final URGUI urgui = (URGUI)builder.get(URGUI.class);
            try {
                try {
                    BlockingTaskRunner.runTask(new Runnable(){

                        @Override
                        public void run() {
                            urgui.setName(URGUI.URGUI_FRAME);
                            urgui.setUndecorated(isUndecorated);
                            for (ServicesBinder serviceBinder : URGUI.createHardcodededServices()) {
                                serviceBinder.load(builder);
                            }
                            URGUI.fireOnReadyEvent();
                        }
                    });
                    BlockingTaskRunner.runTask(new Runnable(){

                        @Override
                        public void run() {
                            for (ServicesBinder each : myContext.getServiceBinders()) {
                                each.load(builder);
                            }
                        }
                    });
                    BlockingTaskRunner.runTask(new Runnable(){

                        @Override
                        public void run() {
                            ContributeExtensionPoints.loadExtensions((Builder)builder);
                            Skin skin = URGUI.getSkin(builder);
                            if (skin != null) {
                                Dimension screenSize = skin.getResolution();
                                urgui.getContentPane().setMinimumSize(screenSize);
                                urgui.getContentPane().setPreferredSize(screenSize);
                                urgui.getContentPane().setMaximumSize(screenSize);
                            }
                            urgui.validate();
                            urgui.pack();
                            urgui.setLocationRelativeTo(null);
                            urgui.addComponentListener(new ComponentAdapter(){

                                @Override
                                public void componentResized(ComponentEvent e) {
                                    Dimension dimensions = urgui.getSize();
                                    Dimension minimumDimensions = urgui.getMinimumSize();
                                    dimensions.width = Math.min(dimensions.width, minimumDimensions.width);
                                    dimensions.height = Math.min(dimensions.height, minimumDimensions.height);
                                    urgui.setSize(dimensions);
                                }
                            });
                        }
                    });
                    initialized = true;
                    try {
                        ControllerInterface controllerInterface = (ControllerInterface)builder.get(ControllerInterface.class);
                        ControllerTeachButton.initTeachButton((Privileges)((Privileges)builder.get(Privileges.class)), (ControllerInterface)controllerInterface);
                    }
                    catch (Exception e) {
                        Log.error((String)"Exception caught when calling ControllerSocket.startConnectionThread()", (Throwable)e);
                    }
                    urgui.addMainPanelToContentPane(builder);
                    requestFocus = true;
                }
                catch (Exception e) {
                    Log.error((String)"Crashed while loading", (Throwable)e);
                    myContext.raiseOnInitCrashed(e);
                    LogTime.stopLog((String)"GUI startup time");
                    break block7;
                }
            }
            catch (Throwable throwable) {
                LogTime.stopLog((String)"GUI startup time");
                throw throwable;
            }
            LogTime.stopLog((String)"GUI startup time");
        }
        Runtime.getRuntime().gc();
    }

    private void addMainPanelToContentPane(Builder builder) {
        ExtensibleMainPanel extensibleMainPanel = (ExtensibleMainPanel)((Object)builder.get(ExtensibleMainPanel.class));
        extensibleMainPanel.getPanel().initFlippablePanel(builder);
        this.getContentPane().add((Component)((Object)extensibleMainPanel));
        for (OnStartup each : this.onStartup) {
            each.run();
        }
    }

    private static void fireOnInitEvent() {
        EventNotificationService.notify(PolyScopeStateListener.class, (NotificationStrategy)new NotificationStrategy<PolyScopeStateListener>(){

            public void notify(PolyScopeStateListener polyScopeStateListener) {
                polyScopeStateListener.onInit();
            }
        });
    }

    private static void fireOnReadyEvent() {
        EventNotificationService.notify(PolyScopeStateListener.class, (NotificationStrategy)new NotificationStrategy<PolyScopeStateListener>(){

            public void notify(PolyScopeStateListener polyScopeStateListener) {
                polyScopeStateListener.onReady();
            }
        });
    }

    public static void fireInstallationInitializedEvent() {
        final InstallationListener.Event event = new InstallationListener.Event(InstallationListener.EventType.CHANGED, null);
        EventNotificationService.notify(InstallationListener.class, (NotificationStrategy)new NotificationStrategy<InstallationListener>(){

            public void notify(InstallationListener installationListener) {
                installationListener.onInstallationEvent(event);
            }
        });
    }

    public static void fireInstallationReadyEvent() {
        final InstallationListener.Event event = new InstallationListener.Event(InstallationListener.EventType.INSTALLATION_READY, null);
        EventNotificationService.notify(InstallationListener.class, (NotificationStrategy)new NotificationStrategy<InstallationListener>(){

            public void notify(InstallationListener installationListener) {
                installationListener.onInstallationEvent(event);
            }
        });
    }

    private static class BlockingTaskRunner {
        private BlockingTaskRunner() {
        }

        public static void runTask(final Runnable task) throws Exception {
            Callable<Exception> task1 = new Callable<Exception>(){

                @Override
                public Exception call() {
                    try {
                        task.run();
                    }
                    catch (Exception e) {
                        return e;
                    }
                    return null;
                }
            };
            Exception exception = (Exception)SwingUtil.invokeAndWaitForAnswer((Callable)task1);
            if (exception != null) {
                throw exception;
            }
        }
    }

    private static final class ProgramIsOlderThanVersion3
    extends ProgramEventListener.Template {
        private ProgramIsOlderThanVersion3() {
        }

        public void onPostNewProgram() {
            ProgramRootNode program = DashBoard.getProgram();
            if (this.isValidProgram(program) && !this.isProgramWithInternalVersion(program) && this.isVersionLessThan3(program) && !DashBoard.autoLoadingNoPopups) {
                LegacyURDialogCreator.showMessageDialog(textResource.programMayNotBehaveDoToPre30VersionTitle(), textResource.programMayNotBehaveDoToPre30VersionExplanation(), "");
            }
        }

        private boolean isVersionLessThan3(ProgramRootNode program) {
            return program != null && program.getComponent(ProgramMetaDataComponent.class).getCreatedInVersion().getMajorVersion() < 3;
        }

        private boolean isProgramWithInternalVersion(ProgramRootNode program) {
            ProgramMetaDataComponent programMetaDataComponent = program.getComponent(ProgramMetaDataComponent.class);
            return programMetaDataComponent != null && programMetaDataComponent.getCreatedInPolyscopeProgramVersion() > 0 && programMetaDataComponent.getLastSavedInPolyscopeProgramVersion() > 0;
        }

        private boolean isValidProgram(ProgramRootNode program) {
            return program != null && program.getMainProgram() != null && !(program.getMainProgram().getChildAt(0) instanceof PlaceholderNode);
        }
    }
}

