/*
 * Decompiled with CFR 0.152.
 */
package gui.main;

import com.ur.injection.ServicesBinder;
import com.ur.polyscope.platform.api.PolyScopeInitializationObserverService;
import com.ur.util.logging.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ServiceLoader;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

class URGUIContext {
    private BundleContext context;

    URGUIContext() {
    }

    void setContext(BundleContext context) {
        this.context = context;
    }

    void raiseOnInitFinished() {
        if (this.context != null) {
            try {
                for (ServiceReference ref : this.context.getServiceReferences(PolyScopeInitializationObserverService.class, null)) {
                    PolyScopeInitializationObserverService service = (PolyScopeInitializationObserverService)this.context.getService(ref);
                    service.onInitFinished();
                }
            }
            catch (InvalidSyntaxException e) {
                Log.error((String)"Unexpected OSGi error", (Throwable)e);
            }
        }
    }

    void raiseOnInitCrashed(Exception reason) {
        if (this.context != null) {
            try {
                for (ServiceReference ref : this.context.getServiceReferences(PolyScopeInitializationObserverService.class, null)) {
                    PolyScopeInitializationObserverService service = (PolyScopeInitializationObserverService)this.context.getService(ref);
                    service.onInitCrashed(reason);
                }
            }
            catch (InvalidSyntaxException e) {
                Log.error((String)"Unexpected OSGi error", (Throwable)e);
            }
        }
    }

    void raiseOnInitBegin() {
        if (this.context != null) {
            try {
                for (ServiceReference ref : this.context.getServiceReferences(PolyScopeInitializationObserverService.class, null)) {
                    PolyScopeInitializationObserverService service = (PolyScopeInitializationObserverService)this.context.getService(ref);
                    service.onInitBegin();
                }
            }
            catch (InvalidSyntaxException e) {
                Log.error((String)"Unexpected OSGi error", (Throwable)e);
            }
        }
    }

    Collection<ServicesBinder> getServiceBinders() {
        ArrayList<ServicesBinder> r = new ArrayList<ServicesBinder>();
        try {
            for (ServicesBinder s : ServiceLoader.load(ServicesBinder.class)) {
                r.add(s);
            }
        }
        catch (Throwable e) {
            Log.error((String)"Error loading META-INF services", (Throwable)e);
        }
        if (this.context != null) {
            try {
                for (ServiceReference ref : this.context.getServiceReferences(ServicesBinder.class, null)) {
                    r.add((ServicesBinder)this.context.getService(ref));
                }
            }
            catch (InvalidSyntaxException e) {
                Log.error((String)"Unexpected OSGi error", (Throwable)e);
            }
        }
        return r;
    }
}

