/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope;

import com.ur.i18n.TextResource;
import com.ur.lang.StringUtils;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageListener;
import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.requirements.RunningRobotRequirement;
import com.ur.move.automove.AutoMoveActionResult;
import com.ur.polyscope.controllerinterface.ControllerSocketListener;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.program.ProgramHolder;
import com.ur.polyscope.program.ProgramRootNode;
import com.ur.polyscope.program.ProgramStateListener;
import com.ur.polyscope.program.monitor.ProgramState;
import com.ur.polyscope.viewfacade.program.ProgramActionResult;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.polyscope.viewfacade.program.ProgramEventType;
import com.ur.swing.FlipManager;
import com.ur.util.Waiting;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.view.constants.comm.RobotMessageType;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.constants.dev.SafetyMode;
import com.ur.view.program.ProgramControl;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DashBoard {
    private static final double AUTOMATIC_MOVE_EPSILON = 0.005;
    private static final double AUTOMATIC_MOVE_EPSILON_WHEN_NO_DIALOGS = 0.8;
    public static boolean autoLoadingNoPopups = false;
    private static RunningRobotRequirement runningRobotRequirement;
    private static ProgramState userProgramState;
    private static ProgramControl programControl;
    private static FlipManager flipManager;
    private static ProgramHolder programHolder;
    private static final Logger LOG;
    @Inject
    private static TextResource textResource;

    static {
        userProgramState = ProgramState.STOPPED;
        LOG = LogFactory.createLogger(DashBoard.class);
    }

    protected DashBoard() {
    }

    @Inject
    public static void setProgramControl(ProgramControl programControl) {
        DashBoard.programControl = programControl;
    }

    @Inject
    public static void setProgramHolder(ProgramHolder programHolder) {
        DashBoard.programHolder = programHolder;
    }

    @Inject
    public static void setRunningRobotRequirement(RunningRobotRequirement runningRobotRequirement) {
        DashBoard.runningRobotRequirement = runningRobotRequirement;
    }

    public static void setFlipManagerToHandleAutoMove(FlipManager flipManager) {
        DashBoard.flipManager = flipManager;
        DashBoard.startDashBoard();
    }

    private static void startDashBoard() {
        UpdateProgramState listener = new UpdateProgramState();
        EventNotificationService.register(DashBoard.class, RobotStateListener.class, (Object)listener);
        EventNotificationService.register(DashBoard.class, ControllerSocketListener.class, (Object)listener);
        EventNotificationService.register(DashBoard.class, RobotMessageListener.class, (Object)listener);
    }

    @Deprecated
    public static gui.program.ProgramRootNode getProgram() {
        return (gui.program.ProgramRootNode)programHolder.getProgram();
    }

    public static void setProgram(gui.program.ProgramRootNode program) {
        if (program != programHolder.getProgram()) {
            if (programHolder.getProgram() != null) {
                DashBoard.stopProgram();
            }
            if (program == null) {
                EventNotificationService.notify(ProgramEventListener.class, (NotificationStrategy)ProgramEventType.notificationStrategy((ProgramEventType)ProgramEventType.CLEANUP_CONTRIBUTION_VIEWS));
            }
            EventNotificationService.notify(ProgramEventListener.class, (NotificationStrategy)ProgramEventType.notificationStrategy((ProgramEventType)ProgramEventType.PRE_NEW_PROGRAM));
            programHolder.setProgram((ProgramRootNode)program);
            EventNotificationService.notify(ProgramEventListener.class, (NotificationStrategy)ProgramEventType.notificationStrategy((ProgramEventType)ProgramEventType.POST_NEW_PROGRAM));
        }
    }

    public static ProgramState getUserProgramState() {
        return userProgramState;
    }

    public static ProgramState getProgramState() {
        return programControl.getProgramState();
    }

    public static void fanOutProgramState() {
        ProgramState currentState = programControl.getProgramState();
        DashBoard.notifyProgramStateChanged(currentState, currentState);
    }

    public static boolean stopProgram() {
        try {
            return programControl.stopProgram() == ProgramActionResult.SUCCESS;
        }
        catch (Exception exception) {
            LOG.warn("Stop program failed", new Object[0]);
            return false;
        }
    }

    public static boolean pauseProgram() {
        try {
            return programControl.pauseProgram(DashBoard.getProgram()) == ProgramActionResult.SUCCESS;
        }
        catch (Exception exception) {
            LOG.warn("Pause program failed", new Object[0]);
            return false;
        }
    }

    public static boolean resume() {
        try {
            ProgramActionResult result = programControl.resumeProgram(DashBoard.getProgram());
            return DashBoard.handleProgramActionResult(result);
        }
        catch (ProgramControl.ProgramControlError mp) {
            mp.logAndInformUser();
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void rewindProgram() {
        try {
            programControl.rewindProgram(DashBoard.getProgram());
        }
        catch (ProgramControl.MissingProgram missingProgram) {
            LOG.warn("No program to rewind", new Object[0]);
        }
        catch (Exception exception) {
            LOG.warn("Could not rewind program", new Object[0]);
        }
    }

    public static boolean canStopProgram() {
        return programControl.canStopProgram();
    }

    public static boolean canRunProgram() {
        try {
            return programControl.canRunProgram(DashBoard.getProgram()) == ProgramActionResult.SUCCESS;
        }
        catch (ProgramControl.IncompleteProgram incompleteProgram) {
            return true;
        }
        catch (ProgramControl.MissingProgram e) {
            LOG.info("Cannot run program: " + e.getMessage(), new Object[0]);
            return false;
        }
        catch (Exception exception) {
            LOG.warn("Failed check if can run program", new Object[0]);
            return false;
        }
    }

    public static boolean canStepProgram() {
        try {
            return programControl.canStepProgram(DashBoard.getProgram()) == ProgramActionResult.SUCCESS;
        }
        catch (ProgramControl.IncompleteProgram incompleteProgram) {
            return true;
        }
        catch (Exception exception) {
            LOG.warn("Failed check if can step program", new Object[0]);
            return false;
        }
    }

    public static void stepProgram() {
        try {
            ProgramActionResult result = programControl.stepProgram(DashBoard.getProgram());
            DashBoard.handleProgramActionResult(result);
        }
        catch (ProgramControl.ProgramControlError e) {
            e.logAndInformUser();
        }
    }

    public static void slowlyMoveToStartAndPlayOrResume() {
        try {
            DashBoard.autoMoveAndPlayOrResume();
        }
        catch (ProgramControl.ProgramControlError e) {
            e.silentlyLog();
        }
    }

    public static void autoMoveAndPlayOrResume() {
        if (programControl.canRunProgram(DashBoard.getProgram()) != ProgramActionResult.SUCCESS) {
            return;
        }
        if (DashBoard.getProgramState() == ProgramState.PAUSED) {
            programControl.resumeProgram(DashBoard.getProgram());
            return;
        }
        new Thread(() -> {
            DashBoard.autoMoveToStartAutomatically();
            boolean resultOfPlay = DashBoard.play();
            LOG.debug("Play program status after Automove" + resultOfPlay, new Object[0]);
        }, "autoMoveToStartThread").start();
    }

    private static void autoMoveToStartAutomatically() {
        JointPositionVector startPosition = programControl.getFirstAvailableJointPositionVector(DashBoard.getProgram());
        programControl.autoMoveToStart(startPosition, 0.005);
    }

    public static boolean play() {
        try {
            ProgramActionResult result = programControl.playProgram(DashBoard.getProgram(), 0.005);
            return DashBoard.handleProgramActionResult(result);
        }
        catch (ProgramControl.ProgramControlError e) {
            e.logAndInformUser();
            return false;
        }
    }

    public static ProgramActionResult playNoDialogs() {
        return programControl.playProgram(DashBoard.getProgram(), 0.8);
    }

    private static boolean handleProgramActionResult(ProgramActionResult result) {
        if (result == ProgramActionResult.BAD_ROBOT_STATE) {
            runningRobotRequirement.checkAndNotify();
        }
        DashBoard.requestForAutoMoveCardIfNeeded(result);
        if (result == ProgramActionResult.ALREADY_PLAYING_PROGRAM) {
            LOG.warn("Robot is running program", new Object[0]);
        }
        return result == ProgramActionResult.SUCCESS;
    }

    private static void requestForAutoMoveCardIfNeeded(ProgramActionResult result) {
        if (result instanceof AutoMoveActionResult) {
            AutoMoveActionResult needToAutoMoveRobot = (AutoMoveActionResult)result;
            needToAutoMoveRobot.requestToMoveTo(flipManager);
        } else {
            runningRobotRequirement.checkAndNotify();
        }
    }

    private static void notifyProgramStateChanged(ProgramState from, ProgramState to) {
        EventNotificationService.notify(ProgramStateListener.class, listener -> listener.programStateChanged(from, to));
    }

    public void setMainProgram(gui.program.ProgramRootNode program) {
        DashBoard.setProgram(program);
    }

    public boolean playRobotProgramNoDialogs() {
        try {
            return DashBoard.playNoDialogs() == ProgramActionResult.SUCCESS;
        }
        catch (Exception exception) {
            LOG.warn("Play program failed", new Object[0]);
            return false;
        }
    }

    public boolean stopRobotProgram() {
        return DashBoard.stopProgram();
    }

    public boolean pauseRobotProgram() {
        return DashBoard.pauseProgram();
    }

    public static class ProgramIsPaused
    implements Waiting.ItHappens {
        public boolean itHappened() {
            return DashBoard.getProgramState() == ProgramState.PAUSED;
        }
    }

    public static class ProgramIsPlaying
    implements Waiting.ItHappens {
        public boolean itHappened() {
            return DashBoard.getProgramState() == ProgramState.PLAYING;
        }
    }

    public static class ProgramIsStopped
    implements Waiting.ItHappens {
        public boolean itHappened() {
            return DashBoard.getProgramState() == ProgramState.STOPPED;
        }
    }

    private static class UpdateProgramState
    implements RobotStateListener,
    RobotMessageListener,
    ControllerSocketListener {
        private RobotState secondToLatest;

        private UpdateProgramState() {
        }

        public void updateRobotState(RobotState rs) {
            if (rs.masterSafetyState == SafetyMode.RECOVERY) {
                this.setProgramState(ProgramState.PROHIBITED);
            } else {
                if (this.secondToLatest == null) {
                    this.secondToLatest = rs.clone();
                    return;
                }
                if (this.isProgramExecuting(rs) && this.isRobotRunning(rs)) {
                    this.handlePossibleIncognitoState(rs);
                } else if (rs.programPaused) {
                    this.setProgramState(ProgramState.PAUSED);
                } else if (!rs.programRunning || !this.isRobotRunning(rs)) {
                    this.setProgramState(ProgramState.STOPPED);
                }
                this.secondToLatest = rs.clone();
            }
        }

        private void handlePossibleIncognitoState(RobotState rs) {
            if (this.isIncognito(rs)) {
                this.setProgramState(ProgramState.STOPPED);
            } else if (!rs.programRunning && !rs.programPaused) {
                this.setProgramState(ProgramState.STOPPED);
            } else if (rs.programPaused) {
                this.setProgramState(ProgramState.PAUSED);
            } else {
                this.setProgramState(ProgramState.PLAYING);
            }
        }

        private boolean isIncognito(RobotState rs) {
            return "inkognito".equalsIgnoreCase(rs.getCurrentProgramName());
        }

        private boolean isRobotRunning(RobotState rs) {
            return rs.robotMode == RobotMode.RUNNING;
        }

        private boolean isProgramExecuting(RobotState rs) {
            return this.secondToLatest.programRunning && (!rs.programPaused || rs.speedFraction > 0.0);
        }

        public void handleRobotMessage(RobotMessage rm) {
            SafetyMode safetyMode;
            if (rm.type == RobotMessageType.SAFETY_MODE && (safetyMode = rm.safetyMode) == SafetyMode.RECOVERY) {
                this.setProgramState(ProgramState.PROHIBITED);
            }
        }

        public void socketEvent(boolean connected) {
            if (!connected) {
                this.setProgramState(ProgramState.STOPPED);
            } else {
                this.setStopProgramStateForced();
            }
        }

        private void setStopProgramStateForced() {
            RobotState.getLatestRobotState().programRunning = false;
            DashBoard.notifyProgramStateChanged(ProgramState.STOPPED, ProgramState.STOPPED);
        }

        private void setProgramState(ProgramState programState) {
            ProgramState oldState = DashBoard.getProgramState();
            if (oldState != programState) {
                programControl.setProgramState(programState);
                DashBoard.notifyProgramStateChanged(oldState, programState);
            }
        }
    }

    public static final class UserProgramStateHandler {
        private UserProgramStateHandler() {
        }

        public static void handleRobotMessage(ProgramState programState, String programName) {
            if (!StringUtils.isNullOrOnlyWhitespace((String)programName) && DashBoard.getProgram() != null && programName.equals(DashBoard.getProgram().getScriptName())) {
                LOG.info("Dashboard setting programstate to \"" + programState + "\" for program \"" + programName + "\"", new Object[0]);
                userProgramState = programState;
            } else {
                LOG.info("Dashboard setting programstate to \"Stopped\" since programName \"" + programName + "\" was not recognized", new Object[0]);
                userProgramState = ProgramState.STOPPED;
            }
        }
    }
}

