/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope;

import com.ur.i18n.TextResource;
import com.ur.util.logging.Log;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DragValueChangeHook {
    private final EventListenerList eventListenerList = new EventListenerList();
    private int mousePressedXorY = -1;
    private int progressPressedValue = -1;
    private int lastMouseDragXorY = -1;
    private int mousePressedOtherAxis = -1;
    private ProgressPanel progressPanel;
    private JPopupMenu progressPanelPopup;
    private String title = "Value";
    private String valueMessageFormatS = "{0}";
    private int min;
    private int max;
    private final int orientation;
    private TextResource textResource;
    private final InitialValueProvider initialValueProvider;
    private boolean enabled = true;
    private boolean showPopup = true;
    private boolean dragPossible = false;

    public DragValueChangeHook(Component component) {
        this(component, 1, 0, 300, null, null);
    }

    public DragValueChangeHook(Component component, int orientation, int min, int max, TextResource textResource) {
        this(component, orientation, min, max, null, textResource);
    }

    public DragValueChangeHook(Component component, int orientation, int min, int max, InitialValueProvider initialValueProvider, TextResource textResource) {
        this.min = min;
        this.max = max;
        this.initialValueProvider = initialValueProvider;
        this.orientation = orientation;
        this.textResource = textResource;
        component.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                DragValueChangeHook.this.handleMouseDragged(mouseEvent);
            }
        });
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                DragValueChangeHook.this.handleMousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                DragValueChangeHook.this.handleMouseReleased();
            }
        });
        if (!component.isFocusable()) {
            Log.warning((String)("The component " + component + " should really be focusable. Otherwise events will be lost"));
        }
        component.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                DragValueChangeHook.this.handleFocusLost();
            }
        });
    }

    void handleMouseDragged(MouseEvent mouseEvent) {
        if (this.enabled && this.dragPossible) {
            int mouseDragOtherAxis = this.getEventOtherAxis(mouseEvent);
            if (this.draggingOutsideOfArea(mouseDragOtherAxis)) {
                this.handleMouseReleased();
                this.invokeLaterMouseReleased(mouseEvent);
                this.fireDragEndedEvent();
            } else {
                int eventXorY = this.getEventXorY(mouseEvent);
                if (eventXorY != this.lastMouseDragXorY) {
                    this.lastMouseDragXorY = eventXorY;
                    this.progressPanel.setDragValue(this.calcDragValue(eventXorY));
                    this.fireDragChangedEvent();
                }
            }
        }
    }

    private boolean draggingOutsideOfArea(int mouseDragOtherAxis) {
        return Math.abs(this.mousePressedOtherAxis - mouseDragOtherAxis) > 60;
    }

    private void invokeLaterMouseReleased(final MouseEvent mouseEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MouseListener[] mouseListenerArray = ((Component)mouseEvent.getSource()).getMouseListeners();
                int n = mouseListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MouseListener ml = mouseListenerArray[n2];
                    ml.mouseReleased(mouseEvent);
                    ++n2;
                }
            }
        });
    }

    void handleMousePressed(MouseEvent mouseEvent) {
        if (this.enabled) {
            this.mousePressedXorY = this.getEventXorY(mouseEvent);
            this.mousePressedOtherAxis = this.getEventOtherAxis(mouseEvent);
            if (this.showPopup) {
                this.showProgressPopup(mouseEvent);
                this.progressPressedValue = this.progressPanel.getDragValue();
            }
            this.dragPossible = true;
            this.fireDragStartedEvent();
        }
    }

    void handleMouseReleased() {
        if (this.enabled && this.dragPossible) {
            this.abortDrag();
        }
    }

    void handleFocusLost() {
        if (this.dragPossible) {
            Log.debug((String)"Got focus lost");
            this.abortDrag();
        }
    }

    public void abortDrag() {
        this.mousePressedXorY = -1;
        this.lastMouseDragXorY = -1;
        if (this.showPopup) {
            this.hideProgressPopup();
        }
        this.dragPossible = false;
        this.fireDragEndedEvent();
    }

    public void setMin(int min) {
        this.min = min;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void setShowPopup(boolean showPopup) {
        this.showPopup = showPopup;
    }

    public void setAmountText(String text) {
        if (this.progressPanelPopup != null && this.progressPanelPopup.isVisible()) {
            this.progressPanel.setSpeedText(text);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private int calcDragValue(int eventXorY) {
        return this.progressPressedValue + (this.orientation == 1 ? -1 : 1) * (eventXorY - this.mousePressedXorY);
    }

    private int getEventXorY(MouseEvent mouseEvent) {
        return this.orientation == 1 ? mouseEvent.getY() : mouseEvent.getX();
    }

    private int getEventOtherAxis(MouseEvent mouseEvent) {
        return this.orientation == 0 ? mouseEvent.getY() : mouseEvent.getX();
    }

    public void addDragChangeListener(DragValueListener listener) {
        this.eventListenerList.add(DragValueListener.class, listener);
    }

    public void removeDragChangeListener(DragValueListener listener) {
        this.eventListenerList.remove(DragValueListener.class, listener);
    }

    protected void fireDragStartedEvent() {
        DragValueListener[] dragValueListenerArray = (DragValueListener[])this.eventListenerList.getListeners(DragValueListener.class);
        int n = dragValueListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DragValueListener cl = dragValueListenerArray[n2];
            cl.dragStarted(new ChangeEvent(this));
            ++n2;
        }
    }

    protected void fireDragEndedEvent() {
        DragValueListener[] dragValueListenerArray = (DragValueListener[])this.eventListenerList.getListeners(DragValueListener.class);
        int n = dragValueListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DragValueListener cl = dragValueListenerArray[n2];
            cl.dragEnded(new ChangeEvent(this));
            ++n2;
        }
    }

    protected void fireDragChangedEvent() {
        DragValueListener[] dragValueListenerArray = (DragValueListener[])this.eventListenerList.getListeners(DragValueListener.class);
        int n = dragValueListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DragValueListener cl = dragValueListenerArray[n2];
            cl.dragChange(new ChangeEvent(this));
            ++n2;
        }
    }

    public int getValue() {
        if (this.progressPanel != null) {
            return this.progressPanel.getTranslatedValue();
        }
        return -1;
    }

    public void setValueMessageFormatString(String s) {
        this.valueMessageFormatS = s;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private ProgressPanel createProgressPopupComponent() {
        return new ProgressPanel(this.title, this.valueMessageFormatS, this.orientation, this.min, this.max, this.initialValueProvider != null ? this.initialValueProvider.getInitialValue() : 0, this.textResource);
    }

    private Point calcPopupLocation(Component source, Dimension popupSize) {
        Window w = SwingUtilities.getWindowAncestor(source);
        int wX = (int)((double)w.getLocationOnScreen().x + (double)w.getSize().width * 0.75 - (double)popupSize.width);
        int wY = (int)((double)w.getLocationOnScreen().y + (double)w.getSize().height * 0.15);
        return new Point(wX, wY);
    }

    private void showProgressPopup(MouseEvent mouseEvent) {
        if (this.progressPanelPopup != null) {
            this.progressPanelPopup.setVisible(false);
        }
        this.progressPanel = this.createProgressPopupComponent();
        this.progressPanelPopup = new JPopupMenu();
        this.progressPanelPopup.setBackground(this.progressPanel.getBackground());
        this.progressPanelPopup.setFocusable(false);
        this.progressPanelPopup.add(this.progressPanel);
        this.progressPanelPopup.pack();
        Point popupLocation = this.calcPopupLocation((Component)mouseEvent.getSource(), this.progressPanelPopup.getSize());
        if (popupLocation != null) {
            this.progressPanelPopup.setLocation(popupLocation);
        }
        this.progressPanelPopup.setVisible(true);
        Log.debug((String)("Popup set visible at location " + this.progressPanelPopup.getLocation()));
        this.progressPanelPopup.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                DragValueChangeHook.this.hideProgressPopup();
            }
        });
    }

    private void hideProgressPopup() {
        if (this.progressPanelPopup != null) {
            this.progressPanelPopup.setVisible(false);
        }
    }

    public static class DragValueAdapter
    implements DragValueListener {
        @Override
        public void dragStarted(ChangeEvent event) {
        }

        @Override
        public void dragEnded(ChangeEvent event) {
        }

        @Override
        public void dragChange(ChangeEvent event) {
        }
    }

    public static interface DragValueListener
    extends EventListener {
        public void dragStarted(ChangeEvent var1);

        public void dragEnded(ChangeEvent var1);

        public void dragChange(ChangeEvent var1);
    }

    public static interface InitialValueProvider {
        public int getInitialValue();
    }

    private static class ProgressPanel
    extends Box {
        private final String valueMessageFormatS;
        private JProgressBar pp;
        private JLabel speedLabel;
        private final int minValue;
        private final int maxValue;
        private String speedText = null;

        public ProgressPanel(String title, String valueMessageFormatS, int orientation, int min, int max, int value, TextResource textResource) {
            super(1);
            this.valueMessageFormatS = valueMessageFormatS;
            this.minValue = min;
            this.maxValue = max;
            JLabel infoLabel = new JLabel(orientation == 1 ? textResource.dragSliderUpOrDown() : textResource.dragSliderLeftOrRight());
            infoLabel.setAlignmentX(0.5f);
            this.pp = new JProgressBar(orientation, 0, 300);
            this.setTranslatedValue(value);
            this.pp.setPreferredSize(this.calcProgressBarPreferredSize(orientation));
            JLabel titleLabel = new JLabel(title);
            titleLabel.setAlignmentX(0.5f);
            titleLabel.setFont(infoLabel.getFont().deriveFont(18.0f));
            this.speedLabel = new JLabel();
            this.speedLabel.setAlignmentX(0.5f);
            this.speedLabel.setFont(infoLabel.getFont().deriveFont(18.0f));
            this.add(titleLabel);
            this.add(this.speedLabel);
            this.add(this.pp);
            this.add(infoLabel);
            this.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
            this.setPreferredSize(this.calcPreferredSize(orientation));
            this.pp.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    this.updateSpeedLabel();
                }
            });
            this.updateSpeedLabel();
        }

        public void setSpeedText(String speedText) {
            this.speedText = speedText;
            this.updateSpeedLabel();
        }

        private void updateSpeedLabel() {
            if (this.speedText != null) {
                this.speedLabel.setText(this.speedText);
            } else {
                this.speedLabel.setText(MessageFormat.format(this.valueMessageFormatS, this.getTranslatedValue()));
            }
            this.speedLabel.repaint();
        }

        private Dimension calcProgressBarPreferredSize(int orientation) {
            return orientation == 1 ? new Dimension(50, 400) : new Dimension(400, 50);
        }

        private Dimension calcPreferredSize(int orientation) {
            return orientation == 1 ? new Dimension(180, this.getPreferredSize().height) : new Dimension(this.getPreferredSize().width, 85);
        }

        public int getDragValue() {
            return this.pp.getValue();
        }

        public void setDragValue(int value) {
            this.pp.setValue(value);
        }

        public int getTranslatedValue() {
            double val = this.pp.getValue();
            double sliderRange = this.pp.getMaximum() - this.pp.getMinimum();
            double wantedRange = this.maxValue - this.minValue;
            return (int)(val / sliderRange * wantedRange) + this.minValue;
        }

        public void setTranslatedValue(int translatedValue) {
            double sliderRange = this.pp.getMaximum() - this.pp.getMinimum();
            double wantedRange = this.maxValue - this.minValue;
            this.pp.setValue((int)((double)(translatedValue - this.minValue) / wantedRange * sliderRange));
        }
    }
}

