/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope;

import com.ur.polyscope.filemanager.FileTypePersistence;
import com.ur.polyscope.program.ProgramRootNode;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.polyscope.viewfacade.program.ProgramEventType;
import com.ur.reversible.Reversible;
import com.ur.reversible.ReversibleAction;
import com.ur.reversible.ReversibleSequence;
import com.ur.reversible.UndoRedoListener;
import com.ur.util.event.EventNotificationService;
import gui.polyscope.DashBoard;
import gui.program.FileManagementProgramComponent;
import gui.program.ProgramUndoRedoService;
import java.io.File;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.Stack;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

@Singleton
public class SaveProgramService
implements UndoRedoListener<AbstractProgramNode>,
ProgramEventListener {
    private Reversible<AbstractProgramNode> lastActionOnSave;
    private final EventListenerList listeners;
    private final Stack<Reversible<AbstractProgramNode>> undoStack = new Stack();
    private final Stack<Reversible<AbstractProgramNode>> redoStack = new Stack();

    @Inject
    public SaveProgramService(FileTypePersistence filePersistence, ProgramUndoRedoService service) {
        this.listeners = new EventListenerList();
        service.addListener(this);
        EventNotificationService.register((Object)this, ProgramEventListener.class, (Object)this);
        this.lastActionOnSave = null;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(ChangeListener.class, listener);
    }

    public void programChanged() {
        this.lastActionOnSave = new ProgramChangedAction();
        this.fireChangeEvent();
    }

    public void perform(ReversibleAction action, Reversible<AbstractProgramNode> reversible) {
        switch (action) {
            case ConsumeNew: {
                this.addNewReversible(reversible);
                break;
            }
            case PostRedo: {
                this.moveReversibleFromRedoToUndoStack(reversible);
                break;
            }
            case PostUndo: {
                this.moveReversibleFromUndoToRedoStack(reversible);
            }
        }
        this.fireChangeEvent();
    }

    private void moveReversibleFromUndoToRedoStack(Reversible<AbstractProgramNode> reversibleNew) {
        Reversible<AbstractProgramNode> reversibleOld = this.undoStack.pop();
        Reversible<AbstractProgramNode> reversible = this.isSameSize(reversibleNew, reversibleOld) ? reversibleOld : reversibleNew;
        this.redoStack.push(reversible);
    }

    private boolean isSameSize(Reversible<AbstractProgramNode> reversibleNew, Reversible<AbstractProgramNode> reversibleOld) {
        if (reversibleNew instanceof ReversibleSequence && reversibleOld instanceof ReversibleSequence) {
            return ((ReversibleSequence)reversibleNew).size() == ((ReversibleSequence)reversibleOld).size();
        }
        return false;
    }

    private void moveReversibleFromRedoToUndoStack(Reversible<AbstractProgramNode> reversibleNew) {
        Reversible<AbstractProgramNode> reversibleOld = this.redoStack.pop();
        Reversible<AbstractProgramNode> reversible = this.isSameSize(reversibleNew, reversibleOld) ? reversibleOld : reversibleNew;
        this.undoStack.push(reversible);
    }

    private void addNewReversible(Reversible<AbstractProgramNode> reversible) {
        this.undoStack.push(reversible);
    }

    public void handleProgramEvent(ProgramEventType evt) {
        switch (evt) {
            case POST_PROGRAM_SAVE: {
                this.lastActionOnSave = this.getLatestUndoable();
                this.fireChangeEvent();
                break;
            }
            case POST_NEW_PROGRAM: {
                this.lastActionOnSave = null;
                this.undoStack.clear();
                this.redoStack.clear();
                this.fireChangeEvent();
                break;
            }
        }
    }

    public void handleProgramEvent(ProgramEventType evt, ProgramRootNode programRootNode) {
        this.handleProgramEvent(evt);
    }

    public void handleProgramEvent(ProgramEventType evt, File programFile) {
        this.handleProgramEvent(evt);
    }

    private void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        ChangeListener[] changeListenerArray = (ChangeListener[])this.listeners.getListeners(ChangeListener.class);
        int n = changeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeListener each = changeListenerArray[n2];
            each.stateChanged(changeEvent);
            ++n2;
        }
    }

    public boolean hasChanges() {
        boolean result = this.lastActionOnSave != this.getLatestUndoable();
        return result;
    }

    public Date getLastSavedDate() {
        File programFile = DashBoard.getProgram().getComponent(FileManagementProgramComponent.class).getProgramFile();
        if (programFile == null || this.hasChanges()) {
            return null;
        }
        return new Date(programFile.lastModified());
    }

    private Reversible<AbstractProgramNode> getLatestUndoable() {
        Reversible<AbstractProgramNode> reversible = null;
        try {
            reversible = this.undoStack.peek();
        }
        catch (EmptyStackException emptyStackException) {}
        return reversible;
    }

    private static class ProgramChangedAction
    implements Reversible<AbstractProgramNode> {
        private ProgramChangedAction() {
        }

        public AbstractProgramNode getTarget() {
            return null;
        }

        public void undo() {
        }
    }
}

