/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope;

import com.ur.lang.EqualsUtil;
import com.ur.view.constants.dev.SafetyMode;
import com.ur.view.constants.runtime.SpeedMode;

public class SpeedParams {
    public static final double MANUAL_LOW_SPEED = 0.25;
    public final double speedFraction;
    public final double speedScaling;
    public final double speedFractionLimit;
    public final boolean programPaused;
    public final boolean programRunning;
    public final SafetyMode masterSafetyState;
    public final SpeedMode speedMode;

    public SpeedParams() {
        this(0.0, 0.0, 0.0, false, false, null, null);
    }

    public SpeedParams(double speedFraction, double speedScaling, double speedFractionLimit, boolean programPaused, boolean programRunning, SafetyMode masterSafetyState, SpeedMode speedMode) {
        this.speedFraction = speedFraction;
        this.speedScaling = speedScaling;
        this.speedFractionLimit = speedFractionLimit;
        this.programPaused = programPaused;
        this.programRunning = programRunning;
        this.masterSafetyState = masterSafetyState;
        this.speedMode = speedMode;
    }

    public static int toDisplaySpeedFraction(double speed) {
        return (int)(speed * 100.0);
    }

    public static double fromDisplaySpeedFraction(int speed) {
        return (double)speed / 100.0;
    }

    public boolean epsilonEquals(SpeedParams other) {
        return EqualsUtil.equals((double)this.speedFraction, (double)other.speedFraction, (double)0.001) && EqualsUtil.equals((double)this.speedScaling, (double)other.speedScaling, (double)0.001) && EqualsUtil.equals((double)this.speedFractionLimit, (double)other.speedFractionLimit, (double)0.001) && this.programPaused == other.programPaused && this.programRunning == other.programRunning && this.masterSafetyState == other.masterSafetyState && this.speedMode == other.speedMode;
    }

    public String getActualAndDesiredSpeedText() {
        int desiredSpeedPercentage = this.getDesiredSpeedPercent();
        String newSpeedSliderTextValue = String.valueOf(desiredSpeedPercentage) + "%";
        if (this.programRunning) {
            String actualSpeedPercentage = this.createActualSpeedPercentage();
            newSpeedSliderTextValue = String.valueOf(newSpeedSliderTextValue) + actualSpeedPercentage;
        }
        return newSpeedSliderTextValue;
    }

    private String createActualSpeedPercentage() {
        int actualSpeedPercentage = this.getActualSpeedPercent();
        if (actualSpeedPercentage != this.getDesiredSpeedPercent()) {
            return " (" + actualSpeedPercentage + "%)";
        }
        return "";
    }

    public int getDesiredSpeedPercent() {
        return (int)(this.speedFraction * 100.0);
    }

    public int getActualSpeedPercent() {
        return (int)(this.speedScaling * (double)this.getDesiredSpeedPercent());
    }

    private boolean isRobotInMobileSafetyMode() {
        return EqualsUtil.equalsOneOf((Object)this.masterSafetyState, (Object[])new SafetyMode[]{SafetyMode.NORMAL, SafetyMode.REDUCED, SafetyMode.RECOVERY, SafetyMode.VALIDATE_JOINT_ID});
    }

    public boolean isPaused() {
        return this.speedFraction < 1.0E-5 || this.programPaused || !this.isRobotInMobileSafetyMode();
    }
}

