/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.contribution;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.urcaps.extensions.ProgramContributionTreeChangeListener;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.ExtendedContribution;
import com.ur.util.event.EventManager;
import com.ur.util.event.NotificationStrategy;
import gui.polyscope.contribution.Contribution;
import gui.polyscope.program.ProgramTreeChangeObserver;
import gui.program.ContributableProgramNode;
import java.util.Enumeration;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ProgramContributionTreeChangeNotifier
implements ProgramTreeChangeObserver {
    private EventManager eventManager;

    @Inject
    public ProgramContributionTreeChangeNotifier(EventManager eventManager) {
        this.eventManager = eventManager;
        eventManager.addStrongListener(ProgramTreeChangeObserver.class, (Object)this);
    }

    @Override
    public void handleProgramTreeEvent(ProgramTreeChangeObserver.ProgramTreeEvent event) {
        this.handleAllContributableProgramNodes(event.node, event);
    }

    private void handleAllContributableProgramNodes(AbstractProgramNode programNode, ProgramTreeChangeObserver.ProgramTreeEvent event) {
        if (programNode instanceof ContributableProgramNode) {
            this.handleContributableProgramNode((ContributableProgramNode)programNode, event);
        }
        if (programNode.getChildCount() == 0) {
            return;
        }
        Enumeration enumeration = programNode.children();
        while (enumeration.hasMoreElements()) {
            Object nextElement = enumeration.nextElement();
            if (!(nextElement instanceof AbstractProgramNode)) continue;
            this.handleAllContributableProgramNodes((AbstractProgramNode)nextElement, event);
        }
    }

    private void handleContributableProgramNode(ContributableProgramNode contributableProgramNode, ProgramTreeChangeObserver.ProgramTreeEvent event) {
        Contribution contribution = contributableProgramNode.getContribution();
        if (!contribution.getExtendedContribution().isPresent()) {
            return;
        }
        final ProgramContributionTreeChangeListener.ProgramContributionTreeEvent contributionEvent = this.createContributionEvent(event.type, (ExtendedContribution)contribution.getExtendedContribution().get(), contributableProgramNode.isAClone());
        this.eventManager.fireEvent(ProgramContributionTreeChangeListener.class, (NotificationStrategy)new NotificationStrategy<ProgramContributionTreeChangeListener>(){

            public void notify(ProgramContributionTreeChangeListener programContributionTreeChangeListener) {
                programContributionTreeChangeListener.handleProgramContributionTreeEvent(contributionEvent);
            }
        });
    }

    private ProgramContributionTreeChangeListener.ProgramContributionTreeEvent createContributionEvent(ProgramTreeChangeObserver.Type type, ExtendedContribution extendedContribution, boolean isCloning) {
        switch (type) {
            case NODE_INSERTED: {
                return new ProgramContributionTreeChangeListener.ProgramContributionTreeEvent(ProgramContributionTreeChangeListener.EventType.CONTRIBUTION_INSERTED, extendedContribution, isCloning);
            }
            case NODE_REMOVED: {
                return new ProgramContributionTreeChangeListener.ProgramContributionTreeEvent(ProgramContributionTreeChangeListener.EventType.CONTRIBUTION_REMOVED, extendedContribution);
            }
        }
        return null;
    }
}

