/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.program;

import com.ur.i18n.TextResource;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramModel;
import com.ur.polyscope.program.nodes.ProgramSelectionModel;
import com.ur.polyscope.program.nodes.rules.ProgramNodeInsertionRule;
import gui.polyscope.program.InsertNodeStrategy;
import gui.polyscope.program.rules.insertion.BeforePointAndAfterEndNodeCannotMoveRule;
import gui.polyscope.program.rules.insertion.BeforeStartNodeCannotMoveRule;
import gui.polyscope.program.rules.insertion.CannotAddNodesToInitVariables;
import gui.polyscope.program.rules.insertion.CircleMoveCanOnlyBeInsertedToMovePNodeRule;
import gui.polyscope.program.rules.insertion.CircleMoveNodeInsertionRule;
import gui.polyscope.program.rules.insertion.DirectionAndWaypointChildInsertionRule;
import gui.polyscope.program.rules.insertion.DirectionNodeInsertionRule;
import gui.polyscope.program.rules.insertion.ElseAndElseIfNodesMustBeAddedToProperIfNode;
import gui.polyscope.program.rules.insertion.InitVariablesNodeOnlyInsertedBeforeProgramRootNodeRule;
import gui.polyscope.program.rules.insertion.MainProgramNodeCannotMoveRule;
import gui.polyscope.program.rules.insertion.MoveDirectionNodeInsertionRule;
import gui.polyscope.program.rules.insertion.MustBeTopLevelNodeRule;
import gui.polyscope.program.rules.insertion.OnlyPreProgramNodesExistBeforeMainProgram;
import gui.polyscope.program.rules.insertion.PalletNodeInsertionRule;
import gui.polyscope.program.rules.insertion.PatternNodeInsertionRule;
import gui.polyscope.program.rules.insertion.PlaceholderNodeNotAllowedRule;
import gui.polyscope.program.rules.insertion.PositionNodeMustBeChildOfMoveNode;
import gui.polyscope.program.rules.insertion.StackNodeInsertionRule;
import gui.polyscope.program.rules.insertion.SubProgramNodesCannotCallSubProgramNodes;
import gui.polyscope.program.rules.insertion.UntilNodeInsertionRule;
import gui.program.EntityFactory;
import gui.program.EventNode;
import gui.program.MainProgram;
import gui.program.MotionDefiningNode;
import gui.program.MoveChildNode;
import gui.program.ProgramRootNode;
import gui.program.SubProgramNode;
import gui.program.SuppressedNode;
import gui.program.ThreadNode;
import gui.program.switchnode.CasesCanOnlyBeAddedToSwitchRule;
import gui.program.until.UntilNode;
import gui.tools.LegacyURDialogCreator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public abstract class AbstractInsertNodeStrategy
implements InsertNodeStrategy {
    private final EntityFactory entityFactory;
    protected final List<ProgramNodeInsertionRule> rules = new ArrayList<ProgramNodeInsertionRule>();
    @Inject
    private Set<ProgramNodeInsertionRule> contributedRules = new HashSet<ProgramNodeInsertionRule>();
    @Inject
    private TextResource textResource;

    protected AbstractInsertNodeStrategy(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
        this.addRule(new CasesCanOnlyBeAddedToSwitchRule());
        this.addRule(new MainProgramNodeCannotMoveRule());
        this.addRule(new PlaceholderNodeNotAllowedRule());
        this.addRule(new BeforeStartNodeCannotMoveRule());
        this.addRule(new BeforePointAndAfterEndNodeCannotMoveRule());
        this.addRule(new InitVariablesNodeOnlyInsertedBeforeProgramRootNodeRule());
        this.addRule(new CannotAddNodesToInitVariables());
        this.addRule(new CircleMoveCanOnlyBeInsertedToMovePNodeRule());
        this.addRule(new OnlyPreProgramNodesExistBeforeMainProgram());
        this.addRule(new MustBeTopLevelNodeRule(ThreadNode.class, EventNode.class, SubProgramNode.class));
        this.addRule(new PositionNodeMustBeChildOfMoveNode());
        this.addRule(new SubProgramNodesCannotCallSubProgramNodes());
        this.addRule(new ElseAndElseIfNodesMustBeAddedToProperIfNode());
        this.addRule(new PalletNodeInsertionRule());
        this.addRule(new DirectionNodeInsertionRule());
        this.addRule(new PatternNodeInsertionRule());
        this.addRule(new StackNodeInsertionRule());
        this.addRule(new CircleMoveNodeInsertionRule());
        this.addRule(new MoveDirectionNodeInsertionRule());
        this.addRule(new UntilNodeInsertionRule());
        this.addRule(new DirectionAndWaypointChildInsertionRule());
    }

    protected void addRule(ProgramNodeInsertionRule rule) {
        this.rules.add(rule);
    }

    @Override
    public abstract boolean insert(AbstractProgramNode var1, AbstractProgramNode var2);

    @Override
    public boolean insertChild(AbstractProgramNode newNode, AbstractProgramNode currentNode, int deltaIndex) {
        int index = deltaIndex;
        if (currentNode == null || currentNode.getParent() == null) {
            LegacyURDialogCreator.showMessageDialog(this.textResource.noNodeSelected());
            return false;
        }
        AbstractProgramNode nodeToCheck = newNode;
        if (nodeToCheck instanceof SuppressedNode) {
            SuppressedNode sn = (SuppressedNode)nodeToCheck;
            nodeToCheck = sn.getSuppressedNode();
        }
        AbstractProgramNode currentParentNode = null;
        if (this.isTopLevelNodeOrMainProgram(currentNode)) {
            if (nodeToCheck.isOfSort(AbstractProgramNode.ProgramNodeSort.TOP_LEVEL)) {
                currentParentNode = (AbstractProgramNode)currentNode.getParent();
            } else {
                currentParentNode = currentNode;
                index = 0;
            }
        } else if (newNode instanceof UntilNode && !(currentNode instanceof UntilNode) && !(currentNode instanceof SuppressedNode)) {
            currentParentNode = currentNode;
            index = 0;
        } else if (currentNode instanceof UntilNode && !(newNode instanceof UntilNode) && !(newNode instanceof SuppressedNode)) {
            if (currentNode.getNodeType().isChildrenAllowed()) {
                currentParentNode = currentNode;
                index = 0;
            } else {
                currentParentNode = (AbstractProgramNode)currentNode.getParent().getParent();
                index = ((AbstractProgramNode)currentNode.getParent()).getIndexAfter((AbstractProgramNode)currentNode.getParent());
            }
        } else {
            currentParentNode = (AbstractProgramNode)currentNode.getParent();
        }
        if (newNode instanceof MoveChildNode) {
            MotionDefiningNode mdf;
            try {
                mdf = (MotionDefiningNode)currentParentNode.getNodeOfType(MotionDefiningNode.class);
            }
            catch (Exception exception) {
                mdf = null;
            }
            if (mdf == null || mdf.isOfSort(AbstractProgramNode.ProgramNodeSort.TOP_LEVEL)) {
                if (currentNode instanceof MotionDefiningNode) {
                    currentParentNode = currentNode;
                    index = 0;
                } else {
                    nodeToCheck = newNode = this.entityFactory.createMoveNode((MoveChildNode)newNode);
                }
            }
        }
        if (this.checkRules(index, nodeToCheck, currentParentNode, this.contributedRules)) {
            return false;
        }
        if (this.checkRules(index, nodeToCheck, currentParentNode, this.rules)) {
            return false;
        }
        return this.insertNodeInto(newNode, currentParentNode, index);
    }

    private boolean checkRules(int index, AbstractProgramNode nodeToCheck, AbstractProgramNode currentParentNode, Collection<ProgramNodeInsertionRule> rules) {
        for (ProgramNodeInsertionRule each : rules) {
            if (each.canInsert(nodeToCheck, currentParentNode, index)) continue;
            String errorMessage = each.getErrorMessage(nodeToCheck, currentParentNode, index);
            if (errorMessage != null) {
                LegacyURDialogCreator.showMessageDialog(errorMessage);
            }
            return true;
        }
        return false;
    }

    protected boolean insertNodeInto(AbstractProgramNode newNode, AbstractProgramNode parentNode, int index) {
        TreeNode root;
        ProgramModel treeModel = parentNode.getProgramTreeModel();
        TreeNode newNodeParent = newNode.getParent();
        if (newNodeParent != null) {
            int newNodeIndex;
            if (newNodeParent == parentNode && (newNodeIndex = newNodeParent.getIndex((TreeNode)newNode)) < index) {
                --index;
            }
            treeModel.removeNodeFromParent((MutableTreeNode)newNode);
        }
        treeModel.insertNodeInto((MutableTreeNode)newNode, (MutableTreeNode)parentNode, index);
        Enumeration penum = newNode.breadthFirstEnumeration();
        while (penum.hasMoreElements()) {
            treeModel.makeVisible((AbstractProgramNode)penum.nextElement());
        }
        if (newNode.getParent() != null && (root = parentNode.getRoot()) instanceof ProgramRootNode) {
            this.setSelectedNode((ProgramRootNode)((Object)root), newNode);
        }
        if (parentNode != null && index < parentNode.getChildCount()) {
            return parentNode.getChildAt(index) == newNode;
        }
        return false;
    }

    protected boolean isTopLevelNodeOrMainProgram(AbstractProgramNode currentNode) {
        return currentNode instanceof MainProgram || currentNode.getParent() instanceof ProgramRootNode;
    }

    public void setSelectedNode(ProgramRootNode root, AbstractProgramNode node) {
        root.getComponent(ProgramSelectionModel.class).setSelected(node);
    }
}

