/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.program;

import com.ur.polyscope.program.ProgramRootNode;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.rules.ProgramNodeRemovalRule;
import gui.polyscope.program.rules.removal.CircleMoveNodeRemovalRule;
import gui.polyscope.program.rules.removal.DirectionNodeRemovalRule;
import gui.polyscope.program.rules.removal.MainProgramCannotBeRemoved;
import gui.polyscope.program.rules.removal.PalletNodeRemovalRule;
import gui.polyscope.program.rules.removal.PatternNodeRemovalRule;
import gui.polyscope.program.rules.removal.StackNodeRemovalRule;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.MutableTreeNode;

public abstract class AbstractRemoveNodeStrategy {
    protected final List<ProgramNodeRemovalRule> rules = new ArrayList<ProgramNodeRemovalRule>();

    public AbstractRemoveNodeStrategy() {
        this.addRule(new PalletNodeRemovalRule());
        this.addRule(new PatternNodeRemovalRule());
        this.addRule(new StackNodeRemovalRule());
        this.addRule(new DirectionNodeRemovalRule());
        this.addRule(new CircleMoveNodeRemovalRule());
        this.addRule(new MainProgramCannotBeRemoved());
    }

    protected void addRule(ProgramNodeRemovalRule rule) {
        this.rules.add(rule);
    }

    public boolean removeNode(AbstractProgramNode nodeToRemove) {
        boolean isRemovable = this.isRemovable(nodeToRemove);
        if (isRemovable) {
            nodeToRemove.getProgramTreeModel().removeNodeFromParent((MutableTreeNode)nodeToRemove);
        }
        return isRemovable;
    }

    public boolean isRemovable(AbstractProgramNode nodeToRemove) {
        return this.getViolatedRule(nodeToRemove) == null && this.isInTree(nodeToRemove);
    }

    private boolean isInTree(AbstractProgramNode nodeToRemove) {
        return nodeToRemove != null && nodeToRemove.getRoot() instanceof ProgramRootNode;
    }

    public String getErrorMessage(AbstractProgramNode nodeToRemove) {
        ProgramNodeRemovalRule violatedRule = this.getViolatedRule(nodeToRemove);
        if (violatedRule != null) {
            return violatedRule.getErrorMessage(nodeToRemove);
        }
        return "";
    }

    private ProgramNodeRemovalRule getViolatedRule(AbstractProgramNode nodeToRemove) {
        ProgramNodeRemovalRule violatedRule = null;
        for (ProgramNodeRemovalRule rule : this.rules) {
            if (rule.canRemove(nodeToRemove)) continue;
            violatedRule = rule;
            break;
        }
        return violatedRule;
    }
}

