/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.program;

import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.monitor.RobotState;
import com.ur.monitor.Source;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramNodeTraversal;
import com.ur.polyscope.program.nodes.ProgramSelectionModel;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.canvasbehavior.URCanvas3DFingerDragViewShifter;
import com.ur.polyscope.visualizer.canvasbehavior.UpdateZoomInCanvas;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehaviorHolder;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehaviorWrapper;
import com.ur.polyscope.visualizer.canvasbehavior.ZoomRenderer;
import com.ur.polyscope.visualizer.element.VisualizerElementType;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.polyscope.visualizer.geomfeature.ProgramVisualization;
import com.ur.polyscope.visualizer.j3dcomponents.J3DComponent;
import com.ur.polyscope.visualizer.j3dcomponents.J3DToggleButton;
import com.ur.polyscope.visualizer.panel.ElementsVisualizer;
import com.ur.polyscope.visualizer.panel.ElementsVisualizerAggregator;
import com.ur.polyscope.visualizer.programvisualization.VisualizerMotionData;
import com.ur.polyscope.visualizer.programvisualization.VisualizerProgramRootNode;
import com.ur.resources.ViewImageResource;
import com.ur.swing.CardPanel;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.util.event.EventManager;
import com.ur.util.event.Subscription;
import com.ur.util.logging.Log;
import gui.installation.services.ProgramLookupService;
import gui.polyscope.BlendChangeListener;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import gui.program.ForceNode;
import gui.program.position.PositionNode;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.inject.Inject;
import javax.media.j3d.PickInfo;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.vecmath.Point3d;

public class GraphicsTab
extends CardPanel {
    private final ElementsVisualizer elementsVisualizerAggregator;
    private final ProgramLookupService programLookupService;
    private final GeomPoseNode forceModeFrameFeature;
    private final RobotCanvas3DFactory robotCanvas3DFactory;
    private final VisualizerMotionData visualizerMotionData;
    private static final int BUTTON_SIZE = 40;
    private ViewBehavior viewBehavior = ViewBehavior.NONE;
    private RobotCanvas3D robotCanvas3D;
    private final ProgramVisualization programVisualization;
    private AbstractProgramNode lastUpdateNode = null;
    private AbstractProgramNode lastShadowNode = null;
    private ForceNode nearestForceNodeOfLastUpdateNode = null;
    private boolean firstTimeAfterEnter = false;
    private boolean lastTimeBeforeExit = false;
    private J3DToggleButton obstaclesToggleButton;
    private J3DToggleButton pathToggleButton;
    private J3DToggleButton positionsToggleButton;
    private JPanel robotPanel;
    private J3DToggleButton robotToggleButton;
    private J3DToggleButton shadowRobotToggleButton;
    private final HelpIdAssigner helpIdAssigner;
    private Subscription robotStateSubscription = Subscription.NULL;
    private Recipe<RobotState> robotStateRecipe;
    private final Consumer<RobotState> robotStateConsumer = new RobotStateConsumer();
    private final ViewBehaviorWrapper viewBehaviorWrapper;

    @Inject
    GraphicsTab(ElementsVisualizerAggregator elementsVisualizerAggregator, ProgramLookupService programLookupService, GeomPoseNode forceModeFrameFeature, RobotCanvas3DFactory robotCanvas3DFactory, VisualizerMotionData visualizerMotionData, EventManager eventManager, FeaturesLookup featuresLookup, HelpIdAssigner helpIdAssigner, @Source(value=RobotState.class) Recipe<RobotState> robotStateRecipe) {
        this.elementsVisualizerAggregator = elementsVisualizerAggregator;
        this.programLookupService = programLookupService;
        this.forceModeFrameFeature = forceModeFrameFeature;
        this.robotCanvas3DFactory = robotCanvas3DFactory;
        this.visualizerMotionData = visualizerMotionData;
        this.helpIdAssigner = helpIdAssigner;
        this.robotStateRecipe = robotStateRecipe;
        this.initComponents();
        this.programVisualization = new ProgramVisualization(this.robotCanvas3D.isActualCanvas());
        if (this.robotCanvas3D.isActualCanvas()) {
            this.robotCanvas3D.addNodeToScene(this.programVisualization.getElementNode());
            this.robotCanvas3D.addNodeToScene(elementsVisualizerAggregator.getElementNode());
        }
        this.robotCanvas3D.getComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GraphicsTab.this.robotCanvasPanelMouseClicked(evt);
            }
        });
        new URCanvas3DFingerDragViewShifter(this.robotCanvas3D);
        this.viewBehaviorWrapper = new ViewBehaviorWrapper(featuresLookup);
        ZoomRenderer zr = new ZoomRenderer(this.robotCanvas3D.getComponent(), (ViewBehaviorHolder)this.viewBehaviorWrapper);
        this.robotCanvas3D.addJ3DComponent((J3DComponent)zr);
        forceModeFrameFeature.setPosition(new JointPositionVector(), new Point3d(), new Point3d());
        this.assignHelpIds();
        eventManager.addStrongListener(BlendChangeListener.class, (Object)this.createBlendListener());
    }

    private BlendChangeListener createBlendListener() {
        return new BlendChangeListener(){

            @Override
            public void updateBlends() {
                GraphicsTab.this.robotCanvas3D.addQueue((Runnable)new UpdateProgramVisualizationRunnable());
            }
        };
    }

    private void assignHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)this.robotPanel, "gui:graphicstab_3d_view");
    }

    public void robotCanvasPanelMouseClicked(MouseEvent mouseEvent) {
        AbstractProgramNode pn;
        PickInfo pickInfo = this.robotCanvas3D.pickClosest(mouseEvent);
        if (pickInfo != null && (pn = (AbstractProgramNode)this.programVisualization.shapeToProgramNodeMap.get(pickInfo.getNode())) != null) {
            pn.setSelected();
        }
    }

    public void enter(Object object) {
        super.enter(object);
        this.viewBehavior = ViewBehavior.NONE;
        this.lastUpdateNode = null;
        this.lastShadowNode = null;
        this.firstTimeAfterEnter = true;
        this.lastTimeBeforeExit = false;
        if (this.programLookupService.getProgramRootNode() == null) {
            Log.error((String)"DashBoard.getProgram returns null", (Throwable)new Exception());
            return;
        }
        this.lastUpdateNode = this.programLookupService.getProgramRootNode().getComponent(ProgramSelectionModel.class).getCurrentNode();
        this.robotCanvas3D.alwaysRun((Runnable)new UpdateZoomInCanvas((ViewBehaviorHolder)this.viewBehaviorWrapper));
        this.robotCanvas3D.setVisible(true);
        this.robotCanvas3D.enter();
        this.robotStateSubscription.dispose();
        this.robotStateSubscription = this.robotStateRecipe.executeOnUIThread().subscribe(this.robotStateConsumer);
    }

    public Object exit() {
        this.robotStateSubscription.dispose();
        this.robotStateSubscription = Subscription.NULL;
        this.lastTimeBeforeExit = true;
        this.lastUpdateNode = null;
        this.lastShadowNode = null;
        this.nearestForceNodeOfLastUpdateNode = null;
        this.viewBehavior = ViewBehavior.NONE;
        this.robotStateConsumer.accept((Object)((RobotState)this.robotStateRecipe.lastProvider().get()));
        this.robotCanvas3D.setVisible(false);
        this.robotCanvas3D.exit();
        return super.exit();
    }

    private boolean updateRobotShadow(AbstractProgramNode node) {
        JointPositionVector qShadow;
        PositionNode pNode;
        if (node instanceof PositionNode && (pNode = (PositionNode)node).getPositionNodeType() == PositionNodeType.FIXED && (qShadow = pNode.getActualJointPositionVector()) != null && !qShadow.isUndefined()) {
            this.robotCanvas3D.setShadowRobotJointAngleVector(qShadow);
            return true;
        }
        return false;
    }

    private void showSafetyBoundaries(boolean show, RobotState robotState) {
        if (!robotState.programRunning && robotState.hasReceivedPositionData && show) {
            this.elementsVisualizerAggregator.displayProximity(robotState.tool);
        } else {
            this.elementsVisualizerAggregator.clearVisualization();
        }
    }

    private void initComponents() {
        this.shadowRobotToggleButton = new J3DToggleButton(" ", ((ImageIcon)ViewImageResource.robotTransparentIcon()).getImage(), 40, 40);
        this.robotToggleButton = new J3DToggleButton(" ", ((ImageIcon)ViewImageResource.robotIcon()).getImage(), 40, 40);
        this.positionsToggleButton = new J3DToggleButton(" ", ((ImageIcon)ViewImageResource.pointIcon()).getImage(), 40, 40);
        this.pathToggleButton = new J3DToggleButton(" ", ((ImageIcon)ViewImageResource.pathIcon()).getImage(), 40, 40);
        this.obstaclesToggleButton = new J3DToggleButton(" ", ((ImageIcon)ViewImageResource.obstacleIcon()).getImage(), 40, 40);
        this.shadowRobotToggleButton.setToggled(false);
        this.robotToggleButton.setToggled(false);
        this.positionsToggleButton.setToggled(false);
        this.pathToggleButton.setToggled(false);
        this.obstaclesToggleButton.setToggled(true);
        this.robotCanvas3D = this.robotCanvas3DFactory.buildMetalRobot();
        this.robotCanvas3D.setDebugName("G5 Program Graphics Canvas");
        this.positionsToggleButton.setLocation(650, 10);
        this.robotCanvas3D.addJ3DComponent((J3DComponent)this.positionsToggleButton);
        this.pathToggleButton.setLocation(600, 10);
        this.robotCanvas3D.addJ3DComponent((J3DComponent)this.pathToggleButton);
        this.robotToggleButton.setLocation(550, 10);
        this.robotCanvas3D.addJ3DComponent((J3DComponent)this.robotToggleButton);
        this.shadowRobotToggleButton.setLocation(500, 10);
        this.robotCanvas3D.addJ3DComponent((J3DComponent)this.shadowRobotToggleButton);
        this.obstaclesToggleButton.setLocation(450, 10);
        this.robotCanvas3D.addJ3DComponent((J3DComponent)this.obstaclesToggleButton);
        this.robotCanvas3D.showStaticElements(Arrays.asList(VisualizerElementType.PAYLOAD_COG, VisualizerElementType.TCP));
        this.setLayout(new BorderLayout());
        this.robotPanel = new JPanel();
        this.robotPanel.setLayout(new BorderLayout());
        this.robotPanel.add(this.robotCanvas3D.getComponent());
        JPanel spacer = new JPanel();
        spacer.setPreferredSize(new Dimension(12, 0));
        this.add(spacer, "West");
        this.add(this.robotPanel, "Center");
    }

    private class RobotStateConsumer
    implements Consumer<RobotState> {
        private RobotStateConsumer() {
        }

        public void accept(RobotState rs) {
            boolean showThePath;
            if (rs == null || GraphicsTab.this.programLookupService.getProgramRootNode() == null || GraphicsTab.this.robotCanvas3D.hasRunnablesQueued()) {
                return;
            }
            AbstractProgramNode node = GraphicsTab.this.programLookupService.getProgramRootNode().getComponent(ProgramSelectionModel.class).getCurrentNode();
            boolean update = GraphicsTab.this.lastUpdateNode != node;
            boolean showTheRobotShadow = !GraphicsTab.this.shadowRobotToggleButton.isToggled() && node != null;
            boolean updateShadowRobot = showTheRobotShadow && node != GraphicsTab.this.lastShadowNode;
            boolean showTheRobot = !GraphicsTab.this.robotToggleButton.isToggled();
            boolean showTheObstacles = !GraphicsTab.this.obstaclesToggleButton.isToggled();
            boolean showThePositions = GraphicsTab.this.viewBehavior == ViewBehavior.NONE && !GraphicsTab.this.positionsToggleButton.isToggled();
            boolean bl = showThePath = !GraphicsTab.this.pathToggleButton.isToggled();
            if (update && updateShadowRobot) {
                GraphicsTab.this.lastShadowNode = node;
            } else if (showTheRobotShadow) {
                GraphicsTab.this.lastShadowNode = null;
            }
            if (update) {
                GraphicsTab.this.lastUpdateNode = node;
                GraphicsTab.this.nearestForceNodeOfLastUpdateNode = null;
                if (GraphicsTab.this.lastUpdateNode != null) {
                    if (GraphicsTab.this.lastUpdateNode instanceof ForceNode) {
                        GraphicsTab.this.nearestForceNodeOfLastUpdateNode = (ForceNode)GraphicsTab.this.lastUpdateNode;
                    } else {
                        Object ancestor = GraphicsTab.this.lastUpdateNode.getNearestAncestorOfClass(ForceNode.class);
                        if (ancestor != null && ancestor instanceof ForceNode) {
                            GraphicsTab.this.nearestForceNodeOfLastUpdateNode = (ForceNode)ancestor;
                        }
                    }
                }
            }
            GraphicsTab.this.robotCanvas3D.addQueue((Runnable)new UpdateGraphicsRunnable(rs, node, update, showTheRobotShadow, updateShadowRobot, showTheRobot, showTheObstacles, showThePositions, showThePath));
        }
    }

    private class UpdateGraphicsRunnable
    implements Runnable {
        private final RobotState rs;
        private final AbstractProgramNode node;
        private final boolean update;
        private final boolean showTheRobotShadow;
        private final boolean updateShadowRobot;
        private final boolean showTheRobot;
        private final boolean showTheObstacles;
        private final boolean showThePositions;
        private final boolean showThePath;

        UpdateGraphicsRunnable(RobotState rs, AbstractProgramNode node, boolean update, boolean showTheRobotShadow, boolean updateShadowRobot, boolean showTheRobot, boolean showTheObstacles, boolean showThePositions, boolean showThePath) {
            this.rs = rs;
            this.node = node;
            this.update = update;
            this.showTheRobotShadow = showTheRobotShadow;
            this.updateShadowRobot = updateShadowRobot;
            this.showTheRobot = showTheRobot;
            this.showTheObstacles = showTheObstacles;
            this.showThePositions = showThePositions;
            this.showThePath = showThePath;
        }

        @Override
        public void run() {
            boolean programIsExecuting;
            if (GraphicsTab.this.lastTimeBeforeExit) {
                GraphicsTab.this.elementsVisualizerAggregator.clearVisualization();
                GraphicsTab.this.lastTimeBeforeExit = false;
                return;
            }
            if (GraphicsTab.this.firstTimeAfterEnter) {
                GraphicsTab.this.programVisualization.updateProgramVisualization((VisualizerProgramRootNode)GraphicsTab.this.programLookupService.getProgramRootNode(), GraphicsTab.this.visualizerMotionData);
                GraphicsTab.this.elementsVisualizerAggregator.initialize();
                GraphicsTab.this.firstTimeAfterEnter = false;
            }
            GraphicsTab.this.showSafetyBoundaries(this.showTheObstacles, this.rs);
            GraphicsTab.this.programVisualization.setObstaclesVisibleState(this.showTheObstacles);
            GraphicsTab.this.programVisualization.setPointsVisibleState(this.showThePositions);
            GraphicsTab.this.programVisualization.setPathsVisibleState(this.showThePath);
            if (this.update && this.showThePath) {
                GraphicsTab.this.programVisualization.updatePathVisualisation((ProgramNodeTraversal)this.node, GraphicsTab.this.visualizerMotionData);
            }
            boolean shadowRobotUpdated = false;
            if (this.updateShadowRobot) {
                shadowRobotUpdated = GraphicsTab.this.updateRobotShadow(this.node);
            }
            if (this.showTheRobotShadow && shadowRobotUpdated) {
                GraphicsTab.this.robotCanvas3D.setShadowRobotAttached(true);
            } else if (!this.showTheRobotShadow || this.updateShadowRobot) {
                GraphicsTab.this.robotCanvas3D.setShadowRobotAttached(false);
            }
            GraphicsTab.this.robotCanvas3D.setRobotAttached(this.showTheRobot);
            if (this.showTheRobot) {
                GraphicsTab.this.robotCanvas3D.setJointAngleVector(this.rs.jointPosition);
            }
            boolean bl = programIsExecuting = this.rs.programPaused || this.rs.programRunning;
            if (GraphicsTab.this.nearestForceNodeOfLastUpdateNode != null && GraphicsTab.this.nearestForceNodeOfLastUpdateNode.isAdvanced() && programIsExecuting) {
                Pose6d forceModeFrame = new Pose6d(this.rs.force_mode_frame);
                GraphicsTab.this.forceModeFrameFeature.setNewTransform(Pose6dTransformUtils.getTransform3D((Pose6d)forceModeFrame));
                GraphicsTab.this.programVisualization.showTransformCoordinateSystemForFeature((GeomFeature)GraphicsTab.this.forceModeFrameFeature);
                GraphicsTab.this.programVisualization.setCoordinateSystemsVisibleState(true);
            } else {
                GraphicsTab.this.programVisualization.setCoordinateSystemsVisibleState(false);
            }
        }
    }

    private class UpdateProgramVisualizationRunnable
    implements Runnable {
        private UpdateProgramVisualizationRunnable() {
        }

        @Override
        public void run() {
            GraphicsTab.this.programVisualization.updateProgramVisualization((VisualizerProgramRootNode)GraphicsTab.this.programLookupService.getProgramRootNode(), GraphicsTab.this.visualizerMotionData);
        }
    }

    public static enum ViewBehavior {
        NONE,
        ZOOMING_IN,
        ZOOMING_OUT,
        PANNING_LEFT,
        PANNING_RIGHT,
        PANNING_UP,
        PANNING_DOWN,
        UPDATED;

    }
}

