/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.program;

import com.ur.i18n.TextResource;
import com.ur.polyscope.filemanager.FileTypePersistence;
import com.ur.polyscope.immi.Immi;
import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.swing.CardPanel;
import com.ur.swing.SwingUtil;
import com.ur.swing.ViewContext;
import com.ur.swing.help.HelpIdAssignerExt;
import com.ur.view.polyscope.persistence.program.ProgramRootNodePersistence;
import gui.installation.RobotInstallationLookupService;
import gui.polyscope.DashBoard;
import gui.program.EntityFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NewProgramPanel
extends CardPanel {
    public static final String EUROMAP67_TEMPLATE_BUTTON = "euromap67TemplateButton.NewProgramPanel";
    public static final String EMPTY_PROGRAM_BUTTON = "emptyProgram.NewProgramPanel";
    private final FileTypePersistence filePersistence;
    private final EntityFactory entityFactory;
    private final ProgramModeHolder programModeService;
    private final RobotInstallationLookupService lookupService;
    private List<Component> componentsDisabled = new ArrayList<Component>();
    private JButton emptyProgramButton;
    private JButton euromapTemplateButton;
    private JPanel jPanel10;
    private JPanel templatePanel;
    private JButton loadProgramButton;
    private JButton pickAndPlaceButton;
    private final ViewContext viewContext;

    public NewProgramPanel(FileTypePersistence filePersistence, ProgramModeHolder programModeService, RobotInstallationLookupService lookupService, ViewContext viewContext) {
        this.filePersistence = filePersistence;
        this.entityFactory = null;
        this.programModeService = programModeService;
        this.lookupService = lookupService;
        this.viewContext = viewContext;
        this.initComponents();
    }

    @Inject
    NewProgramPanel(FileTypePersistence filePersistence, EntityFactory entityFactory, ProgramModeHolder programModeService, RobotInstallationLookupService lookupService, ViewContext viewContext) {
        this.filePersistence = filePersistence;
        this.entityFactory = entityFactory;
        this.programModeService = programModeService;
        this.lookupService = lookupService;
        this.viewContext = viewContext;
        this.initComponents();
        this.jPanel10.setVisible(false);
        this.initHelperIds();
        this.euromapTemplateButton.setName(EUROMAP67_TEMPLATE_BUTTON);
    }

    private void initHelperIds() {
        HelpIdAssignerExt helpIdAssigner = this.viewContext.getHelpIdAssigner();
        helpIdAssigner.assignHelpId((JComponent)this.pickAndPlaceButton, "gui:polyscope_newprogram");
        helpIdAssigner.assignHelpId((JComponent)this.loadProgramButton, "gui:load_screen");
        helpIdAssigner.assignHelpId((JComponent)this.emptyProgramButton, "gui:polyscope_newprogram");
        helpIdAssigner.assignHelpId((JComponent)this.euromapTemplateButton, "gui:euromap67_newProgramTemplate");
    }

    public void enter(Object o) {
        boolean showEuromapTemplate = ((Immi)this.lookupService.getComponent(Immi.class)).isEnabled();
        this.euromapTemplateButton.setVisible(showEuromapTemplate);
        if (this.programModeService.getMode() == ProgramModeHolder.ProgramMode.Calibration) {
            SwingUtil.setEnabledRecursive((Container)this.templatePanel, (boolean)false, this.componentsDisabled, (String[])new String[0]);
        } else if (!this.componentsDisabled.isEmpty()) {
            SwingUtil.setEnabledComponents(this.componentsDisabled, (boolean)true);
            this.componentsDisabled.clear();
        }
    }

    public Object exit() {
        return null;
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JLabel jLabel1 = new JLabel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel4 = new JPanel();
        this.loadProgramButton = new JButton();
        this.templatePanel = new JPanel();
        JPanel jPanel6 = new JPanel();
        this.pickAndPlaceButton = new JButton();
        JPanel jPanel8 = new JPanel();
        this.emptyProgramButton = new JButton();
        JPanel jPanel11 = new JPanel();
        this.euromapTemplateButton = new JButton();
        this.jPanel10 = new JPanel();
        this.setMaximumSize(new Dimension(800, 600));
        this.setMinimumSize(new Dimension(800, 600));
        this.setPreferredSize(new Dimension(800, 600));
        this.setLayout(new BorderLayout());
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        jLabel1.setText(textResource.newProgramHeading());
        jPanel1.add(jLabel1);
        this.add(jPanel1, "North");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(1, 100, 1, 100));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel4.setBorder(BorderFactory.createTitledBorder(textResource.loadFromFile()));
        jPanel4.setMinimumSize(new Dimension(200, 400));
        this.loadProgramButton.setText(textResource.loadProgram());
        this.loadProgramButton.setPreferredSize(new Dimension(300, 40));
        this.loadProgramButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewProgramPanel.this.loadProgramButtonActionPerformed();
            }
        });
        jPanel4.add(this.loadProgramButton);
        jPanel2.add(jPanel4);
        this.templatePanel.setBorder(BorderFactory.createTitledBorder(textResource.useTemplate()));
        this.templatePanel.setMinimumSize(new Dimension(200, 400));
        this.templatePanel.setLayout(new GridLayout(4, 1));
        this.pickAndPlaceButton.setText(textResource.pickAndPlace());
        this.pickAndPlaceButton.setPreferredSize(new Dimension(300, 40));
        this.pickAndPlaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewProgramPanel.this.pickAndPlaceButtonActionPerformed();
            }
        });
        jPanel6.add(this.pickAndPlaceButton);
        this.templatePanel.add(jPanel6);
        this.emptyProgramButton.setName(EMPTY_PROGRAM_BUTTON);
        this.emptyProgramButton.setText(textResource.emptyProgram());
        this.emptyProgramButton.setPreferredSize(new Dimension(300, 40));
        this.emptyProgramButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewProgramPanel.this.emptyProgramButtonActionPerformed();
            }
        });
        jPanel8.add(this.emptyProgramButton);
        this.templatePanel.add(jPanel8);
        this.euromapTemplateButton.setText(textResource.Euromap67());
        this.euromapTemplateButton.setName("newProgramEuromap67TemplateButton");
        this.euromapTemplateButton.setPreferredSize(new Dimension(300, 40));
        this.euromapTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewProgramPanel.this.euromapTemplateButtonActionPerformed();
            }
        });
        jPanel11.add(this.euromapTemplateButton);
        this.euromapTemplateButton.getAccessibleContext().setAccessibleName("newProgramEuromap67TemplateButton");
        this.templatePanel.add(jPanel11);
        this.templatePanel.add(this.jPanel10);
        jPanel2.add(this.templatePanel);
        this.add(jPanel2, "Center");
    }

    private void emptyProgramButtonActionPerformed() {
        DashBoard.setProgram(this.entityFactory.getEmptyProgramTemplate());
    }

    private void pickAndPlaceButtonActionPerformed() {
        DashBoard.setProgram(this.entityFactory.getPickAndPlaceTemplate());
    }

    private void loadProgramButtonActionPerformed() {
        ProgramRootNodePersistence.performAdvancedLoadProgram((TextResource)this.viewContext.getTextResource(TextResource.class), this.filePersistence, this.programModeService);
    }

    private void euromapTemplateButtonActionPerformed() {
        DashBoard.setProgram(this.entityFactory.getImmiTemplate());
    }
}

