/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.program;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import gui.program.SuppressedNode;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;

public class ProgramNodeAdapter {
    private final AbstractProgramNode node;

    public ProgramNodeAdapter(AbstractProgramNode node) {
        this.node = node;
    }

    public ProgramNodeAdapter getPrevious() {
        TreeNode parent = this.node.getParent();
        if (parent != null) {
            int index = this.getIndex();
            --index;
            while (index >= 0) {
                TreeNode tn = parent.getChildAt(index);
                if (tn instanceof AbstractProgramNode) {
                    return new ProgramNodeAdapter((AbstractProgramNode)tn);
                }
                --index;
            }
        }
        return null;
    }

    public int getIndex() {
        TreeNode parent = this.node.getParent();
        return parent != null ? parent.getIndex((TreeNode)this.node) : -1;
    }

    public boolean isSuppressed() {
        return this.node instanceof SuppressedNode;
    }

    public AbstractProgramNode getRawNode() {
        return this.node;
    }

    public AbstractProgramNode getProgramNode() {
        return this.isSuppressed() ? ((SuppressedNode)this.getRawNode()).getSuppressedNode() : this.getRawNode();
    }

    public List<ProgramNodeAdapter> searchChildren(Predicate p) {
        ArrayList<ProgramNodeAdapter> r = new ArrayList<ProgramNodeAdapter>();
        AbstractProgramNode node = this.getRawNode();
        int i = 0;
        while (i < node.getChildCount()) {
            ProgramNodeAdapter pna;
            TreeNode tn = node.getChildAt(i);
            if (tn instanceof AbstractProgramNode && p.match(pna = new ProgramNodeAdapter((AbstractProgramNode)tn))) {
                r.add(pna);
            }
            ++i;
        }
        return r;
    }

    public List<ProgramNodeAdapter> searchSiblings(Predicate p) {
        ArrayList<ProgramNodeAdapter> r = new ArrayList<ProgramNodeAdapter>();
        TreeNode parent = this.getRawNode().getParent();
        if (parent instanceof AbstractProgramNode) {
            ProgramNodeAdapter pna = new ProgramNodeAdapter((AbstractProgramNode)parent);
            for (ProgramNodeAdapter c : pna.searchChildren(p)) {
                if (c.getRawNode() == this.getRawNode()) continue;
                r.add(c);
            }
        }
        return r;
    }

    static interface Predicate {
        public boolean match(ProgramNodeAdapter var1);
    }
}

