/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.program;

import com.ur.log.logentry.robotmessage.RobotMessageListener;
import com.ur.polyscope.program.ProgramStateListener;
import com.ur.polyscope.program.cache.DefinedCache;
import com.ur.polyscope.program.monitor.ProgramState;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramModel;
import com.ur.polyscope.program.nodes.ProgramSelectionModel;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.swing.CardPanel;
import com.ur.swing.SwingUtil;
import com.ur.swing.ViewContext;
import com.ur.swing.baseview.SidePlaceholders;
import com.ur.swing.extensible.ExtensionPoint;
import com.ur.swing.flippable.FlippableTabbedPanel;
import com.ur.util.event.EventManager;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import com.ur.view.polyscope.persistence.program.ProgramRootNodePersistence;
import com.ur.view.program.OverlayPainter;
import com.ur.view.program.linenumbers.BreakPointHitListener;
import com.ur.view.program.linenumbers.BreakPointModel;
import com.ur.view.program.linenumbers.LineNumberModel;
import com.ur.view.program.linenumbers.ProgramTreeDecorated;
import gui.polyscope.DashBoard;
import gui.polyscope.SaveProgramService;
import gui.polyscope.program.ProgramTreeExecutionIndicatorRenderer;
import gui.polyscope.program.RightTabbedView;
import gui.polyscope.program.linenumbers.LineNumberComponent;
import gui.tree.ProgramTreeProvider;
import gui.tree.TreeExpansionComplete;
import gui.tree.TreePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.concurrent.FutureTask;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreeModel;

@Singleton
@ExtensionPoint(value="EditProgramTree")
public class ProgramPanel
extends TreePanel
implements ProgramStateListener,
RightTabbedView,
ProgramTreeProvider,
BreakPointHitListener {
    public static final String PROGRAM_PANEL = "ProgramPanel";
    public static final String PROGRAM_PANEL_TABS = "programPanelTabs.ProgramPanel";
    public static final String PROGRAM_TREE = "programTree.ProgramPanel";
    private final FlippableTabbedPanel selectedNodeTabbedPanel = new FlippableTabbedPanel();
    private final SaveProgramService saveProgramService;
    private final Provider<LineNumberModel> lineNumberModelProvider;
    private final Provider<BreakPointModel> breakPointModelProvider;
    private final DefinedCache programNodeDefinedCache;
    private ProgramModel programTreeModel;
    private ProgramPanelContribution panelsContribution;
    private OverlayPainter overlayPainter;
    private CardPanel doubleClickDefault;
    private LineNumberComponent lineNumberComponent;
    private BreakPointModel currentBreakPointModel;
    private ProgramRootNodePersistence programRootNodePersistence;

    public ProgramPanel(ViewContext viewContext, SidePlaceholders placeholders) {
        super(viewContext, placeholders);
        this.saveProgramService = null;
        this.lineNumberModelProvider = null;
        this.breakPointModelProvider = null;
        this.programNodeDefinedCache = null;
    }

    @Inject
    ProgramPanel(ProgramPanelContribution panelsContribution, ViewContext viewContext, SidePlaceholders placeholders, SaveProgramService saveProgramService, EventManager eventManager, ProgramTreeExecutionIndicatorRenderer programTreeExecutionIndicatorRenderer, Provider<LineNumberModel> lineNumberModelProvider, Provider<BreakPointModel> breakPointModelProvider, ProgramRootNodePersistence programRootNodePersistence, DefinedCache programNodeDefinedCache) {
        super(viewContext, placeholders);
        this.panelsContribution = panelsContribution;
        this.saveProgramService = saveProgramService;
        this.lineNumberModelProvider = lineNumberModelProvider;
        this.breakPointModelProvider = breakPointModelProvider;
        this.programRootNodePersistence = programRootNodePersistence;
        this.programNodeDefinedCache = programNodeDefinedCache;
        this.initLineNumberComponent();
        this.addTabs();
        this.hideLoadIcon();
        this.tree.setRootVisible(false);
        this.saveIcon.setEnabled(true);
        this.tree.setUI(programTreeExecutionIndicatorRenderer);
        EventNotificationService.register((Object)this, RobotMessageListener.class, (Object)programTreeExecutionIndicatorRenderer);
        this.selectedNodeTabbedPanel.setCardParent((CardPanel)this);
        this.selectedNodeTabbedPanel.setName(PROGRAM_PANEL_TABS);
        saveProgramService.addChangeListener(e -> this.updateSaveIcon());
        this.setName(PROGRAM_PANEL);
        this.getTree().setName(PROGRAM_TREE);
        viewContext.getHelpIdAssigner().assignHelpId((JComponent)this.getTree(), "gui:program_tree");
        eventManager.addStrongListener(BreakPointHitListener.class, (Object)this);
        eventManager.addStrongListener(ProgramEventListener.class, (Object)new ProgramEventListener.Template(){

            public void onPostNewProgram() {
                SwingUtil.invokeAndWait(() -> {
                    ProgramPanel.this.updateProgram();
                    ProgramPanel.this.updateProgramName();
                    ProgramPanel.this.updateSaveIcon();
                });
            }

            public void onPostProgramSave() {
                SwingUtil.invokeAndWait(() -> {
                    ProgramPanel.this.updateProgramName();
                    ProgramPanel.this.updateSaveIcon();
                });
            }

            public void onPostNewInstallation() {
                SwingUtil.invokeAndWait(() -> ProgramPanel.this.updateProgram(true));
            }
        });
    }

    private void initLineNumberComponent() {
        this.currentBreakPointModel = (BreakPointModel)this.breakPointModelProvider.get();
        this.lineNumberComponent = new LineNumberComponent((LineNumberModel)this.lineNumberModelProvider.get(), this.currentBreakPointModel).initComponent();
        this.lineNumberComponent.setBackground(Color.WHITE);
        this.lineNumberComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        EventNotificationService.register((Object)this.lineNumberComponent, TreeExpansionComplete.class, () -> {
            FutureTask futureTask = SwingUtil.invokeLater(() -> this.lineNumberComponent.update());
        });
        this.getScrollPane().setRowHeaderView(this.lineNumberComponent);
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                if (ProgramPanel.isTreeExpansionDone()) {
                    ProgramPanel.this.lineNumberComponent.update();
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                ProgramPanel.this.lineNumberComponent.update();
            }
        });
    }

    public JTree getProgramTree() {
        return this.tree;
    }

    public void enter(Object o) {
        if (this.lineNumberComponent != null) {
            EventNotificationService.register((Object)this, ProgramTreeDecorated.class, () -> this.lineNumberComponent.update());
        }
        if (DashBoard.getProgram() != null) {
            this.programTreeModel = DashBoard.getProgram().getProgramTreeModel();
        }
        try {
            this.updateProgram();
        }
        catch (Exception e) {
            Log.error((String)"updateProgram() threw Exception: ", (Throwable)e);
        }
        try {
            this.updateProgramName();
            this.updateSaveIcon();
            this.selectedNodeTabbedPanel.enterActiveChild(null);
        }
        catch (Exception e) {
            Log.error((String)"Exception caught: ", (Throwable)e);
        }
        EventNotificationService.register((Object)this, ProgramStateListener.class, (Object)this);
    }

    public Object exit() {
        EventNotificationService.unregister((Object)this, ProgramStateListener.class);
        if (this.lineNumberComponent != null) {
            EventNotificationService.unregister((Object)this, ProgramTreeDecorated.class);
        }
        this.selectedNodeTabbedPanel.exitActiveChild();
        if (this.programTreeModel != null) {
            this.programTreeModel = null;
        }
        return null;
    }

    private void updateProgram() {
        this.updateProgram(false);
    }

    private void updateProgram(boolean forceUpdate) {
        this.enableCache();
        try {
            if (DashBoard.getProgram() != null && (this.tree.getModel() != DashBoard.getProgram().getProgramTreeModel() || forceUpdate)) {
                this.tree.setModel((TreeModel)DashBoard.getProgram().getProgramTreeModel());
                DashBoard.getProgram().getComponent(ProgramSelectionModel.class).setSelected((AbstractProgramNode)DashBoard.getProgram().getMainProgram());
                this.saveIcon.setEnabled(false);
                this.expandTreeNonGuiBlocking();
            }
        }
        finally {
            this.disableCache();
        }
    }

    public void updateProgramName() {
        if (DashBoard.getProgram() != null) {
            String name = DashBoard.getProgram().getName();
            if (!name.equals(this.treeNameLabel.getText())) {
                this.treeNameLabel.setText(name);
            }
        } else {
            this.treeNameLabel.setText("<null>");
        }
    }

    private void updateSaveIcon() {
        boolean enabled = this.saveProgramService.hasChanges();
        if (enabled != this.saveIcon.isEnabled()) {
            this.saveIcon.setEnabled(enabled);
        }
    }

    private void addTabs() {
        this.selectedNodeTabbedPanel.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        JPanel surroundsTabbedPanel = new JPanel(new BorderLayout());
        surroundsTabbedPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        surroundsTabbedPanel.setOpaque(false);
        surroundsTabbedPanel.add((Component)this.selectedNodeTabbedPanel, "Center");
        this.doubleClickDefault = null;
        for (Map.Entry<CardPanel, String> each : this.panelsContribution.getOrderedMap().entrySet()) {
            if (this.doubleClickDefault == null) {
                this.doubleClickDefault = each.getKey();
            }
            this.selectedNodeTabbedPanel.addCardPanel(each.getKey(), each.getValue());
        }
        this.insertComponentIntoPlaceholderPanel(surroundsTabbedPanel);
    }

    @Override
    public void selectTab(Class<? extends CardPanel> tabClass) {
        this.selectedNodeTabbedPanel.switchTo(tabClass);
    }

    @Override
    protected void handleSaveIconMouseClicked(MouseEvent evt) {
        this.programRootNodePersistence.save(ProgramRootNodePersistence.EMPTY_ACTION);
    }

    @Override
    protected void handleTreeMouseClicked(MouseEvent evt) {
        if (!this.relayClickToOverlay(evt) && evt.getClickCount() >= 2) {
            this.selectedNodeTabbedPanel.switchTo(this.doubleClickDefault.getClass());
        }
    }

    public void paintChildren(Graphics g) {
        try {
            this.enableCache();
            super.paintChildren(g);
            this.overlayPainter.paintOverlay(g);
        }
        finally {
            this.disableCache();
        }
    }

    private void disableCache() {
        if (this.programNodeDefinedCache == null) {
            return;
        }
        this.programNodeDefinedCache.disable();
    }

    private void enableCache() {
        if (this.programNodeDefinedCache == null) {
            return;
        }
        this.programNodeDefinedCache.enable();
    }

    public void setOverlayPainter(OverlayPainter overlayPainter) {
        this.overlayPainter = overlayPainter;
    }

    private boolean relayClickToOverlay(MouseEvent e) {
        if (this.overlayPainter != null) {
            return this.overlayPainter.processMouseClickEvent(e);
        }
        return false;
    }

    public BreakPointModel getCurrentBreakPointModel() {
        return this.currentBreakPointModel;
    }

    @Override
    public void breakPointHit(int labelID) {
        this.lineNumberComponent.repaint();
    }

    public void programStateChanged(ProgramState oldState, ProgramState newState) {
        this.repaint();
    }

    public static interface ProgramPanelContribution {
        public Map<CardPanel, String> getOrderedMap();
    }
}

