/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.program;

import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageListener;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.resources.ViewImageResource;
import com.ur.util.event.EventNotificationService;
import com.ur.view.constants.comm.RobotMessageType;
import com.ur.view.program.ProgramTrackingInformation;
import com.ur.view.program.execution.ProgramExecutionID;
import com.ur.view.program.execution.ProgramTrackingInfoChangedListener;
import gui.installation.services.ProgramLookupService;
import gui.program.HideableNode;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.inject.Inject;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;

public class ProgramTreeExecutionIndicatorRenderer
extends BasicTreeUI
implements RobotMessageListener,
ProgramTrackingInfoChangedListener {
    private final ProgramLookupService programLookupService;
    private final ProgramTrackingInformation programTrackingInformation;
    private Icon executingIcon = ViewImageResource.programExecutionIndicator();
    private boolean drawNodeExecutionIndicator = false;
    private int executionId;

    @Inject
    public ProgramTreeExecutionIndicatorRenderer(ProgramLookupService programLookupService, ProgramTrackingInformation programTrackingInformation) {
        this.programLookupService = programLookupService;
        this.programTrackingInformation = programTrackingInformation;
        EventNotificationService.register((Object)this, ProgramTrackingInfoChangedListener.class, (Object)this);
    }

    @Override
    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        this.drawNodeExecutionIndicator = this.isExecutingNode(path);
        super.paintHorizontalPartOfLeg(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
    }

    @Override
    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
        super.paintHorizontalLine(g, c, y, left, right);
        if (this.drawNodeExecutionIndicator) {
            this.executingIcon.paintIcon(c, g, left, y - this.executingIcon.getIconHeight() / 2);
        }
    }

    private boolean isExecutingNode(TreePath path) {
        AbstractProgramNode programNode;
        Object node = path.getLastPathComponent();
        boolean result = false;
        if (node instanceof AbstractProgramNode && (programNode = (AbstractProgramNode)node).isExecuting() && programNode.getId() == this.executionId) {
            result = true;
        }
        return result;
    }

    @Override
    protected boolean shouldPaintExpandControl(TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        boolean isKeptHidden = this.isKeptHidden(path.getLastPathComponent());
        boolean isExecuting = this.isExecutingNode(path);
        if (isLeaf || isKeptHidden || isExecuting) {
            return false;
        }
        int depth = path.getPathCount() - 1;
        return depth != 0 && (depth != 1 || this.isRootVisible()) || this.getShowsRootHandles();
    }

    private boolean isKeptHidden(Object component) {
        if (component instanceof HideableNode) {
            return ((HideableNode)component).getKeepHidden();
        }
        return false;
    }

    public void handleRobotMessage(RobotMessage robotMessage) {
        int id;
        if (robotMessage.type == RobotMessageType.PROGRAM_LABEL_THREADS && (id = ProgramExecutionID.getExecutingId(this.programLookupService, this.programTrackingInformation, robotMessage.getLabelinfo())) != -1) {
            this.executionId = id;
        }
    }

    @Override
    public void trackedThreadChanged(AbstractProgramNode newTrackedThread) {
        this.executionId = this.programTrackingInformation.getLastExecutingIdOnThread(newTrackedThread.toString());
    }
}

