/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.program;

import com.ur.i18n.TextResource;
import com.ur.lang.PrimitiveUtils;
import com.ur.lang.naming.NamedEntityCollection;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.program.ProgramComponent;
import com.ur.polyscope.program.cache.DefinedCache;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramModel;
import com.ur.polyscope.program.undoredo.ProgramTreeChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.swing.SwingUtil;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.util.logging.Log;
import com.ur.view.polyscope.interception.ProgramExecutionStateAspect;
import gui.commandpanels.ControlProgramTreeStructure;
import gui.polyscope.program.ProgramNodeInsertState;
import gui.polyscope.program.ProgramTreeChangeObserver;
import gui.polyscope.program.ProgramTreeModel$AjcClosure1;
import gui.polyscope.program.ProgramTreeModel$AjcClosure3;
import gui.polyscope.program.ProgramTreeModel$AjcClosure5;
import gui.polyscope.program.ProgramTreeModel$AjcClosure7;
import gui.program.EntityFactory;
import gui.program.PlaceholderNode;
import gui.program.ProgramRootNode;
import gui.program.UpdateExecutionFlowComponent;
import gui.tools.LegacyURDialogCreator;
import java.util.Collection;
import javax.inject.Inject;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class ProgramTreeModel
extends DefaultTreeModel
implements ProgramModel {
    private final NamingService namingService;
    private final EntityFactory entityFactory;
    private final ControlProgramTreeStructure controlProgramTreeStructure;
    private final ProgramNodeInsertState programNodeInsertState;
    private final DefinedCache programNodeDefinedCache;
    private TextResource textResource;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @Inject
    public ProgramTreeModel(NamingService namingService, EntityFactory entityFactory, ControlProgramTreeStructure controlProgramTreeStructure, ProgramNodeInsertState programNodeInsertState, DefinedCache programNodeDefinedCache, TextResource textResource) {
        super(null);
        this.namingService = namingService;
        this.entityFactory = entityFactory;
        this.controlProgramTreeStructure = controlProgramTreeStructure;
        this.programNodeInsertState = programNodeInsertState;
        this.programNodeDefinedCache = programNodeDefinedCache;
        this.textResource = textResource;
    }

    @Override
    @ProgramTreeChange
    public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        MutableTreeNode mutableTreeNode = newChild;
        MutableTreeNode mutableTreeNode2 = parent;
        int n = index;
        Object[] objectArray = new Object[]{mutableTreeNode, mutableTreeNode2, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, mutableTreeNode, mutableTreeNode2, Conversions.intObject((int)n), joinPoint};
        ProgramTreeModel$AjcClosure3 programTreeModel$AjcClosure3 = new ProgramTreeModel$AjcClosure3(objectArray2);
        try {
            ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(programTreeModel$AjcClosure3.linkStackClosureAndJoinPoint(69648));
            programTreeModel$AjcClosure3.unlink();
        }
        catch (Throwable throwable) {
            programTreeModel$AjcClosure3.unlink();
            throw throwable;
        }
    }

    private void uiInsertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        try {
            try {
                this.programNodeDefinedCache.enable();
                this.programNodeInsertState.vetoCallsToIsUndefined(parent);
                this.tryInsertNodeInto(newChild, parent, index);
            }
            catch (Exception e) {
                Log.error((String)("Failed to insert " + newChild + " into [" + index + "]"), (Throwable)e);
                if (newChild instanceof AbstractProgramNode) {
                    AbstractProgramNode node = (AbstractProgramNode)newChild;
                    this.namingService.deregisterNamedEntities((NamedEntityCollection)node.getProgramEntitiesInSubtree((Collection)new NamedEntityCollection()));
                }
                try {
                    if (this.programNodeInsertState.cancelVetoForCallsToIsUndefined(parent)) {
                        this.nodeChanged(parent);
                    }
                }
                finally {
                    this.programNodeDefinedCache.disable();
                }
            }
        }
        finally {
            try {
                if (this.programNodeInsertState.cancelVetoForCallsToIsUndefined(parent)) {
                    this.nodeChanged(parent);
                }
            }
            finally {
                this.programNodeDefinedCache.disable();
            }
        }
    }

    private void tryInsertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        boolean removePlaceholder;
        this.setProgramRoot(this.getProgramRoot(parent), newChild);
        int childCountBefore = parent.getChildCount();
        boolean bl = removePlaceholder = parent instanceof AbstractProgramNode && ((AbstractProgramNode)parent).getNodeType().isChildrenAllowed() && parent.getChildCount() == 1 && parent.getChildAt(0) instanceof PlaceholderNode;
        if (removePlaceholder) {
            parent.remove(0);
            index = 0;
        }
        index = PrimitiveUtils.between((int)index, (int)0, (int)parent.getChildCount());
        parent.insert(newChild, index);
        if (parent.getChildCount() == childCountBefore + 1) {
            this.nodesWereInserted(parent, new int[]{index});
        } else {
            this.nodeStructureChanged(parent);
        }
        NamedEntityCollection collection = (NamedEntityCollection)((AbstractProgramNode)newChild).getProgramEntitiesInSubtree((Collection)new NamedEntityCollection());
        this.namingService.registerNamedEntities(collection);
        if (parent instanceof AbstractProgramNode) {
            UpdateExecutionFlowComponent.updateExecutionFlow((AbstractProgramNode)parent);
            this.fireProgramTreeChange(new ProgramTreeChangeObserver.ProgramTreeEvent(ProgramTreeChangeObserver.Type.NODE_INSERTED, (AbstractProgramNode)newChild, (AbstractProgramNode)parent));
        }
    }

    @Override
    @ProgramTreeChange
    public void removeNodeFromParent(MutableTreeNode node) {
        MutableTreeNode mutableTreeNode = node;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)mutableTreeNode);
        Object[] objectArray = new Object[]{this, mutableTreeNode, joinPoint};
        ProgramTreeModel$AjcClosure7 programTreeModel$AjcClosure7 = new ProgramTreeModel$AjcClosure7(objectArray);
        try {
            ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(programTreeModel$AjcClosure7.linkStackClosureAndJoinPoint(69648));
            programTreeModel$AjcClosure7.unlink();
        }
        catch (Throwable throwable) {
            programTreeModel$AjcClosure7.unlink();
            throw throwable;
        }
    }

    private void uiRemoveNodeFromParent(MutableTreeNode node) {
        MutableTreeNode parent = (MutableTreeNode)node.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("node does not have a parent.");
        }
        try {
            try {
                this.programNodeDefinedCache.enable();
                this.tryRemoveNodeFromParent((AbstractProgramNode)node, parent);
            }
            catch (Exception exception) {
                LegacyURDialogCreator.showMessageDialog(this.textResource.couldNotRemoveNode());
                this.programNodeDefinedCache.disable();
            }
        }
        finally {
            this.programNodeDefinedCache.disable();
        }
    }

    private void tryRemoveNodeFromParent(AbstractProgramNode programNode, MutableTreeNode parent) {
        int[] childIndex = new int[1];
        Object[] removedArray = new Object[1];
        int childCountBefore = parent.getChildCount();
        childIndex[0] = parent.getIndex((TreeNode)programNode);
        parent.remove(childIndex[0]);
        if (programNode.isUnregisterProgramReferencesOnDelete()) {
            this.namingService.deregisterNamedEntities((NamedEntityCollection)programNode.getProgramEntitiesInSubtree((Collection)new NamedEntityCollection()));
        }
        removedArray[0] = programNode;
        if (parent.getChildCount() > childIndex[0] && parent.getChildAt(childIndex[0]) == programNode) {
            LegacyURDialogCreator.showMessageDialog(this.textResource.couldNotRemoveNode());
            return;
        }
        if (parent.getChildCount() != childCountBefore - 1) {
            this.nodeStructureChanged(parent);
        } else {
            this.nodesWereRemoved(parent, childIndex, removedArray);
        }
        boolean insertPlaceholder = this.isPlaceholderRequired(parent);
        if (insertPlaceholder) {
            PlaceholderNode placeholder = this.entityFactory.createPlaceholderNode();
            parent.insert((MutableTreeNode)((Object)placeholder), 0);
            this.nodesWereInserted(parent, new int[1]);
            this.setProgramRoot(this.getProgramRoot(parent), (MutableTreeNode)((Object)placeholder));
            this.controlProgramTreeStructure.makeVisible((TreeNode)((Object)placeholder));
        }
        if (parent instanceof AbstractProgramNode) {
            UpdateExecutionFlowComponent.updateExecutionFlow((AbstractProgramNode)parent);
            this.fireProgramTreeChange(new ProgramTreeChangeObserver.ProgramTreeEvent(ProgramTreeChangeObserver.Type.NODE_REMOVED, programNode, (AbstractProgramNode)parent));
        }
    }

    private boolean isPlaceholderRequired(MutableTreeNode node) {
        boolean isPlaceHolderRequired;
        boolean hasNoChildren = node.getChildCount() == 0;
        boolean isChildrenAllowed = node instanceof AbstractProgramNode && ((AbstractProgramNode)node).getNodeType().isChildrenAllowed();
        boolean bl = isPlaceHolderRequired = node instanceof AbstractProgramNode && ((AbstractProgramNode)node).getNodeType().isPlaceHolderRequired();
        return hasNoChildren && isChildrenAllowed && isPlaceHolderRequired;
    }

    private void fireProgramTreeChange(final ProgramTreeChangeObserver.ProgramTreeEvent event) {
        EventNotificationService.notify(ProgramTreeChangeObserver.class, (NotificationStrategy)new NotificationStrategy<ProgramTreeChangeObserver>(){

            public void notify(ProgramTreeChangeObserver listener) {
                listener.handleProgramTreeEvent(event);
            }
        });
    }

    private ProgramRootNode getProgramRoot(MutableTreeNode node) {
        if (node instanceof AbstractProgramNode) {
            return ProgramRootNode.get((AbstractProgramNode)node);
        }
        return null;
    }

    private void setProgramRoot(ProgramRootNode root, MutableTreeNode dst) {
        if (root != null && dst instanceof AbstractProgramNode) {
            ProgramRootNode.setProgramRoot(root, (AbstractProgramNode)dst);
        }
    }

    public void makeVisible(AbstractProgramNode programNode) {
        if (this.controlProgramTreeStructure != null) {
            this.controlProgramTreeStructure.makeVisible((TreeNode)programNode);
        }
    }

    public Class<? extends ProgramComponent> getType() {
        return ProgramModel.class;
    }

    static {
        ProgramTreeModel.ajc$preClinit();
    }

    static final /* synthetic */ void insertNodeInto_aroundBody0(ProgramTreeModel ajc$this, final MutableTreeNode newChild, final MutableTreeNode parent, final int index, JoinPoint joinPoint) {
        SwingUtil.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                ProgramTreeModel.this.uiInsertNodeInto(newChild, parent, index);
            }
        });
    }

    static final /* synthetic */ void insertNodeInto_aroundBody2(ProgramTreeModel programTreeModel, MutableTreeNode mutableTreeNode, MutableTreeNode mutableTreeNode2, int n, JoinPoint joinPoint) {
        Object[] objectArray = new Object[]{programTreeModel, mutableTreeNode, mutableTreeNode2, Conversions.intObject((int)n), joinPoint};
        ProgramTreeModel$AjcClosure1 programTreeModel$AjcClosure1 = new ProgramTreeModel$AjcClosure1(objectArray);
        try {
            ProgramExecutionStateAspect.aspectOf().aroundAnnotatedMethod(programTreeModel$AjcClosure1.linkStackClosureAndJoinPoint(69648));
            programTreeModel$AjcClosure1.unlink();
        }
        catch (Throwable throwable) {
            programTreeModel$AjcClosure1.unlink();
            throw throwable;
        }
    }

    static final /* synthetic */ void removeNodeFromParent_aroundBody4(ProgramTreeModel ajc$this, final MutableTreeNode node, JoinPoint joinPoint) {
        SwingUtil.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                ProgramTreeModel.this.uiRemoveNodeFromParent(node);
            }
        });
    }

    static final /* synthetic */ void removeNodeFromParent_aroundBody6(ProgramTreeModel programTreeModel, MutableTreeNode mutableTreeNode, JoinPoint joinPoint) {
        Object[] objectArray = new Object[]{programTreeModel, mutableTreeNode, joinPoint};
        ProgramTreeModel$AjcClosure5 programTreeModel$AjcClosure5 = new ProgramTreeModel$AjcClosure5(objectArray);
        try {
            ProgramExecutionStateAspect.aspectOf().aroundAnnotatedMethod(programTreeModel$AjcClosure5.linkStackClosureAndJoinPoint(69648));
            programTreeModel$AjcClosure5.unlink();
        }
        catch (Throwable throwable) {
            programTreeModel$AjcClosure5.unlink();
            throw throwable;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ProgramTreeModel.java", ProgramTreeModel.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "insertNodeInto", "gui.polyscope.program.ProgramTreeModel", "javax.swing.tree.MutableTreeNode:javax.swing.tree.MutableTreeNode:int", "newChild:parent:index", "", "void"), 59);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeNodeFromParent", "gui.polyscope.program.ProgramTreeModel", "javax.swing.tree.MutableTreeNode", "node", "", "void"), 122);
    }
}

