/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.program;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.immi.Immi;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.EditProgramService;
import com.ur.polyscope.program.nodes.ProgramSelectionModel;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.IgnoreProgramChanges;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.viewfacade.program.ProgramReadonlyService;
import com.ur.resources.ViewImageResource;
import com.ur.swing.CardPanel;
import com.ur.swing.SwingUtil;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.util.Optional;
import com.ur.view.polyscope.module.programs.ProgramContributionProvider;
import com.ur.view.polyscope.module.programs.ProgramModule;
import gui.installation.services.ProgramLookupService;
import gui.polyscope.program.InsertNodeStrategy;
import gui.polyscope.program.ProgramFactorySite;
import gui.polyscope.program.StructureTab$AjcClosure1;
import gui.polyscope.program.StructureTab$AjcClosure11;
import gui.polyscope.program.StructureTab$AjcClosure13;
import gui.polyscope.program.StructureTab$AjcClosure15;
import gui.polyscope.program.StructureTab$AjcClosure17;
import gui.polyscope.program.StructureTab$AjcClosure19;
import gui.polyscope.program.StructureTab$AjcClosure21;
import gui.polyscope.program.StructureTab$AjcClosure23;
import gui.polyscope.program.StructureTab$AjcClosure25;
import gui.polyscope.program.StructureTab$AjcClosure3;
import gui.polyscope.program.StructureTab$AjcClosure5;
import gui.polyscope.program.StructureTab$AjcClosure7;
import gui.polyscope.program.StructureTab$AjcClosure9;
import gui.program.AssignmentNode;
import gui.program.ContributableProgramNode;
import gui.program.EntityFactory;
import gui.program.MainProgram;
import gui.program.MoveNode;
import gui.program.ProgramRootNode;
import gui.program.StackNode;
import gui.program.TimerNode;
import gui.program.position.WaypointNode;
import gui.tools.DialogCreator;
import gui.tools.LegacyURDialogCreator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.MutableTreeNode;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Singleton
public class StructureTab
extends CardPanel
implements ProgramFactorySite {
    public static final String ADD_WAYPOINT = "structureTab.AddWaypoint";
    public static final String ADD_MOVE = "structureTab.AddMove";
    public static final String ADD_SET = "structureTab.AddSet";
    public static final String ADD_WAIT = "structureTab.AddWait";
    public static final String ADD_FOLDER = "structureTab.AddFolder";
    public static final String ADD_COMMENT = "structureTab.AddComment";
    public static final String ADD_HALT = "structureTab.AddHalt";
    public static final String ADD_POPUP = "structureTab.AddPopup";
    public static final String ADD_LOOP = "structureTab.AddLoop";
    public static final String ADD_SCRIPT_CODE = "structureTab.AddScriptCode";
    public static final String ADD_ASSIGNMENT = "structureTab.AddAssignment";
    public static final String ADD_SUB_PROGRAM = "structureTab.AddSubProgram";
    public static final String ADD_IF_ELSE = "structureTab.AddIfElse";
    public static final String ADD_EVENT = "structureTab.AddEvent";
    public static final String ADD_THREAD = "structureTab.AddThread";
    public static final String ADD_SWITCH = "structureTab.AddSwitch";
    public static final String ADD_TIMER = "structureTab.AddTimer";
    public static final String ADD_MOVE_DIRECTION = "structureTab.AddMoveDirection";
    public static final String ADD_PALLET = "structureTab.AddPallet";
    public static final String ADD_SEEK = "structureTab.AddSeek";
    public static final String ADD_FORCE = "structureTab.AddForce";
    public static final String ADD_E67_STARTUP_CHECK = "structureTab.E67.StartupCheck";
    public static final String ADD_E67_EJECTOR_BACK = "structureTab.E67.EjectorBack";
    public static final String ADD_E67_PULL_IN = "structureTab.E67.PullIn";
    public static final String ADD_E67_FREE_TO_MOULD = "structureTab.E67.FreeToMould";
    public static final String ADD_E67_WAIT_FOR_ITEM = "structureTab.E67.WaitForItem";
    public static final String ADD_E67_PULL_OUT = "structureTab.E67.PullOut";
    public static final String ADD_E67_EJECTOR_FORWARD = "structureTab.E67.EjectorForward";
    public static final String TABBED_PANEL;
    public static final String DELETE_NODE = "structureTab.delete";
    public static final String URCAPS_TAB = "structureTab.UrcapsTab";
    private final NamingService namingService;
    private final InstallationComponentLookup installationLookupService;
    private final EntityFactory entityFactory;
    private final ProgramReadonlyService programReadonlyService;
    private final EditProgramService editProgramService;
    private final DialogCreator dialogCreator;
    private final HelpIdAssigner helpIdAssigner;
    private final InsertNodeStrategy.BeforePlacementStrategy beforePlacementStrategy;
    private final InsertNodeStrategy.AfterPlacementStrategy afterPlacementStrategy;
    private ProgramLookupService lookupService;
    private TextResource textResource;
    private CommandNamesResource commandNamesResource;
    private JPanel euromap67TabReference = null;
    private List<Component> componentsDisabled = new ArrayList<Component>();
    private JPanel urcapsTab;
    private boolean urCapTabAdded;
    private JScrollPane urcapsTabScrollPane;
    private JButton assignmentButton;
    private JButton timerButton;
    private JButton commentButton;
    private JButton copyButton;
    private JButton cutButton;
    private JButton deleteButton;
    private JButton e67WaitForitemButton;
    private JButton ejectorBackButton;
    private JButton ejectorForwardButton;
    private JPanel euromap67Tab;
    private JButton eventButton;
    private JButton folderButton;
    private JButton freeToMouldButton;
    private JButton haltButton;
    private JButton ifButton;
    private JTabbedPane insertTabbedPanel;
    private JButton ioActionButton;
    private JButton loopButton;
    private JButton moveButton;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton palletButton;
    private JButton pasteButton;
    private JComboBox beforeOrAfterStrategy;
    private JButton popupButton;
    private JButton pullersBackButton;
    private JButton pullersForwardButton;
    private JButton scriptCodeButton;
    private JButton stackButton;
    private JButton startupCheckButton;
    private JButton subProgramButton;
    private JButton suppressButton;
    private JButton threadButton;
    private JLabel titleLabel;
    private JButton waitButton;
    private JButton waypointButton;
    private JPanel wizardsTab;
    private JButton moveDirectionButton;
    private JButton switchButton;
    private JButton forceButton;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;

    static {
        StructureTab.ajc$preClinit();
        TABBED_PANEL = String.valueOf(StructureTab.class.getName()) + ".tabbedPanel";
    }

    @Inject
    StructureTab(ProgramLookupService lookupService, NamingService namingService, InstallationComponentLookup installationLookupService, InsertNodeStrategy.BeforePlacementStrategy beforePlacementStrategy, InsertNodeStrategy.AfterPlacementStrategy afterPlacementStrategy, EntityFactory entityFactory, ProgramReadonlyService programReadonlyService, EditProgramService editProgramService, DialogCreator dialogCreator, HelpIdAssigner helpIdAssigner, ViewContext viewContext) {
        this.lookupService = lookupService;
        this.namingService = namingService;
        this.installationLookupService = installationLookupService;
        this.beforePlacementStrategy = beforePlacementStrategy;
        this.afterPlacementStrategy = afterPlacementStrategy;
        this.entityFactory = entityFactory;
        this.programReadonlyService = programReadonlyService;
        this.editProgramService = editProgramService;
        this.dialogCreator = dialogCreator;
        this.helpIdAssigner = helpIdAssigner;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.commandNamesResource = (CommandNamesResource)viewContext.getTextResource(CommandNamesResource.class);
        this.initComponents();
        this.assignHelpIds();
        this.euromap67TabReference = this.euromap67Tab;
        Optional euromap67 = installationLookupService.get(Immi.class);
        if (euromap67.isPresent() && !((Immi)euromap67.get()).isEnabled()) {
            this.insertTabbedPanel.remove(this.euromap67Tab);
            this.euromap67Tab = null;
        }
        this.assignHelpIds();
    }

    @Inject
    public void setProgramContributionProvider(ProgramContributionProvider provider) {
        provider.contributeToProgramFactory(this);
        this.fillAtleastFourRowsUrcaps();
    }

    @Override
    public void addProgramNodeFactory(final ProgramModule.ContributableProgramNodeFactory factory) {
        if (!factory.isDeprecated() && !factory.isNonUserInsertable()) {
            String title = factory.getTitle();
            JButton button = new JButton(title);
            button.setName(title);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContributableProgramNode programNode = factory.createNode();
                    if (programNode != null) {
                        if (programNode.getNodeType().isChildrenAllowed() && StructureTab.this.hasNoChildren(programNode)) {
                            programNode.add((MutableTreeNode)((Object)StructureTab.this.entityFactory.createPlaceholderNode()));
                        }
                        StructureTab.this.insertNode(programNode);
                    }
                }
            });
            if (factory.isThirdParty()) {
                if (!this.urCapTabAdded) {
                    this.insertTabbedPanel.insertTab(this.textResource.urcapsInstallationTabTitle(), null, this.urcapsTabScrollPane, "", 3);
                    this.urCapTabAdded = true;
                }
                Dimension size = new Dimension(200, 40);
                button.setPreferredSize(size);
                this.urcapsTab.add(button);
            } else {
                this.wizardsTab.add((Component)button, this.wizardsTab.getComponentCount() - 3);
            }
        }
    }

    private boolean hasNoChildren(AbstractProgramNode programNode) {
        return !programNode.children().hasMoreElements();
    }

    public void fillAtleastFourRowsUrcaps() {
        int i = this.urcapsTab.getComponentCount();
        while (i < 8) {
            JLabel comp = new JLabel();
            comp.setPreferredSize(new Dimension(200, 40));
            this.urcapsTab.add(comp);
            ++i;
        }
    }

    private DefaultComboBoxModel makeNewBeforeAfterComboBoxModel() {
        return new DefaultComboBoxModel<InsertNodeStrategy>(new InsertNodeStrategy[]{this.beforePlacementStrategy, this.afterPlacementStrategy});
    }

    public void enter(Object o) {
        super.enter(o);
        Optional euromap67 = this.installationLookupService.get(Immi.class);
        if (euromap67.isPresent() && ((Immi)euromap67.get()).isEnabled()) {
            if (this.euromap67Tab == null) {
                this.euromap67Tab = this.euromap67TabReference;
                this.insertTabbedPanel.addTab(this.textResource.euromap67Tab(), null, this.euromap67Tab, "");
                this.helpIdAssigner.assignHelpId((JComponent)this.euromap67Tab, "gui:euromap67_program_structures");
            }
        } else {
            this.insertTabbedPanel.remove(this.euromap67Tab);
            this.euromap67Tab = null;
        }
        if (this.programReadonlyService.isReadonly()) {
            SwingUtil.setEnabledRecursive((Container)((Object)this), (boolean)false, this.componentsDisabled, (String[])new String[0]);
        } else if (this.componentsDisabled.size() > 0) {
            SwingUtil.setEnabledComponents(this.componentsDisabled, (boolean)true);
            this.componentsDisabled.clear();
        }
    }

    String getActiveTab() {
        return this.insertTabbedPanel.getTitleAt(this.insertTabbedPanel.getSelectedIndex());
    }

    void setActiveTab(String name) {
        int i = 0;
        while (i < this.insertTabbedPanel.getTabCount()) {
            if (name.equals(this.insertTabbedPanel.getTitleAt(i))) {
                this.insertTabbedPanel.setSelectedIndex(i);
                break;
            }
            ++i;
        }
    }

    JScrollPane getURCapTabScrollPanel() {
        return this.urcapsTabScrollPane;
    }

    private void assignHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)this.titleLabel, "gui:structuretab");
        this.helpIdAssigner.assignHelpId((JComponent)this.moveUpButton, "gui:structuretab_cutcopypaste");
        this.helpIdAssigner.assignHelpId((JComponent)this.moveDownButton, "gui:structuretab_cutcopypaste");
        this.helpIdAssigner.assignHelpId((JComponent)this.copyButton, "gui:structuretab_cutcopypaste");
        this.helpIdAssigner.assignHelpId((JComponent)this.cutButton, "gui:structuretab_cutcopypaste");
        this.helpIdAssigner.assignHelpId((JComponent)this.deleteButton, "gui:structuretab_cutcopypaste");
        this.helpIdAssigner.assignHelpId((JComponent)this.assignmentButton, "gui:command_assignment");
        this.helpIdAssigner.assignHelpId((JComponent)this.commentButton, "gui:command_comment");
        this.helpIdAssigner.assignHelpId((JComponent)this.haltButton, "gui:command_halt");
        this.helpIdAssigner.assignHelpId((JComponent)this.ifButton, "gui:command_if_condition");
        this.helpIdAssigner.assignHelpId((JComponent)this.ioActionButton, "gui:command_action");
        this.helpIdAssigner.assignHelpId((JComponent)this.loopButton, "gui:command_loop");
        this.helpIdAssigner.assignHelpId((JComponent)this.moveButton, "gui:command_move");
        this.helpIdAssigner.assignHelpId((JComponent)this.pasteButton, "gui:structuretab_cutcopypaste");
        this.helpIdAssigner.assignHelpId((JComponent)this.popupButton, "gui:command_popup");
        this.helpIdAssigner.assignHelpId((JComponent)this.scriptCodeButton, "gui:command_script");
        this.helpIdAssigner.assignHelpId((JComponent)this.suppressButton, "gui:command_suppress");
        this.helpIdAssigner.assignHelpId((JComponent)this.waitButton, "gui:command_wait");
        this.helpIdAssigner.assignHelpId((JComponent)this.waypointButton, "gui:command_waypoint");
        this.helpIdAssigner.assignHelpId((JComponent)this.subProgramButton, "gui:command_subprog");
        this.helpIdAssigner.assignHelpId((JComponent)this.folderButton, "gui:command_folder");
        this.helpIdAssigner.assignHelpId((JComponent)this.threadButton, "gui:command_thread");
        this.helpIdAssigner.assignHelpId((JComponent)this.eventButton, "gui:command_event");
        this.helpIdAssigner.assignHelpId((JComponent)this.switchButton, "gui:command_switch_condition");
        this.helpIdAssigner.assignHelpId((JComponent)this.timerButton, "gui:command_timer");
        this.helpIdAssigner.assignHelpId((JComponent)this.forceButton, "gui:force_mode_overall");
        this.helpIdAssigner.assignHelpId((JComponent)this.stackButton, "gui:command_seek");
        this.helpIdAssigner.assignHelpId((JComponent)this.palletButton, "gui:command_pallet");
        this.helpIdAssigner.assignHelpId((JComponent)this.moveDirectionButton, "gui:command_direction");
        if (this.euromap67Tab != null) {
            this.helpIdAssigner.assignHelpId((JComponent)this.startupCheckButton, "gui:euromap67_startupCheck");
            this.helpIdAssigner.assignHelpId((JComponent)this.freeToMouldButton, "gui:euromap67_structure_freeToMould");
            this.helpIdAssigner.assignHelpId((JComponent)this.e67WaitForitemButton, "gui:euromap67_structure_waitForItem");
            this.helpIdAssigner.assignHelpId((JComponent)this.ejectorForwardButton, "gui:euromap67_structure_ejectorForward");
            this.helpIdAssigner.assignHelpId((JComponent)this.ejectorBackButton, "gui:euromap67_structure_ejectorBack");
            this.helpIdAssigner.assignHelpId((JComponent)this.pullersForwardButton, "gui:euromap67_structure_CorePullIn");
            this.helpIdAssigner.assignHelpId((JComponent)this.pullersBackButton, "gui:euromap67_structure_CorePullOut");
            this.helpIdAssigner.assignHelpId((JComponent)this.euromap67Tab, "gui:euromap67_program_structures");
        }
    }

    public String toString() {
        return "Structure";
    }

    public void insertNode(AbstractProgramNode newNode) {
        InsertNodeStrategy strategy = (InsertNodeStrategy)this.beforeOrAfterStrategy.getSelectedItem();
        if (strategy.equals(this.beforePlacementStrategy)) {
            this.editProgramService.insertNodeBefore(newNode, this.editProgramService.getSelected());
        } else {
            this.editProgramService.insertNodeAfter(newNode, this.editProgramService.getSelected());
        }
    }

    @CompoundProgramChange
    private void createAndInsertMoveNode() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        StructureTab$AjcClosure1 structureTab$AjcClosure1 = new StructureTab$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(structureTab$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @IgnoreProgramChanges
    private AbstractProgramNode createMoveNode() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        StructureTab$AjcClosure3 structureTab$AjcClosure3 = new StructureTab$AjcClosure3(objectArray);
        return (AbstractProgramNode)ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(structureTab$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @CompoundProgramChange
    private void createAndInsertWaypoint() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        StructureTab$AjcClosure5 structureTab$AjcClosure5 = new StructureTab$AjcClosure5(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(structureTab$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @IgnoreProgramChanges
    private AbstractProgramNode createWaypointNode() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        StructureTab$AjcClosure7 structureTab$AjcClosure7 = new StructureTab$AjcClosure7(objectArray);
        return (AbstractProgramNode)ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(structureTab$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @CompoundProgramChange
    public void suppressNode(AbstractProgramNode currentNode) {
        AbstractProgramNode abstractProgramNode = currentNode;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)abstractProgramNode);
        Object[] objectArray = new Object[]{this, abstractProgramNode, joinPoint};
        StructureTab$AjcClosure9 structureTab$AjcClosure9 = new StructureTab$AjcClosure9(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(structureTab$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    @CompoundProgramChange
    void cutToClipboard(AbstractProgramNode programNode) {
        AbstractProgramNode abstractProgramNode = programNode;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)abstractProgramNode);
        Object[] objectArray = new Object[]{this, abstractProgramNode, joinPoint};
        StructureTab$AjcClosure11 structureTab$AjcClosure11 = new StructureTab$AjcClosure11(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(structureTab$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    @CompoundProgramChange
    void moveSelectedNodeUp() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        StructureTab$AjcClosure13 structureTab$AjcClosure13 = new StructureTab$AjcClosure13(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(structureTab$AjcClosure13.linkClosureAndJoinPoint(69648));
    }

    @CompoundProgramChange
    void moveSelectedNodeDown() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        StructureTab$AjcClosure15 structureTab$AjcClosure15 = new StructureTab$AjcClosure15(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(structureTab$AjcClosure15.linkClosureAndJoinPoint(69648));
    }

    @IgnoreProgramChanges
    void copyToClipboard(AbstractProgramNode programNode) {
        AbstractProgramNode abstractProgramNode = programNode;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)abstractProgramNode);
        Object[] objectArray = new Object[]{this, abstractProgramNode, joinPoint};
        StructureTab$AjcClosure17 structureTab$AjcClosure17 = new StructureTab$AjcClosure17(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(structureTab$AjcClosure17.linkClosureAndJoinPoint(69648));
    }

    private ProgramRootNode getProgram() {
        return this.lookupService.getProgramRootNode();
    }

    @IgnoreProgramChanges
    private AssignmentNode createAssignmentNodeWithVariable() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        StructureTab$AjcClosure19 structureTab$AjcClosure19 = new StructureTab$AjcClosure19(objectArray);
        return (AssignmentNode)ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(structureTab$AjcClosure19.linkClosureAndJoinPoint(69648));
    }

    @IgnoreProgramChanges
    private TimerNode createTimerNodeWithVariable() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        StructureTab$AjcClosure21 structureTab$AjcClosure21 = new StructureTab$AjcClosure21(objectArray);
        return (TimerNode)ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(structureTab$AjcClosure21.linkClosureAndJoinPoint(69648));
    }

    @IgnoreProgramChanges
    private StackNode createStackNodeWithVariable() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        StructureTab$AjcClosure23 structureTab$AjcClosure23 = new StructureTab$AjcClosure23(objectArray);
        return (StackNode)ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(structureTab$AjcClosure23.linkClosureAndJoinPoint(69648));
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        this.titleLabel = new JLabel();
        JPanel jPanel8 = new JPanel();
        this.startupCheckButton = new JButton();
        this.e67WaitForitemButton = new JButton();
        this.ejectorBackButton = new JButton();
        this.ejectorForwardButton = new JButton();
        this.pullersBackButton = new JButton();
        this.pullersForwardButton = new JButton();
        this.freeToMouldButton = new JButton();
        this.setLayout(new BorderLayout());
        jPanel1.setLayout(new FlowLayout(0, 10, 10));
        this.titleLabel.setText(this.textResource.programStructureEditorTitle());
        jPanel1.add(this.titleLabel);
        this.add(jPanel1, "North");
        jPanel8.setLayout(null);
        this.add(jPanel8, "Center");
        JLabel lblInsert = new JLabel(this.textResource.Insert());
        lblInsert.setBounds(12, 45, 133, 15);
        jPanel8.add(lblInsert);
        JLabel lblEdit = new JLabel(this.textResource.Edit());
        lblEdit.setBounds(12, 330, 119, 15);
        jPanel8.add(lblEdit);
        this.moveUpButton = new JButton();
        this.moveUpButton.setBounds(30, 350, 133, 26);
        this.moveUpButton.setMargin(new Insets(2, 5, 2, 5));
        jPanel8.add(this.moveUpButton);
        this.moveUpButton.setIcon(ViewImageResource.gtkGoUp());
        this.moveUpButton.setText(this.textResource.Move());
        this.moveDownButton = new JButton();
        this.moveDownButton.setMargin(new Insets(2, 5, 2, 5));
        this.moveDownButton.setBounds(30, 388, 133, 26);
        jPanel8.add(this.moveDownButton);
        this.moveDownButton.setIcon(ViewImageResource.gtkGoDown());
        this.moveDownButton.setText(this.textResource.Move());
        this.copyButton = new JButton();
        this.copyButton.setBounds(180, 350, 133, 26);
        jPanel8.add(this.copyButton);
        this.copyButton.setText(this.textResource.Copy());
        this.cutButton = new JButton();
        this.cutButton.setBounds(180, 388, 133, 26);
        jPanel8.add(this.cutButton);
        this.cutButton.setText(this.textResource.Cut());
        this.pasteButton = new JButton();
        this.pasteButton.setBounds(320, 350, 133, 26);
        jPanel8.add(this.pasteButton);
        this.pasteButton.setText(this.textResource.Paste());
        this.deleteButton = new JButton();
        this.deleteButton.setBounds(320, 388, 133, 26);
        this.deleteButton.setName(DELETE_NODE);
        this.deleteButton.setText(this.textResource.Delete());
        jPanel8.add(this.deleteButton);
        this.suppressButton = new JButton();
        this.suppressButton.setBounds(467, 350, 133, 26);
        jPanel8.add(this.suppressButton);
        this.suppressButton.setText(this.textResource.Suppress());
        this.insertTabbedPanel = new JTabbedPane();
        this.insertTabbedPanel.setBounds(30, 63, 550, 247);
        this.insertTabbedPanel.setName(TABBED_PANEL);
        jPanel8.add(this.insertTabbedPanel);
        this.moveButton = new JButton();
        this.waypointButton = new JButton();
        this.waitButton = new JButton();
        this.ioActionButton = new JButton();
        this.popupButton = new JButton();
        this.haltButton = new JButton();
        this.commentButton = new JButton();
        this.folderButton = new JButton();
        this.loopButton = new JButton();
        this.subProgramButton = new JButton();
        this.assignmentButton = new JButton();
        this.ifButton = new JButton();
        this.scriptCodeButton = new JButton();
        this.eventButton = new JButton();
        this.threadButton = new JButton();
        this.timerButton = new JButton();
        this.palletButton = new JButton();
        this.stackButton = new JButton();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel10 = new JPanel();
        JPanel basicTab = new JPanel();
        basicTab.setBorder(new EmptyBorder(10, 10, 10, 10));
        basicTab.setLayout(new GridLayout(4, 2, 10, 10));
        JPanel advancedTab = new JPanel();
        advancedTab.setBorder(new EmptyBorder(10, 10, 10, 10));
        advancedTab.setLayout(new GridLayout(4, 2, 10, 10));
        this.wizardsTab = new JPanel();
        this.wizardsTab.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.wizardsTab.setLayout(new GridLayout(4, 2, 10, 10));
        this.euromap67Tab = new JPanel();
        this.euromap67Tab.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.euromap67Tab.setLayout(new GridLayout(4, 2, 10, 10));
        this.urcapsTab = new JPanel();
        this.urcapsTab.setName(URCAPS_TAB);
        this.urcapsTab.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.urcapsTab.setLayout(new GridLayout(0, 2, 10, 10));
        this.urcapsTabScrollPane = new JScrollPane(this.urcapsTab, 20, 31);
        this.urcapsTabScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.insertTabbedPanel.setPreferredSize(new Dimension(382, 238));
        this.insertTabbedPanel.addTab(this.textResource.basicTab(), basicTab);
        this.insertTabbedPanel.addTab(this.textResource.advancedTab(), advancedTab);
        this.insertTabbedPanel.addTab(this.textResource.wizardsTab(), this.wizardsTab);
        Optional euromap67 = this.installationLookupService.get(Immi.class);
        if (euromap67.isPresent() && ((Immi)euromap67.get()).isEnabled()) {
            this.insertTabbedPanel.addTab(this.textResource.euromap67Tab(), this.euromap67Tab);
        }
        this.moveButton.setText(this.commandNamesResource.Move());
        this.moveButton.setName(ADD_MOVE);
        this.moveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.createAndInsertMoveNode();
            }
        });
        basicTab.add(this.moveButton);
        this.waypointButton.setText(this.commandNamesResource.Waypoint());
        this.waypointButton.setName(ADD_WAYPOINT);
        this.waypointButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.createAndInsertWaypoint();
            }
        });
        basicTab.add(this.waypointButton);
        this.waitButton.setText(this.commandNamesResource.Wait());
        this.waitButton.setName(ADD_WAIT);
        this.waitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.insertNode(StructureTab.this.entityFactory.createWaitNode());
            }
        });
        basicTab.add(this.waitButton);
        this.ioActionButton.setText(this.commandNamesResource.iOAction());
        this.ioActionButton.setName(ADD_SET);
        this.ioActionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.ioActionButtonActionPerformed();
            }
        });
        basicTab.add(this.ioActionButton);
        this.popupButton.setText(this.commandNamesResource.Popup());
        this.popupButton.setName(ADD_POPUP);
        this.popupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.popupButtonActionPerformed();
            }
        });
        basicTab.add(this.popupButton);
        this.haltButton.setText(this.commandNamesResource.Halt());
        this.haltButton.setName(ADD_HALT);
        this.haltButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.haltButtonActionPerformed();
            }
        });
        basicTab.add(this.haltButton);
        this.commentButton.setText(this.commandNamesResource.Comment());
        this.commentButton.setName(ADD_COMMENT);
        this.commentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.commentButtonActionPerformed();
            }
        });
        basicTab.add(this.commentButton);
        this.folderButton.setText(this.commandNamesResource.Folder());
        this.folderButton.setName(ADD_FOLDER);
        this.folderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.folderButtonActionPerformed();
            }
        });
        basicTab.add(this.folderButton);
        this.loopButton.setText(this.commandNamesResource.Loop());
        this.loopButton.setName(ADD_LOOP);
        this.loopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.loopButtonActionPerformed();
            }
        });
        advancedTab.add(this.loopButton);
        this.subProgramButton.setText(this.commandNamesResource.SubProg());
        this.subProgramButton.setName(ADD_SUB_PROGRAM);
        this.subProgramButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.subProgramButtonActionPerformed();
            }
        });
        advancedTab.add(this.subProgramButton);
        this.assignmentButton.setText(this.commandNamesResource.Assignment());
        this.assignmentButton.setName(ADD_ASSIGNMENT);
        this.assignmentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.assignmentButtonActionPerformed();
            }
        });
        advancedTab.add(this.assignmentButton);
        this.ifButton.setText(this.commandNamesResource.ifElse());
        this.ifButton.setName(ADD_IF_ELSE);
        this.ifButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.ifButtonActionPerformed();
            }
        });
        advancedTab.add(this.ifButton);
        this.scriptCodeButton.setText(this.commandNamesResource.scriptCode());
        this.scriptCodeButton.setName(ADD_SCRIPT_CODE);
        this.scriptCodeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.insertNode(StructureTab.this.entityFactory.createScriptNode());
            }
        });
        advancedTab.add(this.scriptCodeButton);
        this.eventButton.setText(this.commandNamesResource.Event());
        this.eventButton.setName(ADD_EVENT);
        this.eventButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.eventButtonActionPerformed();
            }
        });
        advancedTab.add(this.eventButton);
        this.threadButton.setText(this.commandNamesResource.Thread());
        this.threadButton.setName(ADD_THREAD);
        this.threadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.threadButtonActionPerformed();
            }
        });
        advancedTab.add(this.threadButton);
        this.timerButton.setText(this.commandNamesResource.Timer());
        this.timerButton.setName(ADD_TIMER);
        this.timerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.timerButtonActionPerformed();
            }
        });
        advancedTab.add(this.timerButton);
        this.switchButton = new JButton(this.commandNamesResource.Switch());
        this.switchButton.setName(ADD_SWITCH);
        this.switchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StructureTab.this.insertNode(StructureTab.this.entityFactory.createSwitch());
            }
        });
        advancedTab.add(this.switchButton);
        this.moveDirectionButton = new JButton(this.commandNamesResource.Direction());
        this.moveDirectionButton.setName(ADD_MOVE_DIRECTION);
        this.moveDirectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StructureTab.this.insertNode(StructureTab.this.entityFactory.createMoveDirectionNode());
            }
        });
        advancedTab.add(this.moveDirectionButton);
        this.palletButton.setText(this.commandNamesResource.Pallet());
        this.palletButton.setName(ADD_PALLET);
        this.palletButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.palletButtonActionPerformed();
            }
        });
        this.wizardsTab.add(this.palletButton);
        this.stackButton.setText(this.commandNamesResource.Seek());
        this.stackButton.setName(ADD_SEEK);
        this.stackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.stackButtonActionPerformed();
            }
        });
        this.wizardsTab.add(this.stackButton);
        this.forceButton = new JButton();
        this.forceButton.setText(this.commandNamesResource.Force());
        this.forceButton.setName(ADD_FORCE);
        this.forceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.forceButtonActionPerformed();
            }
        });
        this.wizardsTab.add(this.forceButton);
        this.wizardsTab.add(jPanel9);
        this.wizardsTab.add(jPanel5);
        this.wizardsTab.add(jPanel10);
        this.startupCheckButton.setText(this.commandNamesResource.e67StartupCheck());
        this.startupCheckButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.startupCheckButtonActionPerformed();
            }
        });
        this.startupCheckButton.setName(ADD_E67_STARTUP_CHECK);
        this.euromap67Tab.add(this.startupCheckButton);
        this.e67WaitForitemButton.setText(this.commandNamesResource.e67WaitForItem());
        this.e67WaitForitemButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.e67WaitForitemButtonActionPerformed();
            }
        });
        this.e67WaitForitemButton.setName(ADD_E67_WAIT_FOR_ITEM);
        this.euromap67Tab.add(this.e67WaitForitemButton);
        this.ejectorBackButton.setText(this.commandNamesResource.e67EjectorBack());
        this.ejectorBackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.ejectorBackButtonActionPerformed();
            }
        });
        this.ejectorBackButton.setName(ADD_E67_EJECTOR_BACK);
        this.euromap67Tab.add(this.ejectorBackButton);
        this.ejectorForwardButton.setText(this.commandNamesResource.e67EjectorForward());
        this.ejectorForwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.ejectorForwardButtonActionPerformed();
            }
        });
        this.ejectorForwardButton.setName(ADD_E67_EJECTOR_FORWARD);
        this.euromap67Tab.add(this.ejectorForwardButton);
        this.pullersBackButton.setText(this.commandNamesResource.e67CorePullIn());
        this.pullersBackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.pullersBackButtonActionPerformed();
            }
        });
        this.pullersBackButton.setName(ADD_E67_PULL_IN);
        this.euromap67Tab.add(this.pullersBackButton);
        this.pullersForwardButton.setText(this.commandNamesResource.e67CorePullOut());
        this.pullersForwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.pullersForwardButtonActionPerformed();
            }
        });
        this.pullersForwardButton.setName(ADD_E67_PULL_OUT);
        this.euromap67Tab.add(this.pullersForwardButton);
        this.freeToMouldButton.setText(this.commandNamesResource.e67FreeToMould());
        this.freeToMouldButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.freeToMouldButtonActionPerformed();
            }
        });
        this.freeToMouldButton.setName(ADD_E67_FREE_TO_MOULD);
        this.euromap67Tab.add(this.freeToMouldButton);
        JPanel panel = new JPanel();
        panel.setBounds(12, 9, 611, 42);
        jPanel8.add(panel);
        panel.setLayout(new FlowLayout(0, 0, 5));
        JLabel setPlacementOfNode = new JLabel(this.textResource.setPlacementOfNode());
        panel.add(setPlacementOfNode);
        this.beforeOrAfterStrategy = new JComboBox();
        panel.add(this.beforeOrAfterStrategy);
        this.beforeOrAfterStrategy.setModel(this.makeNewBeforeAfterComboBoxModel());
        this.beforeOrAfterStrategy.setBorder(new EmptyBorder(0, 10, 0, 5));
        this.beforeOrAfterStrategy.setSelectedIndex(this.beforeOrAfterStrategy.getItemCount() - 1);
        this.suppressButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.suppressButtonActionPerformed();
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.deleteButtonActionPerformed();
            }
        });
        this.pasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.pasteButtonActionPerformed();
            }
        });
        this.cutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.cutButtonActionPerformed();
            }
        });
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.copyButtonActionPerformed();
            }
        });
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.moveDownButtonActionPerformed();
            }
        });
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureTab.this.moveUpButtonActionPerformed();
            }
        });
    }

    private void commentButtonActionPerformed() {
        this.insertNode(this.entityFactory.createCommentNode());
    }

    private void haltButtonActionPerformed() {
        this.insertNode(this.entityFactory.createHaltNode());
    }

    private void loopButtonActionPerformed() {
        this.insertNode(this.entityFactory.createLoopNode());
    }

    @CompoundProgramChange
    void pasteButtonActionPerformed() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        StructureTab$AjcClosure25 structureTab$AjcClosure25 = new StructureTab$AjcClosure25(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(structureTab$AjcClosure25.linkClosureAndJoinPoint(69648));
    }

    private void suppressButtonActionPerformed() {
        this.suppressNode(this.editProgramService.getSelected());
    }

    private void cutButtonActionPerformed() {
        AbstractProgramNode currentNode = this.getProgram().getComponent(ProgramSelectionModel.class).getCurrentNode();
        this.cutToClipboard(currentNode);
    }

    private void moveUpButtonActionPerformed() {
        this.moveSelectedNodeUp();
    }

    private void moveDownButtonActionPerformed() {
        this.moveSelectedNodeDown();
    }

    private void deleteButtonActionPerformed() {
        if (this.getProgram().getComponent(ProgramSelectionModel.class).getCurrentNode() instanceof MainProgram) {
            LegacyURDialogCreator.showErrorDialog(this.textResource.Delete(), this.textResource.youCannotDeleteTheMainProgram(), "");
        } else {
            this.editProgramService.deleteNode(this.editProgramService.getSelected());
        }
    }

    private void ioActionButtonActionPerformed() {
        this.insertNode(this.entityFactory.createSetNode());
    }

    private void popupButtonActionPerformed() {
        this.insertNode(this.entityFactory.createPopupNode());
    }

    private void copyButtonActionPerformed() {
        this.copyToClipboard(this.getProgram().getComponent(ProgramSelectionModel.class).getCurrentNode());
    }

    private void subProgramButtonActionPerformed() {
        AbstractProgramNode pn = this.getProgram().getComponent(ProgramSelectionModel.class).getCurrentNode();
        if (pn.getParent() == ProgramRootNode.get(pn)) {
            this.insertNode(this.entityFactory.createSubProgramNode());
        } else {
            this.insertNode(this.entityFactory.createCallSubProgramNode());
        }
    }

    private void ifButtonActionPerformed() {
        this.insertNode(this.entityFactory.createIfNode());
    }

    private void assignmentButtonActionPerformed() {
        this.insertNode(this.createAssignmentNodeWithVariable());
    }

    private void timerButtonActionPerformed() {
        this.insertNode(this.createTimerNodeWithVariable());
    }

    private void folderButtonActionPerformed() {
        this.insertNode(this.entityFactory.createFolderNode());
    }

    private void threadButtonActionPerformed() {
        this.insertNode(this.entityFactory.createThreadNode());
    }

    private void eventButtonActionPerformed() {
        this.insertNode(this.entityFactory.createEventNode());
    }

    private void palletButtonActionPerformed() {
        this.insertNode(this.entityFactory.createPalletNode());
    }

    private void stackButtonActionPerformed() {
        this.insertNode(this.createStackNodeWithVariable());
    }

    private void forceButtonActionPerformed() {
        this.insertNode(this.entityFactory.createForceNode());
    }

    private void e67WaitForitemButtonActionPerformed() {
        this.insertNode((AbstractProgramNode)this.entityFactory.createWaitForItemNode());
    }

    private void freeToMouldButtonActionPerformed() {
        this.insertNode((AbstractProgramNode)this.entityFactory.createFreeToMouldNode());
    }

    private void ejectorBackButtonActionPerformed() {
        this.insertNode((AbstractProgramNode)this.entityFactory.createEjectorBackNode());
    }

    private void ejectorForwardButtonActionPerformed() {
        this.insertNode((AbstractProgramNode)this.entityFactory.createEjectorForwardNode());
    }

    private void pullersBackButtonActionPerformed() {
        this.insertNode((AbstractProgramNode)this.entityFactory.createCorePullersInNode());
    }

    private void pullersForwardButtonActionPerformed() {
        this.insertNode((AbstractProgramNode)this.entityFactory.createCorePullersOutNode());
    }

    private void startupCheckButtonActionPerformed() {
        this.insertNode((AbstractProgramNode)this.entityFactory.createStartupCheckNode());
    }

    static final /* synthetic */ void createAndInsertMoveNode_aroundBody0(StructureTab ajc$this, JoinPoint joinPoint) {
        AbstractProgramNode node = ajc$this.createMoveNode();
        ajc$this.insertNode(node);
    }

    static final /* synthetic */ AbstractProgramNode createMoveNode_aroundBody2(StructureTab ajc$this, JoinPoint joinPoint) {
        MoveNode node = ajc$this.entityFactory.createMoveNode();
        WaypointNode wpNode = (WaypointNode)((Object)node.getChildAt(0));
        wpNode.setName(ajc$this.namingService.makeUniqueName(WaypointNode.class, WaypointNode.DEFAULT_NAME));
        return node;
    }

    static final /* synthetic */ void createAndInsertWaypoint_aroundBody4(StructureTab ajc$this, JoinPoint joinPoint) {
        AbstractProgramNode node = ajc$this.createWaypointNode();
        ajc$this.insertNode(node);
    }

    static final /* synthetic */ AbstractProgramNode createWaypointNode_aroundBody6(StructureTab ajc$this, JoinPoint joinPoint) {
        WaypointNode node = ajc$this.entityFactory.createWaypointNode();
        node.setName(ajc$this.namingService.makeUniqueName(WaypointNode.class, WaypointNode.DEFAULT_NAME));
        return node;
    }

    static final /* synthetic */ void suppressNode_aroundBody8(StructureTab ajc$this, AbstractProgramNode currentNode, JoinPoint joinPoint) {
        if (currentNode.isSuppressible()) {
            ajc$this.editProgramService.suppressNode(currentNode);
        } else {
            ajc$this.dialogCreator.showErrorDialog(new ErrorMessage(ajc$this.textResource.Suppress(), ajc$this.textResource.CannotSuppressNode()), null);
        }
    }

    static final /* synthetic */ void cutToClipboard_aroundBody10(StructureTab ajc$this, AbstractProgramNode programNode, JoinPoint joinPoint) {
        ajc$this.editProgramService.cutToClipboard(programNode);
    }

    static final /* synthetic */ void moveSelectedNodeUp_aroundBody12(StructureTab ajc$this, JoinPoint joinPoint) {
        ajc$this.editProgramService.moveNodeUp(ajc$this.editProgramService.getSelected());
    }

    static final /* synthetic */ void moveSelectedNodeDown_aroundBody14(StructureTab ajc$this, JoinPoint joinPoint) {
        ajc$this.editProgramService.moveNodeDown(ajc$this.editProgramService.getSelected());
    }

    static final /* synthetic */ void copyToClipboard_aroundBody16(StructureTab ajc$this, AbstractProgramNode programNode, JoinPoint joinPoint) {
        ajc$this.editProgramService.copyToClipboard(programNode);
    }

    static final /* synthetic */ AssignmentNode createAssignmentNodeWithVariable_aroundBody18(StructureTab ajc$this, JoinPoint joinPoint) {
        AssignmentNode result = ajc$this.entityFactory.createAssignmentNode();
        result.setVariableWithoutChangeNotification(ajc$this.entityFactory.createVariable());
        return result;
    }

    static final /* synthetic */ TimerNode createTimerNodeWithVariable_aroundBody20(StructureTab ajc$this, JoinPoint joinPoint) {
        TimerNode timerNode = ajc$this.entityFactory.createTimerNode();
        timerNode.setVariableWithoutChangeNotification(ajc$this.entityFactory.createTimerVariable());
        return timerNode;
    }

    static final /* synthetic */ StackNode createStackNodeWithVariable_aroundBody22(StructureTab ajc$this, JoinPoint joinPoint) {
        StackNode result = ajc$this.entityFactory.createStackNode();
        result.setFoundPoseVariable(ajc$this.entityFactory.createPoseVariable());
        return result;
    }

    static final /* synthetic */ void pasteButtonActionPerformed_aroundBody24(StructureTab ajc$this, JoinPoint joinPoint) {
        InsertNodeStrategy initialStrategy = (InsertNodeStrategy)ajc$this.beforeOrAfterStrategy.getSelectedItem();
        if (initialStrategy.equals(ajc$this.beforePlacementStrategy)) {
            ajc$this.editProgramService.pasteNodeBefore(ajc$this.editProgramService.getSelected());
        } else {
            ajc$this.editProgramService.pasteNodeAfter(ajc$this.editProgramService.getSelected());
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("StructureTab.java", StructureTab.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createAndInsertMoveNode", "gui.polyscope.program.StructureTab", "", "", "", "void"), 354);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createMoveNode", "gui.polyscope.program.StructureTab", "", "", "", "com.ur.polyscope.program.nodes.AbstractProgramNode"), 360);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createTimerNodeWithVariable", "gui.polyscope.program.StructureTab", "", "", "", "gui.program.TimerNode"), 422);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createStackNodeWithVariable", "gui.polyscope.program.StructureTab", "", "", "", "gui.program.StackNode"), 429);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "pasteButtonActionPerformed", "gui.polyscope.program.StructureTab", "", "", "", "void"), 926);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createAndInsertWaypoint", "gui.polyscope.program.StructureTab", "", "", "", "void"), 368);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createWaypointNode", "gui.polyscope.program.StructureTab", "", "", "", "com.ur.polyscope.program.nodes.AbstractProgramNode"), 374);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "suppressNode", "gui.polyscope.program.StructureTab", "com.ur.polyscope.program.nodes.AbstractProgramNode", "currentNode", "", "void"), 381);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "cutToClipboard", "gui.polyscope.program.StructureTab", "com.ur.polyscope.program.nodes.AbstractProgramNode", "programNode", "", "void"), 391);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "moveSelectedNodeUp", "gui.polyscope.program.StructureTab", "", "", "", "void"), 396);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "moveSelectedNodeDown", "gui.polyscope.program.StructureTab", "", "", "", "void"), 401);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "copyToClipboard", "gui.polyscope.program.StructureTab", "com.ur.polyscope.program.nodes.AbstractProgramNode", "programNode", "", "void"), 406);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createAssignmentNodeWithVariable", "gui.polyscope.program.StructureTab", "", "", "", "gui.program.AssignmentNode"), 415);
    }
}

