/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.program.linenumbers;

import com.ur.swing.SwingUtil;
import com.ur.util.logging.Log;
import com.ur.view.program.linenumbers.BreakPointModel;
import com.ur.view.program.linenumbers.LineNumberModel;
import gui.polyscope.program.linenumbers.LineNumbersCache;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class LineNumberComponent
extends JComponent {
    public static final String COMPONENT_NAME = String.valueOf(LineNumberComponent.class.getName()) + "LineNumberComponent";
    private static final int HORIZONTAL_PADDING = 10;
    private static final int VERTICAL_PADDING = 3;
    private LineNumberModel lineNumberModel;
    private BreakPointModel breakPointModel;
    private boolean initialized;
    final LineNumbersCache lineNumbersCache;

    public LineNumberComponent(LineNumberModel lineNumberModel, BreakPointModel breakPointModel) {
        this.lineNumberModel = lineNumberModel;
        this.breakPointModel = breakPointModel;
        this.lineNumbersCache = new LineNumbersCache(lineNumberModel);
    }

    public LineNumberComponent(LineNumberModel lineNumberModel) {
        this(lineNumberModel, new BreakPointModel.Template());
    }

    public LineNumberComponent initComponent() {
        this.setName(COMPONENT_NAME);
        if (this.initialized) {
            return this;
        }
        this.initialized = true;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LineNumberComponent.this.onMouseClicked(e.getPoint());
            }
        });
        return this;
    }

    void onMouseClicked(Point point) {
        block2: {
            int lineIndex = this.getLineIndex(point);
            try {
                this.trySetBreakPoint(this.lineNumbersCache.getProgramLine(lineIndex));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (!Log.canLog((Log.Level)Log.Level.TRACE)) break block2;
                Log.trace((String)("Setting breakpoint on invalid line " + lineIndex));
            }
        }
    }

    private int getLineIndex(Point point) {
        int lineIndex = 0;
        while (lineIndex < this.lineNumberModel.getVisibleNumLines() && this.lineNumberModel.getLineStart((int)lineIndex).y <= point.y) {
            ++lineIndex;
        }
        Rectangle temp = this.lineNumberModel.getLineStart(lineIndex - 1);
        if (temp == null || temp.y + temp.height < point.y) {
            return -1;
        }
        return --lineIndex;
    }

    public void clickOnLineNumber(int lineNumber) {
        this.trySetBreakPoint(lineNumber);
    }

    private void trySetBreakPoint(int programLineNumber) {
        if (this.breakPointModel.canSetBreakPoint(programLineNumber)) {
            this.breakPointModel.setBreakpoint(programLineNumber, !this.breakPointModel.hasBreakpoint(programLineNumber));
            this.repaint();
        }
    }

    public void update() {
        this.lineNumbersCache.requestRebuild();
        this.repaint();
    }

    public void setBreakPointModel(BreakPointModel model) {
        this.breakPointModel = model != null ? model : new BreakPointModel.Template();
    }

    private JViewport getViewPort() {
        return (JViewport)SwingUtil.getContainerOfType(JViewport.class, (Component)this);
    }

    private void adjustSize() {
        int height;
        if (this.getGraphics() == null) {
            return;
        }
        if (this.getViewPort() == null) {
            return;
        }
        String measureWidthFor = String.valueOf(Math.max(this.lineNumbersCache.getProgramLinesCount(), 99));
        int width = this.getGraphics().getFontMetrics().stringWidth(measureWidthFor) + 20;
        if (!this.hasPreferredSize(width, height = this.getPreferredHeight())) {
            this.setPreferredSize(new Dimension(width, height));
            this.revalidate();
        }
    }

    private int getPreferredHeight() {
        JViewport view = this.getViewPort();
        Dimension dimension = view.getPreferredSize();
        Container parent = view.getParent();
        if (parent instanceof JScrollPane) {
            JScrollPane scroller = (JScrollPane)view.getParent();
            dimension = scroller.getViewport().getView().getPreferredSize();
        }
        return dimension.height;
    }

    private boolean hasPreferredSize(int width, int height) {
        return width == this.getPreferredSize().width && height == this.getPreferredSize().height;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.lineNumberModel == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.getBackground());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.getForeground());
        this.adjustSize();
        int textHeight = g.getFontMetrics().getHeight();
        int totalLength = (int)Math.max(Math.log10(this.lineNumbersCache.getProgramLinesCount()) + 1.0, 2.0);
        JViewport view = this.getViewPort();
        int[] programLineNumbers = this.lineNumbersCache.getProgramLines();
        int noOfLines = programLineNumbers.length;
        int index = 0;
        while (index < noOfLines) {
            int currentLineNumber = programLineNumbers[index];
            Rectangle rect = this.lineNumberModel.getLineStart(index);
            if (view != null && rect != null && this.isLineRectInViewportYspace(view, rect)) {
                int yPosition;
                int xPosition;
                boolean canSetBreakpoint = this.breakPointModel.canSetBreakPoint(currentLineNumber);
                if (!canSetBreakpoint) {
                    Color defaultColor = g.getColor();
                    g.setColor(new Color(230, 230, 230));
                    g2d.fillRect(0, rect.y, this.getWidth(), rect.height);
                    g.setColor(defaultColor);
                }
                if (canSetBreakpoint && this.breakPointModel.hasBreakpoint(currentLineNumber)) {
                    Image breakpointIcon = this.breakPointModel.getBreakPointImage(currentLineNumber);
                    xPosition = this.getPreferredSize().width / 2 - breakpointIcon.getWidth(null) / 2;
                    yPosition = rect.y + 3;
                    g2d.drawImage(breakpointIcon, xPosition, yPosition, this);
                } else {
                    String text = this.getAlignedNumberString(String.valueOf(currentLineNumber), totalLength);
                    xPosition = this.getPreferredSize().width / 2 - g.getFontMetrics().stringWidth(text) / 2;
                    yPosition = rect.y + (rect.height + textHeight) / 2 - 3;
                    g2d.drawString(text, xPosition, yPosition);
                }
            }
            ++index;
        }
    }

    private boolean isWithinBounds(double value, double lowerBound, double upperBound) {
        return value >= lowerBound && value <= upperBound;
    }

    private boolean isLineRectInViewportYspace(JViewport view, Rectangle lineRect) {
        Rectangle viewRect = view.getViewRect();
        return this.isWithinBounds(lineRect.getY(), viewRect.getY(), viewRect.getY() + viewRect.getHeight()) || this.isWithinBounds(lineRect.getY() + lineRect.getHeight(), viewRect.getY(), viewRect.getY() + viewRect.getHeight());
    }

    private String getAlignedNumberString(String text, int length) {
        int numOfSpaces = length - text.length();
        StringBuilder prefixedText = new StringBuilder();
        int i = 0;
        while (i < numOfSpaces) {
            prefixedText.append(" ");
            ++i;
        }
        prefixedText.append(text);
        return prefixedText.toString();
    }
}

