/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.program.linenumbers;

import com.ur.view.program.linenumbers.LineNumberModel;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

class LineNumbersCache {
    private final LineNumberModel lineNumberModel;
    private int maxLineCount = -1;
    private int[] lineLabelsCache;
    private AtomicBoolean lineNumberCacheInvalid = new AtomicBoolean(true);

    LineNumbersCache(LineNumberModel lineNumberModel) {
        this.lineNumberModel = lineNumberModel;
    }

    int getProgramLinesCount() {
        this.rebuildCache();
        return this.maxLineCount;
    }

    int[] getProgramLines() {
        this.rebuildCache();
        return Arrays.copyOf(this.lineLabelsCache, this.lineLabelsCache.length);
    }

    int getProgramLine(int displayedLineNumber) {
        this.rebuildCache();
        return this.lineLabelsCache[displayedLineNumber];
    }

    void requestRebuild() {
        this.lineNumberCacheInvalid.set(true);
    }

    private void rebuildCache() {
        if (this.lineNumberCacheInvalid.getAndSet(false)) {
            this.cacheLineNumbers();
        }
    }

    private void cacheLineNumbers() {
        int noOfVisibleRows = this.lineNumberModel.getVisibleNumLines();
        int lineNoToDisplay = 1;
        if (this.lineLabelsCache == null || this.lineLabelsCache.length != noOfVisibleRows) {
            this.lineLabelsCache = new int[noOfVisibleRows];
        }
        int i = 0;
        while (i < noOfVisibleRows) {
            this.lineLabelsCache[i] = lineNoToDisplay;
            int count = this.lineNumberModel.getNumOfCollapsedLinesAtLine(i);
            lineNoToDisplay += count + 1;
            ++i;
        }
        this.maxLineCount = lineNoToDisplay - 1;
    }
}

