/*
 * Decompiled with CFR 0.152.
 */
package gui.polyscope.program.rules.insertion;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.rules.ProgramNodeInsertionRule;
import gui.program.SpecialSequenceNode;
import gui.program.WithBeforeAndAfter;
import gui.tools.LanguagePack;

public class BeforePointAndAfterEndNodeCannotMoveRule
implements ProgramNodeInsertionRule {
    public boolean canInsert(AbstractProgramNode toInsert, AbstractProgramNode parent, int index) {
        if (!SpecialSequenceNode.SpecialSequenceType.AFTER_END.matches(toInsert) && !SpecialSequenceNode.SpecialSequenceType.BEFORE_POINT.matches(toInsert)) {
            return true;
        }
        if (!(parent instanceof WithBeforeAndAfter)) {
            return false;
        }
        WithBeforeAndAfter withAfterNodeSupport = (WithBeforeAndAfter)parent;
        if (toInsert.getParent() != null) {
            return false;
        }
        if (this.afterEndNodeAlreadyExists(toInsert, withAfterNodeSupport)) {
            return false;
        }
        if (this.beforePointNodeAlreadyExists(toInsert, withAfterNodeSupport)) {
            return false;
        }
        if (this.afterEndNodeCorrectPosition(toInsert, parent, index)) {
            return true;
        }
        return this.beforePointCorrectPosition(toInsert, parent, index, withAfterNodeSupport);
    }

    private boolean afterEndNodeAlreadyExists(AbstractProgramNode toInsert, WithBeforeAndAfter withAfterNodeSupport) {
        return SpecialSequenceNode.SpecialSequenceType.AFTER_END.matches(toInsert) && withAfterNodeSupport.getAfterEndSequence() != null;
    }

    private boolean beforePointNodeAlreadyExists(AbstractProgramNode toInsert, WithBeforeAndAfter withAfterNodeSupport) {
        return SpecialSequenceNode.SpecialSequenceType.BEFORE_POINT.matches(toInsert) && withAfterNodeSupport.getBeforeStartSequence() != null;
    }

    private boolean afterEndNodeCorrectPosition(AbstractProgramNode toInsert, AbstractProgramNode parent, int index) {
        return SpecialSequenceNode.SpecialSequenceType.AFTER_END.matches(toInsert) && parent.getChildCount() == index;
    }

    private boolean beforePointCorrectPosition(AbstractProgramNode toInsert, AbstractProgramNode parent, int index, WithBeforeAndAfter withAfterNodeSupport) {
        return SpecialSequenceNode.SpecialSequenceType.BEFORE_POINT.matches(toInsert) && parent.getChildCount() - (withAfterNodeSupport.getAfterEndSequence() != null ? 1 : 0) == index;
    }

    public String getErrorMessage(AbstractProgramNode toInsert, AbstractProgramNode parent, int index) {
        return LanguagePack.getTextResource().nodeIsNotAllowedHere(toInsert.toString());
    }
}

